/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.openrdf.util.xml.XmlUtil;

public class XmlWriter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Writer _writer;
    private String _charEncoding;
    private boolean _prettyPrint = false;
    private int _indentLevel = 0;
    private String _indentString = "\t";
    private ArrayList _attNames = new ArrayList();
    private HashMap _attValues = new HashMap();

    public XmlWriter(Writer writer) {
        this._writer = writer;
    }

    public XmlWriter(OutputStream outputStream) {
        try {
            this._charEncoding = "UTF-8";
            this._writer = new OutputStreamWriter(outputStream, this._charEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 character encoding not supported on this platform");
        }
    }

    public XmlWriter(OutputStream outputStream, String charEncoding) throws UnsupportedEncodingException {
        this._charEncoding = charEncoding;
        this._writer = new OutputStreamWriter(outputStream, this._charEncoding);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this._prettyPrint = prettyPrint;
    }

    public boolean prettyPrintEnabled() {
        return this._prettyPrint;
    }

    public void setIndentString(String indentString) {
        this._indentString = indentString;
    }

    public String getIndentString() {
        return this._indentString;
    }

    public void startDocument() throws IOException {
        this._write("<?xml version='1.0'");
        if (this._charEncoding != null) {
            this._write(" encoding='" + this._charEncoding + "'");
        }
        this._writeLn("?>");
    }

    public void endDocument() throws IOException {
        this._writer.flush();
        this._writer = null;
    }

    public void setAttribute(String name, String value) {
        this._attNames.add(name);
        this._attValues.put(name, value);
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void startTag(String elName) throws IOException {
        this._writeIndent();
        this._write("<" + elName);
        this._writeAtts();
        this._writeLn(">");
        ++this._indentLevel;
    }

    public void endTag(String elName) throws IOException {
        --this._indentLevel;
        this._writeIndent();
        this._writeLn("</" + elName + ">");
    }

    public void emptyElement(String elName) throws IOException {
        this._writeIndent();
        this._write("<" + elName);
        this._writeAtts();
        this._writeLn("/>");
    }

    public void textElement(String elName, String text) throws IOException {
        this._writeIndent();
        this._write("<" + elName);
        this._writeAtts();
        this._write(">");
        this.text(text);
        this._writeLn("</" + elName + ">");
    }

    public void unescapedTextElement(String elName, String text) throws IOException {
        this._writeIndent();
        this._write("<" + elName);
        this._writeAtts();
        this._write(">");
        this._write(text);
        this._writeLn("</" + elName + ">");
    }

    public void textElement(String elName, int value) throws IOException {
        this.textElement(elName, String.valueOf(value));
    }

    public void textElement(String elName, boolean value) throws IOException {
        this.textElement(elName, String.valueOf(value));
    }

    public void text(String text) throws IOException {
        this._write(XmlUtil.escapeChars(text));
    }

    public void comment(String comment) throws IOException {
        this._writeIndent();
        this._writeLn("<!-- " + comment + " -->");
    }

    public void emptyLine() throws IOException {
        this._writeLn("");
    }

    private void _writeAtts() throws IOException {
        for (int i = 0; i < this._attNames.size(); ++i) {
            String name = (String)this._attNames.get(i);
            String value = (String)this._attValues.get(name);
            this._write(" " + name + "='");
            if (value != null) {
                this._write(XmlUtil.escapeChars(value));
            }
            this._write("'");
        }
        this._attNames.clear();
        this._attValues.clear();
    }

    protected void _write(String s) throws IOException {
        this._writer.write(s);
    }

    protected void _writeLn(String s) throws IOException {
        this._write(s);
        if (this._prettyPrint) {
            this._writer.write(LINE_SEPARATOR);
        }
    }

    protected void _writeIndent() throws IOException {
        if (this._prettyPrint) {
            for (int i = 0; i < this._indentLevel; ++i) {
                this._writer.write(this._indentString);
            }
        }
    }
}

