/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FilePart {
    protected String _name;
    protected String _contentType;
    protected byte[] _contents = null;

    public FilePart(String name, String contentType, byte[] contents) {
        if (contents == null) {
            throw new IllegalArgumentException("contents can not be null");
        }
        this._name = name;
        this._contentType = contentType == null ? "application/octet-stream" : contentType;
        this._contents = contents;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this._contents);
    }

    public int size() {
        return this._contents.length;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getName() {
        return this._name;
    }

    public byte[] getBytes() {
        return this._contents;
    }
}

