package org.objectweb.proactive.core.remoteobject.ibis;

import ibis.rmi.*;
import ibis.rmi.impl.RTS;
import java.lang.reflect.*;
import ibis.ipl.*;
import java.io.IOException;
import colobus.Colobus;

public final class rmi_skeleton_IbisRemoteObjectImpl extends ibis.rmi.impl.Skeleton {

	private ibis.util.Timer timer_0;

	private static final Colobus colobus = Colobus.getColobus(rmi_skeleton_IbisRemoteObjectImpl.class.getName());

	public rmi_skeleton_IbisRemoteObjectImpl() {
		stubType = "org.objectweb.proactive.core.remoteobject.ibis.rmi_stub_IbisRemoteObjectImpl";
		timer_0 = RTS.createRMITimer(this.toString() + "_receiveMessage_" + 0);
	}

	public final void upcall(ReadMessage r, int method, int stubID) throws ibis.rmi.RemoteException {


		RTS.setClientHost(r.origin().ibis().toString());
		Exception ex = null;

		switch(method) {
		case 0: /* method receiveMessage */
		{
			long handle = colobus.fireStartEvent("RMI parameter deserialization of method receiveMessage");
			RTS.startRMITimer(timer_0);
			/* First - Extract the parameters */
			org.objectweb.proactive.core.body.request.Request p0;
			try {
				p0 = (org.objectweb.proactive.core.body.request.Request) r.readObject();
			colobus.fireStopEvent(handle, "RMI parameter deserialization of method receiveMessage");
				r.finish();
			} catch(ClassNotFoundException e) {
			colobus.fireStopEvent(handle, "RMI parameter deserialization of method receiveMessage");
				throw new ibis.rmi.UnmarshalException("error unmarshalling arguments", e);
			} catch(IOException e) {
			colobus.fireStopEvent(handle, "RMI parameter deserialization of method receiveMessage");
				throw new ibis.rmi.UnmarshalException("error unmarshalling arguments", e);
			}

			handle = colobus.fireStartEvent("RMI user method invocation of method receiveMessage");
			/* Second - Invoke the method */
			org.objectweb.proactive.core.body.reply.Reply result = null;
			try {
				result = ((IbisRemoteObjectImpl) destination).receiveMessage(p0);
			} catch (RuntimeException e) {
				ex = new ibis.rmi.ServerRuntimeException("server runtime exception", e);
			} catch (Error e) {
				ex = new ibis.rmi.ServerError("server error", e);
			} catch (Exception e) {
				ex = e;
			}
			RTS.stopRMITimer(timer_0);
			colobus.fireStopEvent(handle, "RMI user method invocation of method receiveMessage");
			handle = colobus.fireStartEvent("RMI reply message of method receiveMessage");
			WriteMessage w;
			try {
				w = stubs[stubID].newMessage();
			} catch(IOException e) {
				colobus.fireStopEvent(handle, "RMI reply message of method receiveMessage");
				throw new ibis.rmi.MarshalException("error marshalling return", e);
			}
			try {
				if (ex != null) {
					w.writeByte(RTS.EXCEPTION);
					w.writeObject(ex);
				} else {
					w.writeByte(RTS.RESULT);
					w.writeObject(result);
				}
				w.finish();
			} catch(IOException e) {
				w.finish(e);
				colobus.fireStopEvent(handle, "RMI reply message of method receiveMessage");
				throw new ibis.rmi.MarshalException("error marshalling return", e);
			}
			colobus.fireStopEvent(handle, "RMI reply message of method receiveMessage");
			break;
		}

		case -1:
		{
			/* Special case: new stub connecting */
			ReceivePortIdentifier rpi;
			try {
				rpi = (ReceivePortIdentifier) r.readObject();
				r.finish();
			} catch(ClassNotFoundException e) {
				throw new ibis.rmi.UnmarshalException("while reading ReceivePortIdentifier", e);
			} catch(IOException e) {
				r.finish(e);
				throw new ibis.rmi.UnmarshalException("while reading ReceivePortIdentifier", e);
			}
			int id = addStub(rpi);
			WriteMessage w;
			try {
				w = stubs[id].newMessage();
			} catch(IOException e) {
				throw new ibis.rmi.MarshalException("error sending skeletonId", e);
			}
			try {
				w.writeInt(id);
				w.writeInt(skeletonId);
				w.writeObject(destination);
				w.finish();
			} catch(IOException e) {
				w.finish(e);
				throw new ibis.rmi.MarshalException("error sending skeletonId", e);
			}
			break;
		}

		default:
			throw new ibis.rmi.UnmarshalException("invalid method number");
		}

	}

}

