/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.utils;

import java.util.List;

public final class UnicodeUtils {
    public static int compareUtf32(String s1, String s2) {
        int[] cpts1 = UnicodeUtils.toCodePointArray(s1);
        int[] cpts2 = UnicodeUtils.toCodePointArray(s2);
        int len1 = cpts1.length;
        int len2 = cpts2.length;
        int min = Math.min(len1, len2);
        for (int i = 0; i < min; ++i) {
            int c1 = cpts1[i];
            int c2 = cpts2[i];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static String toStringUtf32(String string) {
        return UnicodeUtils.toStringUtf32(UnicodeUtils.toCodePointArray(string));
    }

    public static String toStringUtf32(int ... codePoints) {
        StringBuilder result = new StringBuilder(codePoints.length);
        for (int codePoint : codePoints) {
            result.append(UnicodeUtils.getScalarValue(codePoint, true));
        }
        return result.toString();
    }

    public static String toStringUtf16(String string) {
        return UnicodeUtils.toStringUtf16(UnicodeUtils.toCodePointArray(string));
    }

    public static String toStringUtf16(int ... codePoints) {
        StringBuilder result = new StringBuilder(codePoints.length);
        for (int codePoint : codePoints) {
            result.append(UnicodeUtils.getScalarValueUtf16(codePoint));
        }
        return result.toString();
    }

    public static String getScalarValueUtf16(int codePoint) {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            return UnicodeUtils.getScalarValue(UnicodeUtils.highSurrogate(codePoint), false) + UnicodeUtils.getScalarValue(UnicodeUtils.lowSurrogate(codePoint), false);
        }
        return UnicodeUtils.getScalarValue(codePoint, false);
    }

    private static String getScalarValue(int codePoint, boolean maybeSupplementaryCharacter) {
        if (!Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException("Invalid code point: " + codePoint);
        }
        String hexValue = Integer.toHexString(codePoint);
        int nbZeros = 4 - hexValue.length();
        if (maybeSupplementaryCharacter) {
            nbZeros = 6 - hexValue.length();
        }
        StringBuilder result = new StringBuilder("\\u");
        for (int i = 0; i < nbZeros; ++i) {
            result.append('0');
        }
        result.append(hexValue.toUpperCase());
        return result.toString();
    }

    public static char highSurrogate(int codePoint) {
        return (char)((codePoint >>> 10) + 55232);
    }

    public static char lowSurrogate(int codePoint) {
        return (char)((codePoint & 0x3FF) + 56320);
    }

    public static int[] toCodePointArray(String string) {
        char[] sarray = string.toCharArray();
        int[] result = new int[Character.codePointCount(sarray, 0, sarray.length)];
        int j = 0;
        int codePoint = 0;
        for (int i = 0; i < sarray.length; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(sarray, i);
            result[j++] = codePoint;
        }
        return result;
    }

    public static String toString(int ... codePoints) {
        return new String(codePoints, 0, codePoints.length);
    }

    public static String toString(List<Integer> codePoints) {
        int[] cpa = new int[codePoints.size()];
        for (int i = 0; i < codePoints.size(); ++i) {
            cpa[i] = codePoints.get(i);
        }
        return UnicodeUtils.toString(cpa);
    }
}

