/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.utils;

public final class SystemUtils {
    private static final int numProcessors;
    private static final String architecture;
    private static final String osName;
    private static final String osVersion;
    private static final boolean windows;
    private static final boolean linux;
    private static final boolean osx;

    private SystemUtils() {
    }

    public static final String architecture() {
        return architecture;
    }

    public static final int numProcessors() {
        return numProcessors;
    }

    public static final String operatingSystem() {
        return osName;
    }

    public static final String osVersion() {
        return osVersion;
    }

    public static final boolean isWindows() {
        return windows;
    }

    public static final boolean isLinux() {
        return linux;
    }

    public static final boolean isOsX() {
        return osx;
    }

    public static int getOptimalNumberOfThreads(double systemLoad, double ratio) {
        return (int)Math.round((double)Runtime.getRuntime().availableProcessors() * systemLoad * (1.0 + ratio));
    }

    public static int getOptimalNumberOfThreads() {
        return SystemUtils.getOptimalNumberOfThreads(1.0, 0.0);
    }

    static {
        architecture = System.getProperty("os.arch");
        osName = System.getProperty("os.name");
        osVersion = System.getProperty("os.version");
        numProcessors = Runtime.getRuntime().availableProcessors();
        windows = SystemUtils.operatingSystem().startsWith("Windows");
        linux = SystemUtils.operatingSystem().startsWith("Linux");
        osx = SystemUtils.operatingSystem().startsWith("Mac");
    }
}

