/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.utils;

import com.google.common.base.Function;
import java.util.Arrays;
import org.objectweb.proactive.extensions.p2p.structured.utils.UnicodeUtils;

public enum StringRepresentation {
    CODE_POINTS("codepoints", new Function<String, String>(){

        public String apply(String value) {
            return Arrays.toString(UnicodeUtils.toCodePointArray(value));
        }
    }),
    UTF_16("utf16", new Function<String, String>(){

        public String apply(String value) {
            return UnicodeUtils.toStringUtf16(value);
        }
    }),
    UTF_32("utf32", new Function<String, String>(){

        public String apply(String value) {
            return UnicodeUtils.toStringUtf32(value);
        }
    }),
    STRING("string", new Function<String, String>(){

        public String apply(String value) {
            return value;
        }
    });

    public String name;
    public Function<String, String> transformer;

    private StringRepresentation(String name, Function<String, String> transformer) {
        this.name = name;
        this.transformer = transformer;
    }

    public String getName() {
        return this.name;
    }

    public String apply(String value) {
        return (String)this.transformer.apply((Object)value);
    }

    public static StringRepresentation getInstance(String name) {
        for (StringRepresentation representation : StringRepresentation.values()) {
            if (!representation.name.equalsIgnoreCase(name)) continue;
            return representation;
        }
        throw new IllegalArgumentException("Unknown string representation: " + name);
    }
}

