/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.utils;

import java.io.IOException;
import java.io.Serializable;
import org.objectweb.proactive.extensions.p2p.structured.utils.converters.ByteToObjectConverter;
import org.objectweb.proactive.extensions.p2p.structured.utils.converters.ObjectToByteConverter;

public class SerializedValue<T>
implements Serializable {
    private static final long serialVersionUID = 130L;
    private byte[] bytes;
    private transient T value;

    protected SerializedValue(T value) {
        try {
            this.bytes = ObjectToByteConverter.convert(value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> SerializedValue<T> create(T value) {
        return new SerializedValue<T>(value);
    }

    public synchronized T getValue() {
        if (this.value == null) {
            try {
                this.value = ByteToObjectConverter.convert(this.bytes);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.value;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

