/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.utils;

import java.util.Random;

public class RandomUtils {
    public static final Random JVM_RANDOM = new Random();

    private RandomUtils() {
    }

    public static void nextBytes(byte[] bytes) {
        JVM_RANDOM.nextBytes(bytes);
    }

    public static int nextInt() {
        return JVM_RANDOM.nextInt();
    }

    public static int nextInt(int n) {
        return JVM_RANDOM.nextInt(n);
    }

    public static long nextLong() {
        return JVM_RANDOM.nextLong();
    }

    public static boolean nextBoolean() {
        return JVM_RANDOM.nextBoolean();
    }

    public static float nextFloat() {
        return JVM_RANDOM.nextFloat();
    }

    public static double nextDouble() {
        return JVM_RANDOM.nextDouble();
    }

    public static double nextGaussian() {
        return JVM_RANDOM.nextGaussian();
    }

    public static int nextIntClosed(int lower, int upper) {
        RandomUtils.checkBounds(lower, upper);
        return lower + JVM_RANDOM.nextInt(upper - lower + 1);
    }

    public static int nextIntClosedOpen(int lower, int upper) {
        RandomUtils.checkBounds(lower, upper);
        return lower + JVM_RANDOM.nextInt(upper - lower);
    }

    public static int nextIntOpen(int lower, int upper) {
        RandomUtils.checkBounds(lower, upper);
        return lower - 1 + JVM_RANDOM.nextInt(upper - lower);
    }

    public static int nextIntOpenClosed(int lower, int upper) {
        RandomUtils.checkBounds(lower, upper);
        return lower - 1 + JVM_RANDOM.nextInt(upper - lower + 1);
    }

    private static void checkBounds(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("Invalid range: lower > upper");
        }
    }
}

