/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.utils;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Observable<T> {
    private final ConcurrentHashMap<T, Long> observers;

    public Observable() {
        this(16);
    }

    public Observable(int initialCapacity) {
        this.observers = new ConcurrentHashMap(initialCapacity, 0.75f, 2);
    }

    public void register(T observer) {
        this.observers.putIfAbsent(observer, System.currentTimeMillis());
    }

    public void unregister(T observer) {
        this.observers.remove(observer);
    }

    public long getRegistrationTime(T observer) {
        Long result = this.observers.get(observer);
        if (result == null) {
            return -1L;
        }
        return result;
    }

    public Set<T> getObservers() {
        return this.observers.keySet();
    }

    public void notify(NotificationAction<T> action) {
        for (Object observer : this.observers.keySet()) {
            action.execute(observer);
        }
    }

    public static abstract class NotificationAction<T> {
        public abstract void execute(T var1);
    }
}

