/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.utils;

import java.util.concurrent.Callable;

public class MicroBenchmark {
    private final int nbRuns;
    private final Callable<Long> benchmark;
    private boolean discardFirstRun = true;
    private boolean showProgress = false;
    private long mean;

    public MicroBenchmark(int nbRuns, Callable<Long> task) {
        this.nbRuns = nbRuns;
        this.benchmark = task;
    }

    public void doNotDiscardFirstRun() {
        this.discardFirstRun = false;
    }

    public void showProgress() {
        this.showProgress = true;
    }

    public void execute() {
        this.mean = 0L;
        long[] times = new long[this.nbRuns];
        for (int i = 0; i < (this.discardFirstRun ? this.nbRuns + 1 : this.nbRuns); ++i) {
            long executionTime;
            try {
                executionTime = this.benchmark.call();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            if (this.discardFirstRun && i > 0) {
                times[i - 1] = executionTime;
            } else if (!this.discardFirstRun) {
                times[i] = executionTime;
            }
            if (!this.showProgress) continue;
            System.out.print("Run #" + (i + 1) + " performed");
            if (this.discardFirstRun && i == 0) {
                System.out.println(" (ignored)");
                continue;
            }
            System.out.println();
        }
        long sum = 0L;
        for (int i = 0; i < times.length; ++i) {
            sum += times[i];
        }
        this.mean = sum / (long)this.nbRuns;
    }

    public long getMean() {
        return this.mean;
    }

    public int getNbRuns() {
        return this.nbRuns;
    }
}

