/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.etsi.uri.gcm.util.GCM;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.proactive.core.component.Fractive;
import org.objectweb.proactive.core.component.adl.FactoryFactory;
import org.objectweb.proactive.core.config.CentralPAPropertyRepository;
import org.objectweb.proactive.core.node.Node;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.gcmdeployment.GCMVirtualNode;

public class ComponentUtils {
    private static Factory factory;
    private static Factory nfFactory;

    public static Map<String, Object> createContext(Node node) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (node != null) {
            ArrayList<Node> nodeList = new ArrayList<Node>(1);
            nodeList.add(node);
            context.put("nodes", nodeList);
        }
        return context;
    }

    public static Map<String, Object> createContext(GCMVirtualNode vn) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (vn != null) {
            context.put(vn.getName(), vn);
        }
        return context;
    }

    public static <T> T createComponentAndGetInterface(String componentAdl, Map<String, Object> context, String interfaceName, Class<T> interfaceClass, boolean toStart) {
        return ComponentUtils.createComponentAndGetInterface(factory, componentAdl, context, interfaceName, interfaceClass, toStart);
    }

    public static <T> T createNfComponentAndGetInterface(String componentAdl, Map<String, Object> context, String interfaceName, Class<T> interfaceClass, boolean toStart) {
        return ComponentUtils.createComponentAndGetInterface(nfFactory, componentAdl, context, interfaceName, interfaceClass, toStart);
    }

    private static <T> T createComponentAndGetInterface(Factory factory, String componentAdl, Map<String, Object> context, String interfaceName, Class<T> interfaceClass, boolean toStart) {
        try {
            Component component = (Component)factory.newComponent(componentAdl, context);
            if (toStart) {
                GCM.getGCMLifeCycleController((Component)component).startFc();
            }
            return interfaceClass.cast(component.getFcInterface(interfaceName));
        }
        catch (ADLException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalLifeCycleException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T lookupFcInterface(String componentUri, String interfaceName, Class<T> interfaceClass) throws IOException {
        try {
            return interfaceClass.cast(Fractive.lookup((String)componentUri).getFcInterface(interfaceName));
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NamingException e) {
            throw new IOException(e);
        }
    }

    public static <T> void terminateComponents(List<T> stubs) {
        for (T stub : stubs) {
            ComponentUtils.terminateComponent(stub);
        }
    }

    public static <T> void terminateComponent(T stub) {
        try {
            Component component = ((Interface)stub).getFcItfOwner();
            GCM.getGCMLifeCycleController((Component)component).stopFc();
            GCM.getGCMLifeCycleController((Component)component).terminateGCMComponent();
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalLifeCycleException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        CentralPAPropertyRepository.GCM_PROVIDER.setValue((String)P2PStructuredProperties.GCM_PROVIDER.getValue());
        try {
            factory = FactoryFactory.getFactory();
            nfFactory = FactoryFactory.getNFFactory();
        }
        catch (ADLException e) {
            e.printStackTrace();
        }
    }
}

