/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.utils;

import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.Apint;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.utils.UnicodeUtils;

public class ApfloatUtils {
    public static long DEFAULT_PRECISION = 350L;
    private static final Apint RADIX = new Apint((long)((Integer)P2PStructuredProperties.CAN_UPPER_BOUND.getValue() + 1));

    public static Apfloat toFloatRadix10(String value) {
        return ApfloatUtils.toFloatRadix10(value, RADIX);
    }

    public static Apfloat toFloatRadix10(String value, Apint radix) {
        return ApfloatUtils.toFloatRadix10(value, radix, DEFAULT_PRECISION);
    }

    public static Apfloat toFloatRadix10(String value, long precision) {
        return ApfloatUtils.toFloatRadix10(value, RADIX, precision);
    }

    public static Apfloat toFloatRadix10(String value, Apint radix, long precision) {
        int[] codepoints = UnicodeUtils.toCodePointArray(value);
        Apfloat result = new Apfloat((long)codepoints[0], precision);
        Apint pow = new Apint(1L);
        for (int i = 1; i < codepoints.length; ++i) {
            pow = pow.multiply(radix);
            Apfloat division = new Apfloat(1L, precision).divide((Apfloat)pow);
            result = result.add(new Apfloat((long)codepoints[i], precision).multiply(division));
            if (precision > 0L && (long)i == precision) break;
        }
        return result;
    }

    public static String toString(Apfloat apfloat) {
        return ApfloatUtils.toString(apfloat, DEFAULT_PRECISION);
    }

    public static String toString(Apfloat apfloat, long precision) {
        Apint apint;
        Apint quotient = apint = apfloat.truncate();
        StringBuilder integerPart = new StringBuilder();
        quotient = ApfloatUtils.divideQuotientRecursively(integerPart, quotient);
        integerPart.reverse();
        Apfloat fractionalPart = ApfloatMath.modf((Apfloat)apfloat)[1];
        int loop = 0;
        while (fractionalPart.compareTo((Apfloat)Apfloat.ZERO) > 0 && (long)loop <= precision) {
            if ((fractionalPart = fractionalPart.multiply((Apfloat)RADIX)).compareTo((Apfloat)Apfloat.ONE) >= 0) {
                Apint truncatedPart = fractionalPart.truncate();
                integerPart.append(Character.toChars(truncatedPart.intValue()));
                fractionalPart = fractionalPart.subtract((Apfloat)truncatedPart);
            } else {
                integerPart.append('\u0000');
            }
            ++loop;
        }
        if (integerPart.length() == 0) {
            integerPart.append('\u0000');
        }
        return integerPart.toString();
    }

    private static Apint divideQuotientRecursively(StringBuilder result, Apint quotient) {
        while (quotient.compareTo(Apint.ZERO) != 0) {
            int remainder = quotient.mod(RADIX).intValue();
            result.append(new String(Character.toChars(remainder)));
            quotient = quotient.divide(RADIX);
        }
        return quotient;
    }
}

