/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.configuration;

import org.objectweb.proactive.extensions.p2p.structured.configuration.Property;
import org.objectweb.proactive.extensions.p2p.structured.configuration.Validator;

public class PropertyCharacterUnicode
extends Property<Integer> {
    public PropertyCharacterUnicode(String name, String defaultValue) {
        super(name, PropertyCharacterUnicode.computeScalarValue(defaultValue));
    }

    public PropertyCharacterUnicode(String name, String defaultValue, Validator<Integer> validator) {
        super(name, PropertyCharacterUnicode.computeScalarValue(defaultValue), validator);
    }

    @Override
    public Integer parse(String value) {
        return PropertyCharacterUnicode.computeScalarValue(value);
    }

    public String getValueAsString() {
        return new String(Character.toChars((Integer)this.value));
    }

    private static int computeScalarValue(String unicodeCharacter) {
        if (!unicodeCharacter.isEmpty()) {
            int codePoint = unicodeCharacter.codePointAt(0);
            if (Character.isValidCodePoint(codePoint)) {
                if (unicodeCharacter.length() == 1 || Character.isSupplementaryCodePoint(codePoint) && unicodeCharacter.length() == 2) {
                    return codePoint;
                }
                throw new IllegalArgumentException("Only one unicode character is allowed: " + unicodeCharacter);
            }
            throw new IllegalArgumentException("Illegal unicode character specified: " + unicodeCharacter);
        }
        throw new IllegalArgumentException("Empty string is not allowed");
    }
}

