/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.configuration;

import org.objectweb.proactive.extensions.p2p.structured.configuration.Validator;

public abstract class Property<T> {
    protected final String name;
    protected final T defaultValue;
    protected T value;
    protected final Validator<T> validator;

    protected Property(String name, T defaultValue) {
        this(name, defaultValue, null);
    }

    protected Property(String name, T defaultValue, Validator<T> validator) {
        if (validator != null) {
            validator.checkValidity(name, defaultValue);
        }
        this.name = name;
        this.defaultValue = defaultValue;
        this.validator = validator;
        String javaProperty = System.getProperty(this.name);
        if (javaProperty != null) {
            this.setValueAsString(javaProperty);
        } else {
            this.value = defaultValue;
        }
    }

    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        if (this.validator != null) {
            this.validator.checkValidity(this.name, value);
        }
        this.value = value;
    }

    public void setValueAsString(String value) {
        this.setValue(this.parse(value));
    }

    protected abstract T parse(String var1);

    public String toString() {
        return this.name + "=" + this.value;
    }
}

