/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectweb.proactive.extensions.p2p.structured.configuration.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationParser.class);

    public static File load(Class<?> classProperties, String javaPropertyName, String defaultPreferencesFile) {
        File configurationFile;
        if (System.getProperty(javaPropertyName) != null && (configurationFile = new File(System.getProperty(javaPropertyName))).exists()) {
            ConfigurationParser.load(configurationFile, classProperties);
        } else {
            configurationFile = new File(defaultPreferencesFile);
            if (configurationFile.exists()) {
                ConfigurationParser.load(configurationFile, classProperties);
            }
        }
        return configurationFile;
    }

    private static void load(File configurationFile, Class<?> classProperties) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(configurationFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, String> properties = ConfigurationParser.findProperties(classProperties);
        for (String propertyName : props.stringPropertyNames()) {
            if (properties.containsKey(propertyName)) {
                try {
                    ((Property)classProperties.getField(properties.get(propertyName)).get(null)).setValueAsString(props.getProperty(propertyName));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                log.info("Property '{}' has been loaded with value '{}'", (Object)propertyName, (Object)props.getProperty(propertyName));
                continue;
            }
            log.warn("Skipped unknown property: " + propertyName);
        }
    }

    private static Map<String, String> findProperties(Class<?> classProperties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Field field : classProperties.getFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Property.class.isAssignableFrom(field.getType())) continue;
            try {
                Property fieldInstance = (Property)field.get(null);
                result.put(fieldInstance.name, field.getName());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

