/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.router.can;

import org.objectweb.proactive.core.ProActiveRuntimeException;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.messages.response.Response;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.NeighborEntry;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates.Coordinate;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.router.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicastResponseRouter<T extends Response<Coordinate<E>>, E extends Element>
extends Router<T, Coordinate<E>> {
    private static final Logger logger = LoggerFactory.getLogger(UnicastResponseRouter.class);

    public void makeDecision(StructuredOverlay overlay, T response) {
        if (response.validatesKeyConstraints(overlay)) {
            this.handle(overlay, response);
        } else {
            this.route(overlay, response);
        }
    }

    protected void handle(StructuredOverlay overlay, T response) {
        logger.debug("The peer {} contains the key to reach {}", (Object)overlay, response.getKey());
        overlay.getRequestResponseManager().pushFinalResponse(response);
    }

    protected void route(StructuredOverlay overlay, T response) {
        byte dimension;
        CanOverlay overlayCAN = (CanOverlay)overlay;
        byte direction = -1;
        for (dimension = 0; dimension < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dimension = (byte)(dimension + 1)) {
            direction = overlayCAN.getZone().contains(dimension, ((Coordinate)response.getKey()).getElement(dimension));
            if (direction == -1) {
                direction = 0;
                break;
            }
            if (direction != 1) continue;
            direction = 1;
            break;
        }
        NeighborEntry neighborChosen = overlayCAN.nearestNeighbor((Coordinate)response.getKey(), dimension, direction);
        if (logger.isDebugEnabled()) {
            logger.debug("The message is routed to a neigbour because the current peer managing " + overlay + " does not contains the key to reach " + response.getKey() + ". Neighbor is selected from dimension " + dimension + " and direction " + direction + ": " + neighborChosen);
        }
        try {
            response.incrementHopCount(1);
            neighborChosen.getStub().route(response);
        }
        catch (ProActiveRuntimeException e) {
            logger.error("Error while sending the message to the neighbor managing {}", neighborChosen.getZone());
            e.printStackTrace();
        }
    }
}

