/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.router.can;

import org.objectweb.proactive.core.ProActiveRuntimeException;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.messages.RequestResponseMessage;
import org.objectweb.proactive.extensions.p2p.structured.messages.ResponseEntry;
import org.objectweb.proactive.extensions.p2p.structured.messages.request.Request;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.NeighborEntry;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates.Coordinate;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.router.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicastRequestRouter<T extends Request<Coordinate<E>>, E extends Element>
extends Router<T, Coordinate<E>> {
    private static final Logger logger = LoggerFactory.getLogger(UnicastRequestRouter.class);

    public void makeDecision(StructuredOverlay overlay, T request) {
        if (request.getHopCount() == 0 && request.getResponseProvider() != null) {
            overlay.getResponseEntries().put(request.getId(), new ResponseEntry(1));
        }
        if (request.validatesKeyConstraints(overlay)) {
            this.handle(overlay, request);
        } else {
            this.route(overlay, request);
        }
    }

    protected void handle(StructuredOverlay overlay, T request) {
        if (logger.isDebugEnabled()) {
            logger.debug("Peer " + overlay + " validates the contraints " + request.getKey() + " specified by request " + request.getId());
        }
        this.onDestinationReached(overlay, (RequestResponseMessage)request);
        if (request.getResponseProvider() != null) {
            request.getResponseProvider().get(request, overlay).route(overlay);
        }
    }

    protected void route(StructuredOverlay overlay, T request) {
        byte dimension;
        CanOverlay overlayCAN = (CanOverlay)overlay;
        byte direction = -1;
        for (dimension = 0; dimension < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dimension = (byte)(dimension + 1)) {
            direction = overlayCAN.getZone().contains(dimension, ((Coordinate)request.getKey()).getElement(dimension));
            if (direction == -1) {
                direction = 0;
                break;
            }
            if (direction != 1) continue;
            direction = 1;
            break;
        }
        NeighborEntry neighborChosen = overlayCAN.nearestNeighbor((Coordinate)request.getKey(), dimension, direction);
        if (logger.isDebugEnabled()) {
            logger.debug("Message routed to a neigbour because the current peer managing " + overlay + " does not contains the key to reach (" + request.getKey() + "). Neighbor is selected from dimension " + dimension + " and direction " + direction + ": " + neighborChosen);
        }
        try {
            request.incrementHopCount(1);
            neighborChosen.getStub().route(request);
        }
        catch (ProActiveRuntimeException e) {
            logger.error("Error while sending the message to the neighbor managing " + neighborChosen.getZone());
            e.printStackTrace();
        }
    }
}

