/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.router.can;

import org.objectweb.proactive.extensions.p2p.structured.messages.AnycastRoutingEntry;
import org.objectweb.proactive.extensions.p2p.structured.messages.ResponseEntry;
import org.objectweb.proactive.extensions.p2p.structured.messages.response.can.AnycastResponse;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates.Coordinate;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.router.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnycastResponseRouter<T extends AnycastResponse<E>, E extends Element>
extends Router<AnycastResponse<E>, Coordinate<E>> {
    private static final Logger logger = LoggerFactory.getLogger(AnycastResponseRouter.class);

    public void makeDecision(StructuredOverlay overlay, AnycastResponse<E> response) {
        ResponseEntry entry = overlay.getResponseEntry(response.getId());
        AnycastResponse<E> localResponse = (AnycastResponse<E>)entry.getResponse();
        localResponse = AnycastResponse.merge(localResponse, response);
        entry.setResponse(localResponse);
        entry.incrementResponsesCount(1);
        if (entry.getStatus() == ResponseEntry.Status.RECEIPT_COMPLETED) {
            localResponse.synchronizationPointUnlocked(overlay);
            if (localResponse.getAnycastRoutingList().size() == 0) {
                this.handle(overlay, localResponse);
            } else {
                logger.debug("All subreplies received on {} for request {}", (Object)overlay, (Object)response.getId());
                this.route(overlay, localResponse);
                overlay.getRequestResponseManager().getResponsesReceived().remove(localResponse.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(StructuredOverlay overlay, AnycastResponse<E> response) {
        ResponseEntry entry;
        response.setOutboundHopCount(response.getInboundHopCount());
        ResponseEntry responseEntry = entry = (ResponseEntry)overlay.getResponseEntries().get(response.getId());
        synchronized (responseEntry) {
            entry.notifyAll();
        }
    }

    protected void route(StructuredOverlay overlay, AnycastResponse<E> response) {
        AnycastRoutingEntry entry = (AnycastRoutingEntry)response.getAnycastRoutingList().removeLast();
        response.incrementHopCount(1);
        if (logger.isDebugEnabled()) {
            logger.debug("Routing response " + response.getId() + " from " + overlay + " to " + entry.getPeerStub());
        }
        entry.getPeerStub().route(response);
    }
}

