/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.router.can;

import java.util.Iterator;
import org.objectweb.proactive.core.ProActiveRuntimeException;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.messages.AnycastRoutingEntry;
import org.objectweb.proactive.extensions.p2p.structured.messages.RequestResponseMessage;
import org.objectweb.proactive.extensions.p2p.structured.messages.ResponseEntry;
import org.objectweb.proactive.extensions.p2p.structured.messages.request.can.AnycastRequest;
import org.objectweb.proactive.extensions.p2p.structured.messages.response.can.AnycastResponse;
import org.objectweb.proactive.extensions.p2p.structured.overlay.Peer;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanRequestResponseManager;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.NeighborEntry;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.NeighborTable;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates.Coordinate;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.router.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnycastRequestRouter<T extends AnycastRequest<E>, E extends Element>
extends Router<AnycastRequest<E>, Coordinate<E>> {
    private static final Logger logger = LoggerFactory.getLogger(AnycastRequestRouter.class);

    public void onPeerValidatingKeyConstraints(CanOverlay<E> overlay, AnycastRequest<E> request) {
    }

    public void makeDecision(StructuredOverlay overlay, AnycastRequest<E> request) {
        CanOverlay canOverlay = (CanOverlay)overlay;
        CanRequestResponseManager messagingManager = (CanRequestResponseManager)canOverlay.getRequestResponseManager();
        if (!messagingManager.receiveRequest(request.getId())) {
            logger.debug("Request {} reached peer {} which has already received it", (Object)request.getId(), (Object)canOverlay.getZone().toString());
            if (request.getResponseProvider() != null) {
                ((AnycastRoutingEntry)request.getAnycastRoutingList().removeLast()).getPeerStub().route((RequestResponseMessage)request.getResponseProvider().get(request, overlay));
            }
        } else if (request.validatesKeyConstraints(canOverlay)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request " + request.getId() + " is on peer " + overlay + " which validates constraints " + request.getKey());
            }
            this.onPeerValidatingKeyConstraints(canOverlay, request);
            this.handle(overlay, request);
        } else {
            this.route(overlay, request);
        }
    }

    protected void handle(StructuredOverlay overlay, AnycastRequest<E> request) {
        CanOverlay canOverlay = (CanOverlay)overlay;
        if (canOverlay.getNeighborTable().size() == 0) {
            super.onDestinationReached(overlay, request);
            if (request.getResponseProvider() != null) {
                overlay.getResponseEntries().put(request.getId(), new ResponseEntry(1));
                AnycastResponse response = (AnycastResponse)request.getResponseProvider().get(request, overlay);
                response.incrementHopCount(1);
                response.route(overlay);
            }
        } else {
            NeighborTable<E> neighborsToSendTo = this.getNeighborsToSendTo(canOverlay, request);
            if (neighborsToSendTo.size() == 0) {
                super.onDestinationReached(overlay, request);
                if (request.getResponseProvider() != null) {
                    AnycastResponse response = (AnycastResponse)request.getResponseProvider().get(request, overlay);
                    response.incrementHopCount(1);
                    overlay.getResponseEntries().put(response.getId(), new ResponseEntry(1));
                    response.route(overlay);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending request " + request.getId() + " to " + neighborsToSendTo.size() + " neighbor(s) from " + overlay);
                }
                ResponseEntry entry = new ResponseEntry(neighborsToSendTo.size());
                if (request.getResponseProvider() != null) {
                    overlay.getResponseEntries().put(request.getId(), entry);
                    request.getAnycastRoutingList().add(new AnycastRoutingEntry(overlay.getId(), overlay.getStub()));
                }
                for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
                    for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                        Iterator it = neighborsToSendTo.get(dim, direction).values().iterator();
                        while (it.hasNext()) {
                            Peer p = ((NeighborEntry)it.next()).getStub();
                            if (logger.isDebugEnabled()) {
                                logger.debug("Sending request " + request.getId() + " from " + overlay + " -> " + p);
                            }
                            p.route(request);
                        }
                    }
                }
            }
        }
    }

    private NeighborTable<E> getNeighborsToSendTo(CanOverlay<E> overlay, AnycastRequest<E> msg) {
        NeighborTable neighborsToSendTo = new NeighborTable();
        for (byte dimension = 0; dimension < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dimension = (byte)(dimension + 1)) {
            for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                for (NeighborEntry entry : overlay.getNeighborTable().get(dimension, direction).values()) {
                    AnycastRoutingEntry entryCommingFromSender = msg.getAnycastRoutingList().getRoutingResponseEntryBy(entry.getId());
                    if (entryCommingFromSender != null || !msg.validatesKeyConstraints(entry.getZone())) continue;
                    neighborsToSendTo.add(entry, dimension, direction);
                }
            }
        }
        return neighborsToSendTo;
    }

    protected void route(StructuredOverlay overlay, AnycastRequest<E> request) {
        byte dimension;
        CanOverlay overlayCAN = (CanOverlay)overlay;
        byte direction = -1;
        for (dimension = 0; dimension < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dimension = (byte)(dimension + 1)) {
            direction = overlayCAN.getZone().contains(dimension, ((Coordinate)request.getKey()).getElement(dimension));
            if (direction == -1) {
                direction = 0;
                break;
            }
            if (direction != 1) continue;
            direction = 1;
            break;
        }
        NeighborEntry neighborChosen = overlayCAN.nearestNeighbor((Coordinate)request.getKey(), dimension, direction);
        if (logger.isDebugEnabled()) {
            logger.debug("The message is routed to a neigbour because the current peer managing " + overlay + " does not contains the key to reach (" + request.getKey() + "). Neighbor is selected from dimension " + dimension + " and direction " + direction + ": " + neighborChosen);
        }
        try {
            if (request.getResponseProvider() != null) {
                overlay.getResponseEntries().put(request.getId(), new ResponseEntry(1));
                request.getAnycastRoutingList().add(new AnycastRoutingEntry(overlay.getId(), overlay.getStub()));
            }
            neighborChosen.getStub().route(request);
        }
        catch (ProActiveRuntimeException e) {
            logger.error("Error while sending the message to the neighbor managing " + neighborChosen.getZone());
            e.printStackTrace();
        }
    }
}

