/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements;

import org.apfloat.Apfloat;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.utils.ApfloatUtils;
import org.objectweb.proactive.extensions.p2p.structured.utils.StringRepresentation;
import org.objectweb.proactive.extensions.p2p.structured.utils.UnicodeUtils;

public class StringElement
extends Element {
    private static final long serialVersionUID = 130L;
    protected final String value;

    public StringElement(String value) {
        this.value = value;
    }

    protected StringElement(Apfloat apfloat) {
        this.value = ApfloatUtils.toString((Apfloat)apfloat);
    }

    @Override
    public StringElement middle(Element elt) {
        Apfloat e1 = ApfloatUtils.toFloatRadix10((String)this.value);
        Apfloat e2 = ApfloatUtils.toFloatRadix10((String)((StringElement)elt).value);
        return this.newStringElement(e1.add(e2).divide(new Apfloat(2L)));
    }

    protected StringElement newStringElement(Apfloat apfloat) {
        return new StringElement(apfloat);
    }

    public double normalize(double lowerBound, double upperBound) {
        if (lowerBound < 0.0) {
            throw new IllegalArgumentException("Lower bound must be positive: " + lowerBound);
        }
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("Upper bound must be greater than lower bound");
        }
        Apfloat scale = new Apfloat((upperBound - lowerBound) / (double)((Integer)P2PStructuredProperties.CAN_UPPER_BOUND.getValue()).intValue());
        return ApfloatUtils.toFloatRadix10((String)this.value).multiply(scale).add(new Apfloat(lowerBound)).doubleValue();
    }

    public StringElement clone() throws CloneNotSupportedException {
        return (StringElement)super.clone();
    }

    @Override
    public int compareTo(Element elt) {
        return UnicodeUtils.compareUtf32((String)this.value, (String)((StringElement)elt).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object that) {
        return that instanceof StringElement && this.compareTo((StringElement)that) == 0;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        String representation = (String)P2PStructuredProperties.CAN_ELEMENT_DISPLAY.getValue();
        if (representation.equalsIgnoreCase("decimal")) {
            return ApfloatUtils.toFloatRadix10((String)this.value).toString(true);
        }
        try {
            return StringRepresentation.getInstance((String)representation).apply(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid value for property " + P2PStructuredProperties.CAN_ELEMENT_DISPLAY.getName() + ": " + representation);
        }
    }

    public String toString(StringRepresentation representation) {
        return representation.apply(this.value);
    }

    public static void main(String[] args) {
        Apint radix = new Apint(65536L);
        int exponent = 2;
        Apint pow = ApintMath.pow((Apint)radix, (long)exponent);
        Apfloat result = new Apfloat(1L, Long.MIN_VALUE).divide((Apfloat)pow);
        System.out.println(result);
    }
}

