/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.utils.converters.MakeDeepCopy;

public final class Coordinate<E extends Element>
implements Cloneable,
Comparable<Coordinate<E>>,
Iterable<E>,
Serializable {
    private static final long serialVersionUID = 130L;
    private final E[] values;

    public Coordinate(E ... elements) {
        if (elements.length != (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue()) {
            throw new AssertionError((Object)("The number of coordinate elements (" + elements.length + ") is not equals to the number of dimensions (" + P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue() + ")"));
        }
        this.values = elements;
    }

    public E getElement(byte index) {
        return this.values[index];
    }

    public E[] getElements() {
        return this.values;
    }

    public int size() {
        return this.values.length;
    }

    public void setElement(int index, E elt) {
        this.values[index] = elt;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("(");
        for (int i = 0; i < this.values.length; ++i) {
            result.append(this.values[i]);
            if (i == this.values.length - 1) continue;
            result.append(',');
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    public Coordinate<E> clone() throws CloneNotSupportedException {
        try {
            return (Coordinate)MakeDeepCopy.makeDeepCopy((Object)this);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int compareTo(Coordinate<E> coord) {
        if (this.size() != coord.size()) {
            return -1;
        }
        for (byte i = 0; i < this.size(); i = (byte)(i + 1)) {
            if (this.values[i].equals(coord.getElement(i))) continue;
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object obj) {
        return obj instanceof Coordinate && this.compareTo((Coordinate)obj) == 0;
    }
}

