/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone;

import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import java.io.IOException;
import java.io.Serializable;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates.Coordinate;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.utils.HomogenousPair;
import org.objectweb.proactive.extensions.p2p.structured.utils.converters.MakeDeepCopy;

public abstract class Zone<E extends Element>
implements Serializable {
    private static final long serialVersionUID = 130L;
    protected final Coordinate<E> lowerBound;
    protected final Coordinate<E> upperBound;

    protected Zone(Coordinate<E> lowerBound, Coordinate<E> upperBound) {
        this.lowerBound = (Coordinate)Preconditions.checkNotNull(lowerBound);
        this.upperBound = (Coordinate)Preconditions.checkNotNull(upperBound);
    }

    public boolean canMerge(Zone<E> zone, byte neighborDimension) {
        Zone currentZoneCopy = null;
        try {
            currentZoneCopy = (Zone)MakeDeepCopy.makeDeepCopy((Object)this);
            currentZoneCopy.lowerBound.setElement(neighborDimension, Element.min(this.lowerBound.getElement(neighborDimension), zone.getLowerBound(neighborDimension)));
            currentZoneCopy.upperBound.setElement(neighborDimension, Element.max(this.upperBound.getElement(neighborDimension), zone.getUpperBound(neighborDimension)));
            return DoubleMath.fuzzyEquals((double)currentZoneCopy.getArea(), (double)(this.getArea() + zone.getArea()), (double)1.0E-5);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract double getArea();

    public boolean contains(Coordinate<E> coordinate) {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            if (this.contains(dim, coordinate.getElement(dim)) == 0) continue;
            return false;
        }
        return true;
    }

    public byte contains(byte dimension, E element) {
        if (element == null) {
            return 0;
        }
        if (element.compareTo(this.upperBound.getElement(dimension)) >= 0) {
            return 1;
        }
        if (element.compareTo(this.lowerBound.getElement(dimension)) < 0) {
            return -1;
        }
        return 0;
    }

    public boolean overlaps(Zone<E> zone, byte dimension) {
        E a = this.lowerBound.getElement(dimension);
        E b = this.upperBound.getElement(dimension);
        E c = zone.getLowerBound(dimension);
        E d = zone.getUpperBound(dimension);
        return a.compareTo(c) >= 0 && a.compareTo(d) < 0 || b.compareTo(c) > 0 && b.compareTo(d) <= 0 || c.compareTo(a) >= 0 && c.compareTo(b) < 0 || d.compareTo(a) > 0 && d.compareTo(b) <= 0;
    }

    public boolean overlaps(Zone<E> zone) {
        for (byte i = 0; i < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); i = (byte)(i + 1)) {
            if (this.overlaps(zone, i)) continue;
            return false;
        }
        return true;
    }

    public boolean abuts(Zone<E> zone, byte dimension, boolean direction) {
        return direction && this.lowerBound.getElement(dimension).compareTo(zone.getUpperBound(dimension)) == 0 || !direction && this.upperBound.getElement(dimension).compareTo(zone.getLowerBound(dimension)) == 0;
    }

    public byte neighbors(Zone<E> zone) {
        int overlaps = 0;
        int abuts = 0;
        byte abutsDimension = -1;
        for (byte dimension = 0; dimension < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dimension = (byte)(dimension + 1)) {
            if (this.overlaps(zone, dimension)) {
                overlaps = (byte)(overlaps + 1);
                continue;
            }
            if (this.abuts(zone, dimension, true) || this.abuts(zone, dimension, false)) {
                abutsDimension = dimension;
                abuts = (byte)(abuts + 1);
                continue;
            }
            return -1;
        }
        if (abuts != 1 || overlaps != (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue() - 1) {
            return -1;
        }
        return abutsDimension;
    }

    public abstract HomogenousPair<? extends Zone<E>> split(byte var1);

    protected Coordinate<E>[] splitCoordinates(byte dimension) {
        E middle = Element.middle(this.lowerBound.getElement(dimension), this.upperBound.getElement(dimension));
        try {
            Object lowerBoundCopy = this.lowerBound.clone();
            Object upperBoundCopy = this.upperBound.clone();
            ((Coordinate)lowerBoundCopy).setElement(dimension, middle);
            ((Coordinate)upperBoundCopy).setElement(dimension, middle);
            return new Coordinate[]{this.lowerBound, upperBoundCopy, lowerBoundCopy, this.upperBound};
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public abstract Zone<E> merge(Zone<E> var1);

    protected HomogenousPair<Coordinate<E>> mergeCoordinates(Zone<E> zone) {
        byte d = this.neighbors(zone);
        try {
            Object lowerBoundCopy = this.lowerBound.clone();
            Object upperBoundCopy = this.upperBound.clone();
            ((Coordinate)lowerBoundCopy).setElement(d, Element.min(this.lowerBound.getElement(d), zone.getLowerBound(d)));
            ((Coordinate)upperBoundCopy).setElement(d, Element.max(this.upperBound.getElement(d), zone.getUpperBound(d)));
            return HomogenousPair.createHomogenous((Object)lowerBoundCopy, (Object)upperBoundCopy);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public Coordinate<E> getUpperBound() {
        return this.upperBound;
    }

    public Coordinate<E> getLowerBound() {
        return this.lowerBound;
    }

    public E getLowerBound(byte dimension) {
        return this.lowerBound.getElement(dimension);
    }

    public E getUpperBound(byte dimension) {
        return this.upperBound.getElement(dimension);
    }

    public int hashCode() {
        return 31 * (31 + this.lowerBound.hashCode()) + this.upperBound.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Zone && this.lowerBound.equals(((Zone)obj).lowerBound) && this.upperBound.equals(((Zone)obj).upperBound);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.lowerBound);
        result.append(" to ");
        result.append(this.upperBound);
        return result.toString();
    }
}

