/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone;

import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.Zone;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates.Coordinate;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.StringElement;
import org.objectweb.proactive.extensions.p2p.structured.utils.HomogenousPair;

public abstract class UnicodeZone<E extends StringElement>
extends Zone<E> {
    private static final long serialVersionUID = 130L;

    public UnicodeZone(Coordinate<E> lowerBound, Coordinate<E> upperBound) {
        super(lowerBound, upperBound);
    }

    @Override
    public HomogenousPair<UnicodeZone<E>> split(byte dimension) {
        Coordinate<E>[] coords = super.splitCoordinates(dimension);
        return HomogenousPair.createHomogenous(this.newZone(coords[0], coords[1]), this.newZone(coords[2], coords[3]));
    }

    @Override
    public Zone<E> merge(Zone<E> zone) {
        HomogenousPair<Coordinate<E>> coords = super.mergeCoordinates(zone);
        return this.newZone((Coordinate)coords.getFirst(), (Coordinate)coords.getSecond());
    }

    protected abstract UnicodeZone<E> newZone(Coordinate<E> var1, Coordinate<E> var2);

    @Override
    protected double getArea() {
        double area = 1.0;
        for (byte i = 0; i < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); i = (byte)(i + 1)) {
            area *= ((StringElement)this.upperBound.getElement(i)).normalize(0.0, 1.0) - ((StringElement)this.lowerBound.getElement(i)).normalize(0.0, 1.0);
        }
        return area;
    }
}

