/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.overlay.can;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.NeighborEntry;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.Zone;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.utils.HomogenousPair;

public class NeighborTable<E extends Element>
implements Serializable {
    private static final long serialVersionUID = 130L;
    public static final byte DIRECTION_ANY = -1;
    public static final byte DIRECTION_INFERIOR = 0;
    public static final byte DIRECTION_SUPERIOR = 1;
    private ConcurrentMap<UUID, NeighborEntry<E>>[][] entries = new ConcurrentHashMap[((Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue()).byteValue()][2];

    public NeighborTable() {
        int nbNeighbors = (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue() * 2;
        for (int i = 0; i < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); ++i) {
            this.entries[i][0] = new ConcurrentHashMap<UUID, NeighborEntry<E>>(nbNeighbors, 0.75f, (Integer)P2PStructuredProperties.MAO_SOFT_LIMIT_PEERS.getValue());
            this.entries[i][1] = new ConcurrentHashMap<UUID, NeighborEntry<E>>(nbNeighbors, 0.75f, (Integer)P2PStructuredProperties.MAO_SOFT_LIMIT_PEERS.getValue());
        }
    }

    public void add(NeighborEntry<E> entry, byte dimension, byte direction) {
        this.entries[dimension][direction].put(entry.getId(), entry);
    }

    public void addAll(NeighborTable<E> table) {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                this.entries[dim][direction].putAll(table.get(dim, direction));
            }
        }
    }

    public ConcurrentMap<UUID, NeighborEntry<E>> get(byte dimension, byte direction) {
        return this.entries[dimension][direction];
    }

    public ConcurrentMap<UUID, NeighborEntry<E>>[] get(byte dimension) {
        return this.entries[dimension];
    }

    public NeighborEntry<E> getMergeableNeighbor(Zone<E> zone) {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (int direction = 0; direction < 2; direction = (int)((byte)(direction + 1))) {
                for (NeighborEntry entry : this.entries[dim][direction].values()) {
                    if (!zone.canMerge(entry.getZone(), dim)) continue;
                    return entry;
                }
            }
        }
        return null;
    }

    public NeighborEntry<E> getNeighborEntry(UUID peerIdentifier) {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (int direction = 0; direction < 2; direction = (int)((byte)(direction + 1))) {
                if (!this.entries[dim][direction].containsKey(peerIdentifier)) continue;
                return (NeighborEntry)this.entries[dim][direction].get(peerIdentifier);
            }
        }
        return null;
    }

    public boolean contains(UUID peerIdentifier) {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (int direction = 0; direction < 2; direction = (int)((byte)(direction + 1))) {
                if (!this.entries[dim][direction].containsKey(peerIdentifier)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(UUID peerIdentifier, byte dimension, byte direction) {
        return this.entries[dimension][direction].containsKey(peerIdentifier);
    }

    public HomogenousPair<Byte> findDimensionAndDirection(UUID peerIdentifier) {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                if (!this.entries[dim][direction].containsKey(peerIdentifier)) continue;
                return HomogenousPair.createHomogenous((Object)dim, (Object)direction);
            }
        }
        return null;
    }

    public byte findDimension(UUID peerIdentifier) {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (int direction = 0; direction < 2; direction = (int)((byte)(direction + 1))) {
                if (!this.entries[dim][direction].containsKey(peerIdentifier)) continue;
                return dim;
            }
        }
        return -1;
    }

    public byte findDirection(UUID peerIdentifier) {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                if (!this.entries[dim][direction].containsKey(peerIdentifier)) continue;
                return direction;
            }
        }
        return -1;
    }

    public HomogenousPair<Byte> remove(UUID peerIdentifier) {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                if (this.entries[dim][direction].remove(peerIdentifier) == null) continue;
                return HomogenousPair.createHomogenous((Object)dim, (Object)direction);
            }
        }
        return null;
    }

    public boolean remove(UUID peerIdentifier, byte dimension, byte direction) {
        return this.entries[dimension][direction].remove(peerIdentifier) != null;
    }

    public void removeAll() {
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                this.removeAll(dim, direction);
            }
        }
    }

    public void removeAll(byte dimension, byte direction) {
        this.entries[dimension][direction].clear();
    }

    public int size() {
        int nbEntries = 0;
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (int direction = 0; direction < 2; direction = (int)((byte)(direction + 1))) {
                nbEntries += this.entries[dim][direction].size();
            }
        }
        return nbEntries;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (int direction = 0; direction < 2; direction = (int)((byte)(direction + 1))) {
                buf.append('[');
                int i = 0;
                for (NeighborEntry entry : this.entries[dim][direction].values()) {
                    buf.append(entry.getZone());
                    if (i < this.entries[dim][direction].values().size() - 1) {
                        buf.append(',');
                    }
                    ++i;
                }
                buf.append(']');
                if (direction == 0) {
                    buf.append("<--(dim ");
                    buf.append(dim);
                    buf.append(")-->");
                    continue;
                }
                buf.append('\n');
            }
        }
        return buf.toString();
    }
}

