/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.overlay.can;

import java.io.Serializable;
import java.util.UUID;
import org.objectweb.proactive.api.PAFuture;
import org.objectweb.proactive.extensions.p2p.structured.operations.can.GetIdAndZoneOperation;
import org.objectweb.proactive.extensions.p2p.structured.operations.can.GetIdAndZoneResponseOperation;
import org.objectweb.proactive.extensions.p2p.structured.overlay.Peer;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.Zone;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;

public class NeighborEntry<E extends Element>
implements Serializable {
    private static final long serialVersionUID = 130L;
    private final UUID neighborIdentifier;
    private final Peer neighborStub;
    private Zone<E> neighborZone;

    public NeighborEntry(Peer peerStub) {
        this.neighborStub = peerStub;
        GetIdAndZoneResponseOperation response = (GetIdAndZoneResponseOperation)PAFuture.getFutureValue((Object)this.neighborStub.receive(new GetIdAndZoneOperation()));
        this.neighborIdentifier = response.getPeerIdentifier();
        this.neighborZone = response.getPeerZone();
    }

    public NeighborEntry(UUID peerIdentifier, Peer peerStub, Zone<E> peerZone) {
        this.neighborIdentifier = peerIdentifier;
        this.neighborStub = peerStub;
        this.neighborZone = peerZone;
    }

    public UUID getId() {
        return this.neighborIdentifier;
    }

    public Peer getStub() {
        return this.neighborStub;
    }

    public Zone<E> getZone() {
        return this.neighborZone;
    }

    public void setZone(Zone<E> newZone) {
        this.neighborZone = newZone;
    }

    public int hashCode() {
        return this.neighborIdentifier.hashCode() + 31 * this.neighborZone.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof NeighborEntry && this.neighborIdentifier.equals(((NeighborEntry)obj).getId()) && this.neighborZone.equals(((NeighborEntry)obj).getZone());
    }

    public String toString() {
        return "NeighborEntry[peerId=" + this.neighborIdentifier + ", zone=" + this.neighborZone + "]";
    }
}

