/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.overlay.can;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.objectweb.proactive.api.PAFuture;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.operations.CanOperations;
import org.objectweb.proactive.extensions.p2p.structured.operations.EmptyResponseOperation;
import org.objectweb.proactive.extensions.p2p.structured.operations.can.JoinIntroduceOperation;
import org.objectweb.proactive.extensions.p2p.structured.operations.can.JoinIntroduceResponseOperation;
import org.objectweb.proactive.extensions.p2p.structured.operations.can.LeaveOperation;
import org.objectweb.proactive.extensions.p2p.structured.operations.can.ReplaceNeighborOperation;
import org.objectweb.proactive.extensions.p2p.structured.operations.can.UpdateNeighborOperation;
import org.objectweb.proactive.extensions.p2p.structured.overlay.OverlayType;
import org.objectweb.proactive.extensions.p2p.structured.overlay.Peer;
import org.objectweb.proactive.extensions.p2p.structured.overlay.RequestResponseManager;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanRequestResponseManager;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.NeighborEntry;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.NeighborTable;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.SplitEntry;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.Zone;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates.Coordinate;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.utils.HomogenousPair;
import org.objectweb.proactive.extensions.p2p.structured.utils.RandomUtils;
import org.objectweb.proactive.extensions.p2p.structured.utils.converters.MakeDeepCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CanOverlay<E extends Element>
extends StructuredOverlay {
    private static final Logger log = LoggerFactory.getLogger(CanOverlay.class);
    private ScheduledExecutorService maintenanceTask;
    private NeighborTable<E> neighborTable = new NeighborTable();
    private LinkedList<SplitEntry> splitHistory = new LinkedList();
    protected Zone<E> zone;

    public CanOverlay() {
        this(new CanRequestResponseManager());
    }

    public CanOverlay(RequestResponseManager requestResponseManager) {
        super(requestResponseManager);
    }

    public void removeOutdatedNeighbors() {
        Iterator it = null;
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                it = this.neighborTable.get(dim, direction).values().iterator();
                while (it.hasNext()) {
                    if (this.zone.neighbors(((NeighborEntry)it.next()).getZone()) != -1) continue;
                    it.remove();
                }
            }
        }
    }

    public final NeighborEntry<E> nearestNeighbor(Coordinate<E> coordinate, byte dimension, byte direction) {
        List<NeighborEntry<E>> neighbors = this.neighborsVerifyingDimensions(this.neighborTable.get(dimension, direction).values(), coordinate, dimension);
        if (neighbors.size() == 0) {
            throw new IllegalStateException("No neighbor to route to for coordinate " + coordinate + " on dimension " + dimension + " and direction " + direction + " , dump is:\n{}" + this.dump());
        }
        if (neighbors.size() > 1) {
            neighbors = this.neighborsWithBestRank(neighbors, coordinate);
        }
        NeighborEntry<E> entry = neighbors.get(RandomUtils.nextInt((int)neighbors.size()));
        if (log.isDebugEnabled()) {
            if (this.zone.neighbors(entry.getZone()) == -1) {
                log.error("Neighbor chosen to route the message is " + entry.getZone() + ". However it does not neighbor the current peer.");
            } else {
                log.debug("Neighbor chosen to route the message is " + entry.getZone());
            }
        }
        return entry;
    }

    private List<NeighborEntry<E>> neighborsWithBestRank(List<NeighborEntry<E>> neighbors, Coordinate<E> coordinate) {
        int i;
        List[] ranks = new List[coordinate.size() + 1];
        int nbEltVerified = 0;
        for (i = 0; i < neighbors.size(); ++i) {
            nbEltVerified = 0;
            for (byte j = 0; j < coordinate.size(); j = (byte)(j + 1)) {
                if (neighbors.get(i).getZone().contains(j, coordinate.getElement(j)) != 0) continue;
                ++nbEltVerified;
            }
            if (ranks[nbEltVerified] == null) {
                ranks[nbEltVerified] = new ArrayList();
            }
            ranks[nbEltVerified].add(neighbors.get(i));
        }
        for (i = ranks.length - 1; i >= 0; --i) {
            if (ranks[i] == null) continue;
            return ranks[i];
        }
        return null;
    }

    public List<NeighborEntry<E>> neighborsVerifyingDimensions(Collection<NeighborEntry<E>> neighbors, Coordinate<E> coordinate, byte dimension) {
        ArrayList<NeighborEntry<NeighborEntry<E>>> result = new ArrayList<NeighborEntry<NeighborEntry<E>>>();
        for (NeighborEntry<E> entry : neighbors) {
            boolean validatesPrecedingDimensions = true;
            for (byte dim = 0; dim < dimension; dim = (byte)(dim + 1)) {
                if (entry.getZone().contains(dim, coordinate.getElement(dim)) == 0) continue;
                validatesPrecedingDimensions = false;
                break;
            }
            if (!validatesPrecedingDimensions) continue;
            result.add(entry);
        }
        return result;
    }

    public NeighborTable<E> getNeighborTable() {
        return this.neighborTable;
    }

    public static byte getRandomDimension() {
        return (byte)RandomUtils.nextInt((int)((Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue()).byteValue());
    }

    public static byte getRandomDirection() {
        return (byte)RandomUtils.nextInt((int)2);
    }

    public List<SplitEntry> getSplitHistory() {
        return this.splitHistory;
    }

    public Zone<E> getZone() {
        return this.zone;
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        buf.append("Peer with id ");
        buf.append(this.id);
        buf.append(" manages zone ");
        buf.append((Object)this);
        if (this.neighborTable.size() > 0) {
            buf.append(" and has the following neighbor(s):\n");
            for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
                for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                    for (NeighborEntry neighbor : this.neighborTable.get(dim, direction).values()) {
                        buf.append("  - ");
                        buf.append(neighbor.getZone());
                        buf.append(", id is ");
                        buf.append(neighbor.getId());
                        buf.append(", abuts in dim " + neighbor.getZone().neighbors(this.zone) + " and is in dim=" + dim + ", dir=" + direction);
                        buf.append('\n');
                    }
                }
            }
        } else {
            buf.append('\n');
        }
        return buf.toString();
    }

    public JoinIntroduceResponseOperation<E> handleJoinIntroduceMessage(JoinIntroduceOperation<E> msg) {
        byte dimension = 0;
        byte direction = CanOverlay.getRandomDirection();
        byte directionInv = CanOverlay.getOppositeDirection(direction);
        if (!this.splitHistory.isEmpty()) {
            dimension = CanOverlay.getNextDimension(this.splitHistory.removeLast().getDimension());
        }
        HomogenousPair<Zone<E>> newZones = this.splitZones(dimension);
        NeighborTable pendingNewNeighborhood = new NeighborTable();
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte dir = 0; dir < 2; dir = (byte)(dir + 1)) {
                if (dim == dimension && dir == direction) continue;
                for (NeighborEntry entry : this.neighborTable.get(dim, dir).values()) {
                    if (((Zone)newZones.get((int)directionInv)).neighbors(entry.getZone()) == -1) continue;
                    pendingNewNeighborhood.add(entry, dim, dir);
                }
            }
        }
        pendingNewNeighborhood.add(new NeighborEntry(this.id, this.stub, (Zone)newZones.get((int)direction)), dimension, direction);
        LinkedList historyToTransfert = null;
        try {
            historyToTransfert = (LinkedList)MakeDeepCopy.makeDeepCopy(this.splitHistory);
            historyToTransfert.add(new SplitEntry(dimension, directionInv));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.zone = (Zone)newZones.get((int)direction);
        this.splitHistory.add(new SplitEntry(dimension, direction));
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte dir = 0; dir < 2; dir = (byte)(dir + 1)) {
                Iterator it = this.neighborTable.get(dim, dir).values().iterator();
                NeighborEntry entry = null;
                while (it.hasNext()) {
                    entry = (NeighborEntry)it.next();
                    if (dim == dimension && dir == directionInv) {
                        CanOperations.removeNeighbor(entry.getStub(), this.id, dim, CanOverlay.getOppositeDirection(dir));
                        it.remove();
                        continue;
                    }
                    if (entry.getZone().neighbors(this.zone) == -1) {
                        CanOperations.removeNeighbor(entry.getStub(), this.id, dim, CanOverlay.getOppositeDirection(dir));
                        it.remove();
                        continue;
                    }
                    CanOperations.updateNeighborOperation(entry.getStub(), this.getNeighborEntry(), dim, CanOverlay.getOppositeDirection(dir));
                }
            }
        }
        this.neighborTable.add(new NeighborEntry(msg.getPeerID(), msg.getRemotePeer(), (Zone)newZones.get((int)directionInv)), dimension, directionInv);
        return new JoinIntroduceResponseOperation(this.id, (Zone)newZones.get((int)directionInv), historyToTransfert, pendingNewNeighborhood, this.removeDataIn(newZones.get((int)directionInv)));
    }

    protected HomogenousPair<? extends Zone<E>> splitZones(byte dimension) {
        return this.zone.split(dimension);
    }

    private void createMaintenanceTask() {
        this.maintenanceTask = Executors.newSingleThreadScheduledExecutor();
        this.maintenanceTask.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                CanOverlay.this.update();
            }
        }, ((Integer)P2PStructuredProperties.CAN_REFRESH_TASK_START.getValue()).intValue(), ((Integer)P2PStructuredProperties.CAN_REFRESH_TASK_INTERVAL.getValue()).intValue(), TimeUnit.MILLISECONDS);
    }

    public void create() {
        this.zone = this.newZone();
    }

    protected abstract Zone<E> newZone();

    public void join(Peer landmarkPeer) {
        JoinIntroduceResponseOperation response = (JoinIntroduceResponseOperation)PAFuture.getFutureValue((Object)landmarkPeer.receive(new JoinIntroduceOperation(this.id, this.stub)));
        this.assignDataReceived(response.getData());
        this.zone = response.getZone();
        this.splitHistory = response.getSplitHistory();
        this.neighborTable = response.getNeighbors();
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte dir = 0; dir < 2; dir = (byte)(dir + 1)) {
                if (dim == this.splitHistory.getLast().getDimension() && dir == CanOverlay.getOppositeDirection(this.splitHistory.getLast().getDirection())) continue;
                for (NeighborEntry entry : this.neighborTable.get(dim, dir).values()) {
                    CanOperations.insertNeighbor(entry.getStub(), this.getNeighborEntry(), dim, CanOverlay.getOppositeDirection(dir));
                }
            }
        }
    }

    public void leave() {
        if (this.neighborTable.size() == 0) {
            return;
        }
        NeighborEntry<E> suitableNeighbor = this.neighborTable.getMergeableNeighbor(this.zone);
        if (suitableNeighbor == null) {
            this.retryLeave();
            return;
        }
        HomogenousPair<Byte> neighborDimDir = this.neighborTable.findDimensionAndDirection(suitableNeighbor.getId());
        HashSet neighbors = Sets.newHashSet(this.neighborTable.get((Byte)neighborDimDir.getFirst(), (Byte)neighborDimDir.getSecond()).values());
        PAFuture.waitFor((Object)suitableNeighbor.getStub().receive(new LeaveOperation<E>(this.id, this.zone, neighbors, this.retrieveAllData())));
        for (byte dim = 0; dim < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dim = (byte)(dim + 1)) {
            for (byte dir = 0; dir < 2; dir = (byte)(dir + 1)) {
                for (NeighborEntry entry : this.neighborTable.get(dim, dir).values()) {
                    if (dim == (Byte)neighborDimDir.getFirst() || dir == (Byte)neighborDimDir.getSecond()) continue;
                    PAFuture.waitFor((Object)entry.getStub().receive(new ReplaceNeighborOperation(this.id, entry)));
                }
            }
        }
        log.info("Peer {} has left the network and the zone has been taken over by {}", (Object)this, suitableNeighbor.getZone());
    }

    private void retryLeave() {
        int timeout = RandomUtils.nextInt((int)((Integer)P2PStructuredProperties.CAN_LEAVE_RETRY_MAX.getValue() - (Integer)P2PStructuredProperties.CAN_LEAVE_RETRY_MIN.getValue())) + (Integer)P2PStructuredProperties.CAN_LEAVE_RETRY_MIN.getValue();
        log.info("Peer {} cannot leave at this time, retry in {} ms", (Object)this, (Object)timeout);
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.leave();
    }

    public EmptyResponseOperation processLeave(LeaveOperation<E> operation) {
        byte dim = this.neighborTable.findDimension(operation.getPeerLeavingId());
        byte dir = this.neighborTable.findDirection(operation.getPeerLeavingId());
        this.zone = this.zone.merge(operation.getPeerLeavingZone());
        if (operation.getData() != null) {
            this.assignDataReceived(operation.getData());
        }
        this.neighborTable.removeAll(dim, dir);
        for (NeighborEntry<E> entry : operation.getNewNeighborsToSet()) {
            this.neighborTable.add(entry, dim, dir);
        }
        return new EmptyResponseOperation();
    }

    public void update() {
        this.removeOutdatedNeighbors();
        for (byte dimension = 0; dimension < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dimension = (byte)(dimension + 1)) {
            for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                Iterator it = this.neighborTable.get(dimension, direction).values().iterator();
                while (it.hasNext()) {
                    ((NeighborEntry)it.next()).getStub().receive(new UpdateNeighborOperation<E>(this.getNeighborEntry(), dimension, CanOverlay.getOppositeDirection(direction)));
                }
            }
        }
    }

    private NeighborEntry<E> getNeighborEntry() {
        return new NeighborEntry<E>(this.id, this.stub, this.zone);
    }

    public void setHistory(LinkedList<SplitEntry> history) {
        this.splitHistory = history;
    }

    public void setZone(Zone<E> zone) {
        this.zone = zone;
    }

    public OverlayType getType() {
        return OverlayType.CAN;
    }

    public void dumpNeighbors() {
        log.debug("Peer managing {}", this.zone);
        NeighborTable<E> neighborTable = this.getNeighborTable();
        for (byte dimension = 0; dimension < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); dimension = (byte)(dimension + 1)) {
            for (byte direction = 0; direction < 2; direction = (byte)(direction + 1)) {
                for (NeighborEntry entry : neighborTable.get(dimension, direction).values()) {
                    log.debug("  * {}, dimension={}, direction={}", new Object[]{entry.getZone(), dimension, direction});
                }
            }
        }
    }

    public String toString() {
        if (this.zone == null) {
            return this.id.toString();
        }
        return this.zone.toString();
    }

    public static byte getNextDimension(byte dimension) {
        return (byte)((dimension + 1) % (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue());
    }

    public static byte getOppositeDirection(byte direction) {
        return (byte)((direction + 1) % 2);
    }

    public static byte getPreviousDimension(byte dimension) {
        byte dim = (byte)(dimension - 1);
        if (dim < 0) {
            dim = (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue();
        }
        return dim;
    }

    public boolean hasNeighbor(UUID peerID) {
        return this.neighborTable.contains(peerID);
    }
}

