/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.p2p.structured.operations.can;

import java.util.UUID;
import org.objectweb.proactive.extensions.p2p.structured.operations.BooleanResponseOperation;
import org.objectweb.proactive.extensions.p2p.structured.operations.CallableOperation;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.NeighborTable;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;

public class RemoveNeighborOperation<E extends Element>
extends CallableOperation {
    private static final long serialVersionUID = 130L;
    private final UUID peerIdentifier;
    private final byte dimension;
    private final byte direction;

    public RemoveNeighborOperation(UUID peerIdentifier, byte dimension, byte direction) {
        this.peerIdentifier = peerIdentifier;
        this.dimension = dimension;
        this.direction = direction;
    }

    public RemoveNeighborOperation(UUID peerIdentifier) {
        this.peerIdentifier = peerIdentifier;
        this.dimension = (byte)-1;
        this.direction = (byte)-1;
    }

    public UUID getPeerIdentifier() {
        return this.peerIdentifier;
    }

    public byte getDimension() {
        return this.dimension;
    }

    public byte getDirection() {
        return this.direction;
    }

    public BooleanResponseOperation handle(StructuredOverlay overlay) {
        NeighborTable table = ((CanOverlay)overlay).getNeighborTable();
        boolean result = this.dimension == -1 && this.direction == -1 ? table.remove(this.peerIdentifier) != null : table.remove(this.peerIdentifier, this.dimension, this.direction);
        return new BooleanResponseOperation(result);
    }
}

