/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public final class FractalADLLogManager {
    public static final String OUTPUT_FILE_NAME = "target/fractaladl-log.txt";
    public static final String OUTPUT_FILE_PROPERTY_NAME = "loggers.outfile";
    public static final String CONSOLE_LEVEL_SUFFIX = ".console.level";
    public static final String FILE_LEVEL_SUFFIX = ".file.level";
    public static final String DEFAULT_CONSOLE_LEVEL_PROPERTY_NAME = "default.console.level";
    public static final String DEFAULT_FILE_LEVEL_PROPERTY_NAME = "default.file.level";
    public static final String ROOT_LOGGER_NAME = "fractaladl";
    public static final Level DEFAULT_CONSOLE_LEVEL = Level.INFO;
    public static final Level DEFAULT_FILE_LEVEL = Level.OFF;
    protected static final Map<String, Logger> LOGGER_MAP = new HashMap<String, Logger>();
    protected static final Map<Logger, LoggerShelf> LOGGER_SHELF_MAP = new IdentityHashMap<Logger, LoggerShelf>();
    public static final Logger STEP;

    private FractalADLLogManager() {
    }

    private static Level getLevelFromProperty(String levelPropertyName, Level defaultLevel) {
        Level level;
        String levelString = System.getProperty(levelPropertyName);
        if (levelString != null) {
            try {
                level = Level.parse(levelString);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Warning: Invalid level value for [" + levelPropertyName + "]: \"" + levelString + "\". Defaulting to " + defaultLevel + " level");
                level = defaultLevel;
            }
        } else {
            level = defaultLevel;
        }
        return level;
    }

    public static Logger getLogger(String name) {
        Logger logger = LOGGER_MAP.get(name);
        if (logger == null) {
            logger = new LoggerShelf((String)name).logger;
            LOGGER_MAP.put(name, logger);
        }
        return logger;
    }

    static void closeLoggers() {
        for (Logger logger : LOGGER_MAP.values()) {
            for (Handler h : logger.getHandlers()) {
                h.close();
            }
        }
    }

    static {
        Level consoleLevel = FractalADLLogManager.getLevelFromProperty(DEFAULT_CONSOLE_LEVEL_PROPERTY_NAME, DEFAULT_CONSOLE_LEVEL);
        Level fileLevel = FractalADLLogManager.getLevelFromProperty(DEFAULT_FILE_LEVEL_PROPERTY_NAME, DEFAULT_FILE_LEVEL);
        LOGGER_MAP.put(ROOT_LOGGER_NAME, new LoggerShelf((String)ROOT_LOGGER_NAME, (Level)consoleLevel, (Level)fileLevel).logger);
        STEP = FractalADLLogManager.getLogger("step");
    }

    private static class LoggerShelf {
        final Logger logger;
        Handler consoleHandler;
        Handler fileHandler;

        LoggerShelf(String name) {
            String loggerName = name.equals(FractalADLLogManager.ROOT_LOGGER_NAME) ? name : "fractaladl." + name;
            this.logger = Logger.getLogger(loggerName);
            LOGGER_SHELF_MAP.put(this.logger, this);
            Logger parentLogger = this.logger.getParent();
            LoggerShelf parentLoggerShelf = LOGGER_SHELF_MAP.get(parentLogger);
            if (parentLoggerShelf == null) {
                parentLoggerShelf = new LoggerShelf(parentLogger.getName());
            }
            Level consoleLevel = FractalADLLogManager.getLevelFromProperty(name + FractalADLLogManager.CONSOLE_LEVEL_SUFFIX, parentLoggerShelf.consoleHandler.getLevel());
            Level fileLevel = FractalADLLogManager.getLevelFromProperty(name + FractalADLLogManager.FILE_LEVEL_SUFFIX, parentLoggerShelf.fileHandler.getLevel());
            this.initLogger(consoleLevel, fileLevel, name);
        }

        private void initLogger(Level consoleLevel, Level fileLevel, String name) {
            this.logger.setUseParentHandlers(false);
            this.consoleHandler = new StdOutConsoleHandler(name);
            this.consoleHandler.setLevel(consoleLevel);
            this.logger.addHandler(this.consoleHandler);
            try {
                this.fileHandler = new SingletonFileHandler(name);
                this.fileHandler.setLevel(fileLevel);
                this.logger.addHandler(this.fileHandler);
            }
            catch (IOException e) {
                System.err.println("Warning: Can't open log file: " + e.getMessage());
            }
            this.logger.setLevel(consoleLevel.intValue() < fileLevel.intValue() ? consoleLevel : fileLevel);
        }

        LoggerShelf(String name, Level consoleLevel, Level fileLevel) {
            String loggerName = name.equals(FractalADLLogManager.ROOT_LOGGER_NAME) ? name : "fractaladl." + name;
            this.logger = Logger.getLogger(loggerName);
            LOGGER_SHELF_MAP.put(this.logger, this);
            this.initLogger(consoleLevel, fileLevel, name);
        }
    }

    static class SingletonFileHandler
    extends StreamHandler {
        static OutputStream outputStream;

        static synchronized OutputStream getOutputStream() throws IOException {
            if (outputStream == null) {
                File outputFile = new File(System.getProperty(FractalADLLogManager.OUTPUT_FILE_PROPERTY_NAME, FractalADLLogManager.OUTPUT_FILE_NAME));
                outputStream = new LazyFileOutputStream(outputFile);
            }
            return outputStream;
        }

        SingletonFileHandler(String shortName) throws IOException {
            this.setFormatter(new SimpleConsoleFormatter(shortName));
            this.setOutputStream(SingletonFileHandler.getOutputStream());
        }

        public synchronized void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }
    }

    static class LazyFileOutputStream
    extends OutputStream {
        OutputStream os = null;
        final File outputFile;

        LazyFileOutputStream(File outputFile) {
            this.outputFile = outputFile;
        }

        public void write(int b) throws IOException {
            this.getOs().write(b);
        }

        public synchronized void flush() throws IOException {
            if (this.os != null) {
                this.os.flush();
            }
        }

        public synchronized void close() throws IOException {
            if (this.os != null) {
                this.os.close();
            }
        }

        synchronized OutputStream getOs() {
            if (this.os == null) {
                this.outputFile.getParentFile().mkdirs();
                try {
                    this.os = new FileOutputStream(this.outputFile);
                }
                catch (FileNotFoundException e) {
                    System.err.println("Can't open log file " + this.outputFile + " : ");
                    e.printStackTrace();
                    this.os = new OutputStream(){

                        public void write(int b) throws IOException {
                        }
                    };
                }
            }
            return this.os;
        }
    }

    static class StdOutConsoleHandler
    extends StreamHandler {
        StdOutConsoleHandler(String shortName) {
            super(System.out, new SimpleConsoleFormatter(shortName));
        }

        public synchronized void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }
    }

    private static class SimpleConsoleFormatter
    extends Formatter {
        private final String prefix;

        SimpleConsoleFormatter(String shortName) {
            this.prefix = "[" + shortName + "] ";
        }

        public String format(LogRecord record) {
            return this.prefix + record.getMessage() + "\n";
        }
    }
}

