/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.interfaces;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.error.NodeErrorLocator;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.interfaces.InterfaceErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceLoader
extends AbstractLoader {
    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d);
        return d;
    }

    private void checkNode(Object node) throws ADLException {
        if (node instanceof InterfaceContainer) {
            this.checkInterfaceContainer((InterfaceContainer)node);
        }
        if (node instanceof ComponentContainer) {
            for (Component comp : ((ComponentContainer)node).getComponents()) {
                this.checkNode(comp);
            }
        }
    }

    private void checkInterfaceContainer(InterfaceContainer container) throws ADLException {
        HashMap<String, Interface> names = new HashMap<String, Interface>();
        for (Interface itf : container.getInterfaces()) {
            if (itf.getName() == null) {
                throw new ADLException((ErrorTemplate)InterfaceErrors.INTERFACE_NAME_MISSING, (Node)itf, new Object[0]);
            }
            Interface previousDefinition = names.put(itf.getName(), itf);
            if (previousDefinition == null) continue;
            throw new ADLException((ErrorTemplate)InterfaceErrors.DUPLICATED_INTERFACE_NAME, (Node)itf, new Object[]{itf.getName(), new NodeErrorLocator(previousDefinition)});
        }
    }
}

