/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.implementations;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.error.ChainedErrorLocator;
import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.implementations.Controller;
import org.objectweb.fractal.adl.implementations.ControllerContainer;
import org.objectweb.fractal.adl.implementations.Implementation;
import org.objectweb.fractal.adl.implementations.ImplementationCodeLoader;
import org.objectweb.fractal.adl.implementations.ImplementationContainer;
import org.objectweb.fractal.adl.implementations.ImplementationErrors;
import org.objectweb.fractal.adl.interfaces.IDLLoader;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationLoader
extends AbstractLoader {
    public static final String INTERFACE_LOADER_CLIENT_ITF_NAME = "interface-loader";
    public IDLLoader interfaceLoaderItf;
    public static final String IMPLEMENTATION_LOADER_CLIENT_ITF_NAME = "implementation-code-loader";
    public ImplementationCodeLoader implementationCodeLoaderItf;

    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d, context);
        return d;
    }

    protected void checkNode(Object node, Map<Object, Object> context) throws ADLException {
        if (node instanceof ImplementationContainer) {
            this.checkImplementationContainer((ImplementationContainer)node, context);
        }
        if (node instanceof ControllerContainer) {
            this.checkControllerContainer((ControllerContainer)node);
        }
        if (node instanceof ComponentContainer) {
            for (Component comp : ((ComponentContainer)node).getComponents()) {
                this.checkNode(comp, context);
            }
        }
    }

    protected void checkImplementationContainer(ImplementationContainer container, Map<Object, Object> context) throws ADLException {
        Object d;
        Attributes attrs;
        Object c;
        Implementation impl = container.getImplementation();
        if (impl == null) {
            return;
        }
        String className = impl.getClassName();
        if (className == null) {
            throw new ADLException((ErrorTemplate)ImplementationErrors.IMPLEMENTATION_MISSING, (Node)impl, new Object[0]);
        }
        try {
            c = this.implementationCodeLoaderItf.loadImplementation(className, null, context);
        }
        catch (ADLException e) {
            ChainedErrorLocator.chainLocator(e, impl);
            throw e;
        }
        impl.astSetDecoration("code", c);
        if (!(c instanceof Class)) {
            return;
        }
        Class implemClass = (Class)c;
        if (container instanceof InterfaceContainer) {
            for (Interface itf : ((InterfaceContainer)((Object)container)).getInterfaces()) {
                Object d2;
                TypeInterface tItf;
                if (!(itf instanceof TypeInterface) || !(tItf = (TypeInterface)itf).getRole().equals("server") || !((d2 = this.interfaceLoaderItf.loadInterface(tItf.getSignature(), context)) instanceof Class) || ((Class)d2).isAssignableFrom(implemClass)) continue;
                throw new ADLException((ErrorTemplate)ImplementationErrors.CLASS_DOES_NOT_IMPLEMENT_INTERFACE, (Node)impl, new Object[]{implemClass.getName(), ((Class)d2).getName()});
            }
        }
        if (container instanceof AttributesContainer && (attrs = ((AttributesContainer)((Object)container)).getAttributes()) != null && (d = this.interfaceLoaderItf.loadInterface(attrs.getSignature(), context)) instanceof Class && !((Class)d).isAssignableFrom(implemClass)) {
            throw new ADLException((ErrorTemplate)ImplementationErrors.CLASS_DOES_NOT_IMPLEMENT_ATTR_CTRL, (Node)impl, new Object[]{implemClass.getName(), ((Class)d).getName()});
        }
    }

    protected void checkControllerContainer(ControllerContainer container) throws ADLException {
        Controller ctrl = container.getController();
        if (ctrl != null && ctrl.getDescriptor() == null) {
            throw new ADLException((ErrorTemplate)ImplementationErrors.MISSING_CONTROLLER_DESC, (Node)ctrl, new Object[0]);
        }
    }

    @Override
    public void bindFc(String s, Object o) throws NoSuchInterfaceException, IllegalBindingException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_CLIENT_ITF_NAME.equals(s)) {
            this.interfaceLoaderItf = (IDLLoader)o;
        } else if (IMPLEMENTATION_LOADER_CLIENT_ITF_NAME.equals(s)) {
            this.implementationCodeLoaderItf = (ImplementationCodeLoader)o;
        } else {
            super.bindFc(s, o);
        }
    }

    @Override
    public String[] listFc() {
        String[] superList = super.listFc();
        String[] list = new String[superList.length + 2];
        list[0] = INTERFACE_LOADER_CLIENT_ITF_NAME;
        list[1] = IMPLEMENTATION_LOADER_CLIENT_ITF_NAME;
        System.arraycopy(superList, 0, list, 2, superList.length);
        return list;
    }

    @Override
    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_CLIENT_ITF_NAME.equals(s)) {
            return this.interfaceLoaderItf;
        }
        if (IMPLEMENTATION_LOADER_CLIENT_ITF_NAME.equals(s)) {
            return this.implementationCodeLoaderItf;
        }
        return super.lookupFc(s);
    }

    @Override
    public void unbindFc(String s) throws NoSuchInterfaceException, IllegalBindingException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_CLIENT_ITF_NAME.equals(s)) {
            this.interfaceLoaderItf = null;
        } else if (IMPLEMENTATION_LOADER_CLIENT_ITF_NAME.equals(s)) {
            this.implementationCodeLoaderItf = null;
        } else {
            super.unbindFc(s);
        }
    }
}

