/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.error;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.error.ErrorLocator;

public class NodeErrorLocator
implements ErrorLocator {
    protected static final Pattern FULL_LOC = Pattern.compile("(.*):\\[(\\d+),(\\d+)\\]-\\[(\\d+),(\\d+)\\]");
    protected static final int FULL_LOC_PATH = 1;
    protected static final int FULL_LOC_BEGIN_LINE = 2;
    protected static final int FULL_LOC_BEGIN_COLUMN = 3;
    protected static final int FULL_LOC_END_LINE = 4;
    protected static final int FULL_LOC_END_COLUMN = 5;
    protected static final Pattern LCBEGIN_LOC = Pattern.compile("(.*):(\\d+)-(\\d+)");
    protected static final int LCBEGIN_LOC_PATH = 1;
    protected static final int LCBEGIN_LOC_BEGIN_LINE = 2;
    protected static final int LCBEGIN_LOC_BEGIN_COLUMN = 3;
    protected static final Pattern LINE_LOC = Pattern.compile("(.*):(\\d+)");
    protected static final int LINE_LOC_PATH = 1;
    protected static final int LINE_LOC_BEGIN_LINE = 2;
    private final Node node;
    private final int beginLine;
    private final int endLine;
    private final int beginColumn;
    private final int endColumn;
    private final String inputFilePath;

    public static final String fullLocation(String inputFilePath, int beginLine, int endLine, int beginColumn, int endColumn) {
        return inputFilePath + ":[" + beginLine + "," + beginColumn + "]-[" + endLine + "," + endColumn + "]";
    }

    public static final String lineColumnLocation(String inputFilePath, int beginLine, int beginColumn) {
        return inputFilePath + ":" + beginLine + "-" + beginColumn;
    }

    public static final String lineLocation(String inputFilePath, int beginLine) {
        return inputFilePath + ":" + beginLine;
    }

    public NodeErrorLocator(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node can't be null");
        }
        this.node = node;
        String source = node.astGetSource();
        if (source == null) {
            this.inputFilePath = null;
            this.beginLine = -1;
            this.beginColumn = -1;
            this.endLine = -1;
            this.endColumn = -1;
            return;
        }
        Matcher matcher = FULL_LOC.matcher(source);
        if (matcher.matches()) {
            this.inputFilePath = matcher.group(1);
            this.beginLine = Integer.parseInt(matcher.group(2));
            this.beginColumn = Integer.parseInt(matcher.group(3));
            this.endLine = Integer.parseInt(matcher.group(4));
            this.endColumn = Integer.parseInt(matcher.group(5));
            return;
        }
        matcher = LCBEGIN_LOC.matcher(source);
        if (matcher.matches()) {
            this.inputFilePath = matcher.group(1);
            this.beginLine = Integer.parseInt(matcher.group(2));
            this.beginColumn = Integer.parseInt(matcher.group(3));
            this.endLine = -1;
            this.endColumn = -1;
            return;
        }
        matcher = LINE_LOC.matcher(source);
        if (matcher.matches()) {
            this.inputFilePath = matcher.group(1);
            this.beginLine = Integer.parseInt(matcher.group(2));
            this.beginColumn = -1;
            this.endLine = -1;
            this.endColumn = -1;
            return;
        }
        this.inputFilePath = source;
        this.beginLine = -1;
        this.beginColumn = -1;
        this.endLine = -1;
        this.endColumn = -1;
    }

    public Node getNode() {
        return this.node;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public String getLocation() {
        if (this.inputFilePath == null) {
            return "unknown";
        }
        if (this.beginLine != -1) {
            if (this.beginColumn == -1) {
                return NodeErrorLocator.lineLocation(this.inputFilePath, this.beginLine);
            }
            if (this.endLine == -1) {
                return NodeErrorLocator.lineColumnLocation(this.inputFilePath, this.beginLine, this.beginColumn);
            }
            return NodeErrorLocator.fullLocation(this.inputFilePath, this.beginLine, this.endLine, this.beginColumn, this.endColumn);
        }
        return this.inputFilePath;
    }

    public String toString() {
        return this.getLocation();
    }
}

