/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.error;

import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import org.objectweb.fractal.adl.error.ErrorTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorTemplateValidator {
    private static Map<String, ErrorTemplate> idToTemplate = null;

    private ErrorTemplateValidator() {
    }

    public static boolean validErrorEnum(Class<? extends Enum<?>> enumClass) {
        for (Enum<?> e : enumClass.getEnumConstants()) {
            if (ErrorTemplateValidator.validErrorTemplate((ErrorTemplate)((Object)e))) continue;
            return false;
        }
        return true;
    }

    public static boolean validErrorTemplate(ErrorTemplate template, Object ... args) {
        return ErrorTemplateValidator.validMessage(template, args) && ErrorTemplateValidator.uniqueId(template);
    }

    public static boolean validErrorTemplate(ErrorTemplate template) {
        return ErrorTemplateValidator.uniqueId(template);
    }

    private static boolean uniqueId(ErrorTemplate template) {
        String id;
        ErrorTemplate previousTemplate;
        if (idToTemplate == null) {
            idToTemplate = new HashMap<String, ErrorTemplate>();
        }
        return (previousTemplate = idToTemplate.put(id = template.getGroupId() + template.getErrorId(), template)) == null || previousTemplate == template;
    }

    private static boolean validMessage(ErrorTemplate template, Object ... args) {
        try {
            template.getFormatedMessage(args);
            return true;
        }
        catch (IllegalFormatException e) {
            e.printStackTrace();
            return false;
        }
    }
}

