/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.error;

import org.objectweb.fractal.adl.error.ErrorLocator;
import org.objectweb.fractal.adl.error.ErrorTemplate;

public class Error {
    protected final ErrorTemplate template;
    protected ErrorLocator locator;
    protected final Throwable cause;
    protected final String message;

    public Error(ErrorTemplate template, Object ... args) {
        this(template, null, null, args);
    }

    public Error(ErrorTemplate template, ErrorLocator locator, Object ... args) {
        this(template, locator, null, args);
    }

    public Error(ErrorTemplate template, Throwable cause, Object ... args) {
        this(template, null, cause, args);
    }

    public Error(ErrorTemplate template, ErrorLocator locator, Throwable cause, Object ... args) {
        if (template == null) {
            throw new IllegalArgumentException("Error can't be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("args can't be null");
        }
        this.template = template;
        this.locator = locator;
        this.cause = cause;
        this.message = template.getFormatedMessage(args);
    }

    public ErrorTemplate getTemplate() {
        return this.template;
    }

    public ErrorLocator getLocator() {
        return this.locator;
    }

    public void setLocator(ErrorLocator locator) {
        this.locator = locator;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        String fullMessage = "";
        if (this.locator != null) {
            fullMessage = fullMessage + this.locator.getLocation() + ": ";
        }
        fullMessage = fullMessage + String.format("[%3s-%03d] ", this.template.getGroupId(), this.template.getErrorId());
        fullMessage = fullMessage + this.message;
        if (this.cause != null) {
            fullMessage = fullMessage + " Caused by: ";
            fullMessage = this.cause.getMessage() == null ? fullMessage + this.cause.getClass().getName() : fullMessage + this.cause.getMessage();
        }
        return fullMessage;
    }
}

