/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.error;

import java.io.File;
import org.objectweb.fractal.adl.error.ErrorLocator;

public class BasicErrorLocator
implements ErrorLocator {
    private final int beginLine;
    private final int endLine;
    private final int beginColumn;
    private final int endColumn;
    private final String inputFilePath;

    public BasicErrorLocator(File file, int beginLine, int beginColumn) {
        this(file.getPath(), beginLine, beginColumn);
    }

    public BasicErrorLocator(String inputFilePath, int beginLine, int beginColumn) {
        this(inputFilePath, beginLine, -1, beginColumn, -1);
    }

    public BasicErrorLocator(String inputFilePath, int beginLine, int endLine, int beginColumn, int endColumn) {
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.beginColumn = beginColumn;
        this.endColumn = endColumn;
        this.inputFilePath = inputFilePath;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public String getLocation() {
        String location = this.inputFilePath;
        if (this.beginLine != -1) {
            location = location + ":" + this.beginLine;
            if (this.beginColumn != -1) {
                location = location + "-" + this.beginColumn;
            }
        }
        return location;
    }

    public String toString() {
        return this.getLocation();
    }
}

