/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingContainer;
import org.objectweb.fractal.adl.bindings.BindingErrors;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.error.NodeErrorLocator;
import org.objectweb.fractal.adl.implementations.ImplementationContainer;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterfaceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnboundInterfaceDetectorLoader
extends AbstractLoader {
    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        if (d instanceof ComponentContainer) {
            this.checkDefinition((ComponentContainer)((Object)d));
        }
        return d;
    }

    protected void checkDefinition(ComponentContainer definition) throws ADLException {
        IdentityHashMap<Component, ComponentBindingInfo> bindingInfos = new IdentityHashMap<Component, ComponentBindingInfo>();
        this.checkNode(definition, bindingInfos, new HashSet<Component>());
        for (Map.Entry entry : bindingInfos.entrySet()) {
            if (((ComponentBindingInfo)entry.getValue()).unboundInterfaces == null) continue;
            Component comp = (Component)entry.getKey();
            Iterator<String> i$ = ((ComponentBindingInfo)entry.getValue()).unboundInterfaces.iterator();
            if (!i$.hasNext()) continue;
            String itfNode = i$.next();
            throw new ADLException((ErrorTemplate)BindingErrors.UNBOUND_CLIENT_INTERFACE, (Node)comp, new Object[]{itfNode, comp.getName()});
        }
    }

    protected void checkNode(ComponentContainer node, Map<Component, ComponentBindingInfo> bindingInfos, Set<Component> visitedComponents) throws ADLException {
        if (this.isPrimitive(node)) {
            return;
        }
        HashMap<String, Binding> bindings = new HashMap<String, Binding>();
        if (node instanceof BindingContainer) {
            for (Binding binding : ((BindingContainer)((Object)node)).getBindings()) {
                bindings.put(binding.getFrom(), binding);
            }
        }
        for (Component component : node.getComponents()) {
            if (!(component instanceof InterfaceContainer)) continue;
            ComponentBindingInfo bindingInfo = bindingInfos.get(component);
            if (bindingInfo == null) {
                bindingInfo = new ComponentBindingInfo();
                bindingInfos.put(component, bindingInfo);
            }
            this.checkSubComponent(component, bindings, bindingInfo);
        }
        this.checkComposite(node, bindings);
        for (Component component : node.getComponents()) {
            this.checkNode(component, bindingInfos, visitedComponents);
        }
    }

    protected void checkSubComponent(Component component, Map<String, Binding> bindings, ComponentBindingInfo bindingInfo) throws ADLException {
        for (Interface itf : ((InterfaceContainer)((Object)component)).getInterfaces()) {
            if (!TypeInterfaceUtil.isClient(itf) || !TypeInterfaceUtil.isMandatory(itf)) continue;
            this.checkClientInterface(component, itf, itf.getName(), bindingInfo, bindings);
        }
    }

    protected void checkClientInterface(Component component, Interface itf, String itfName, ComponentBindingInfo bindingInfo, Map<String, Binding> bindings) throws ADLException {
        Binding binding = this.findBinding(bindings, itf, component.getName(), itfName);
        if (binding != null) {
            Binding previousBinding = bindingInfo.addBoundInterface(this.getFromItfName(binding), binding);
            if (previousBinding != null) {
                throw new ADLException((ErrorTemplate)BindingErrors.DUPLICATED_BINDING, (Node)binding, new Object[]{binding.getFrom(), new NodeErrorLocator(previousBinding)});
            }
        } else {
            bindingInfo.addUnboundInterface(itfName);
        }
    }

    protected void checkComposite(ComponentContainer composite, Map<String, Binding> bindings) throws ADLException {
        if (composite instanceof InterfaceContainer) {
            for (Interface itf : ((InterfaceContainer)((Object)composite)).getInterfaces()) {
                if (!TypeInterfaceUtil.isServer(itf) || !TypeInterfaceUtil.isMandatory(itf) || itf.getName().endsWith("controller") || itf.getName().equals("component") || itf.getName().equals("factory")) continue;
                this.checkCompositeServerInterface(composite, itf, itf.getName(), bindings);
            }
        }
    }

    protected void checkCompositeServerInterface(ComponentContainer composite, Interface itf, String itfName, Map<String, Binding> bindings) throws ADLException {
        if (this.findBinding(bindings, itf, "this", itfName) == null) {
            throw new ADLException((ErrorTemplate)BindingErrors.UNBOUND_COMPOSITE_SERVER_INTERFACE, (Node)itf, new Object[]{itf.getName(), this.getName(composite)});
        }
    }

    protected Binding findBinding(Map<String, Binding> bindings, Interface itf, String compName, String itfName) {
        String bindingName = compName + "." + itfName;
        if (TypeInterfaceUtil.isCollection(itf)) {
            for (Map.Entry<String, Binding> binding : bindings.entrySet()) {
                if (!binding.getKey().startsWith(bindingName)) continue;
                return binding.getValue();
            }
            return null;
        }
        return bindings.get(bindingName);
    }

    protected String getFromItfName(Binding binding) {
        int i = binding.getFrom().indexOf(46);
        return binding.getFrom().substring(i + 1);
    }

    protected boolean isPrimitive(ComponentContainer node) {
        return node instanceof ImplementationContainer && ((ImplementationContainer)((Object)node)).getImplementation() != null;
    }

    protected String getName(ComponentContainer composite) {
        if (composite instanceof Definition) {
            return ((Definition)((Object)composite)).getName();
        }
        if (composite instanceof Component) {
            return ((Component)composite).getName();
        }
        return null;
    }

    protected static final class ComponentBindingInfo {
        Map<String, Binding> boundInterfaces = null;
        Set<String> unboundInterfaces = null;

        protected ComponentBindingInfo() {
        }

        protected Binding addBoundInterface(String itf, Binding bindingNode) {
            if (this.boundInterfaces == null) {
                this.boundInterfaces = new HashMap<String, Binding>();
            }
            if (this.unboundInterfaces != null) {
                this.unboundInterfaces.remove(itf);
            }
            return this.boundInterfaces.put(itf, bindingNode);
        }

        protected void addUnboundInterface(String itf) {
            if (this.boundInterfaces != null && this.boundInterfaces.containsKey(itf)) {
                return;
            }
            if (this.unboundInterfaces == null) {
                this.unboundInterfaces = new HashSet<String>();
            }
            this.unboundInterfaces.add(itf);
        }
    }
}

