/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.fractal.adl.ContextLocal;
import org.objectweb.fractal.adl.bindings.BindingBuilder;
import org.objectweb.fractal.adl.bindings.JavaBindingEnd;
import org.objectweb.fractal.adl.bindings.JavaBindingUtil;
import org.objectweb.fractal.api.control.IllegalBindingException;

public class JavaBindingBuilder
implements BindingBuilder {
    private final ContextLocal<Map<JavaBindingEnd, JavaBindingEnd>> bindingLists = new ContextLocal();

    public void bindComponent(int type, Object clientComp, String clientItf, Object serverComp, String serverItf, Object context) throws IllegalBindingException {
        JavaBindingEnd clientSide = new JavaBindingEnd(clientComp, clientItf);
        JavaBindingEnd serverSide = new JavaBindingEnd(serverComp, serverItf);
        Map<JavaBindingEnd, JavaBindingEnd> bindings = this.bindingLists.get(context);
        if (bindings == null) {
            bindings = new HashMap<JavaBindingEnd, JavaBindingEnd>();
            this.bindingLists.set(context, bindings);
        }
        bindings.put(clientSide, serverSide);
        Iterator<Map.Entry<JavaBindingEnd, JavaBindingEnd>> iter = bindings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<JavaBindingEnd, JavaBindingEnd> entry = iter.next();
            clientSide = entry.getKey();
            serverSide = entry.getValue();
            while (serverSide != null && serverSide.isComposite()) {
                JavaBindingUtil.storeReverseImportBinding(serverSide, clientSide);
                serverSide = bindings.get(serverSide);
            }
            if (serverSide == null) continue;
            clientSide.bind(serverSide);
            if (clientSide.isComposite()) continue;
            iter.remove();
        }
    }
}

