/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.attributes;

import java.lang.reflect.Method;
import org.objectweb.fractal.adl.attributes.AttributeBuilder;

public class JavaAttributeBuilder
implements AttributeBuilder {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(Object component, String attributeController, String name, String value, Object context) throws Exception {
        Object attrValue;
        Class<?> c = component.getClass();
        String attrName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        String getterName = "get" + attrName;
        String setterName = "set" + attrName;
        Method getter = c.getMethod(getterName, new Class[0]);
        Method setter = c.getMethod(setterName, getter.getReturnType());
        Class<?> attrType = getter.getReturnType();
        if (attrType.equals(String.class)) {
            attrValue = value;
        } else {
            if (!attrType.isPrimitive()) throw new Exception("Unsupported attribute type: " + attrType);
            if (attrType.equals(Integer.TYPE)) {
                attrValue = Integer.valueOf(value);
            } else if (attrType.equals(Long.TYPE)) {
                attrValue = Long.valueOf(value);
            } else if (attrType.equals(Float.TYPE)) {
                attrValue = Float.valueOf(value);
            } else if (attrType.equals(Double.TYPE)) {
                attrValue = Double.valueOf(value);
            } else if (attrType.equals(Byte.TYPE)) {
                attrValue = Byte.valueOf(value);
            } else if (attrType.equals(Character.TYPE)) {
                if (value.length() != 1) {
                    throw new Exception("Bad char value: " + value);
                }
                attrValue = new Character(value.charAt(0));
            } else if (attrType.equals(Short.TYPE)) {
                attrValue = Short.valueOf(value);
            } else {
                if (!attrType.equals(Boolean.TYPE)) throw new Exception("Unexpected case");
                if (!value.equals("true") && !value.equals("false")) {
                    throw new Exception("Bad boolean value: " + value);
                }
                attrValue = new Boolean(value.equals("true"));
            }
        }
        setter.invoke(component, attrValue);
    }
}

