/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.attributes;

import java.lang.reflect.Method;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.CompilerError;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.attributes.Attribute;
import org.objectweb.fractal.adl.attributes.AttributeErrors;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.error.ChainedErrorLocator;
import org.objectweb.fractal.adl.error.ErrorLocator;
import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.error.NodeErrorLocator;
import org.objectweb.fractal.adl.interfaces.IDLLoader;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeLoader
extends AbstractLoader {
    public static final String INTERFACE_LOADER_BINDING = "interface-loader";
    public IDLLoader interfaceLoaderItf;

    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d, context);
        return d;
    }

    protected void checkNode(Object node, Map<Object, Object> context) throws ADLException {
        if (node instanceof AttributesContainer) {
            this.checkAttributesContainer((AttributesContainer)node, context);
        }
        if (node instanceof ComponentContainer) {
            for (Component comp : ((ComponentContainer)node).getComponents()) {
                this.checkNode(comp, context);
            }
        }
    }

    protected void checkAttributesContainer(AttributesContainer container, Map<Object, Object> context) throws ADLException {
        Attributes attrs = container.getAttributes();
        if (attrs != null) {
            Class c;
            String signature = attrs.getSignature();
            if (signature == null) {
                throw new ADLException((ErrorTemplate)AttributeErrors.SIGNATURE_MISSING, (Node)attrs, new Object[0]);
            }
            try {
                c = (Class)this.interfaceLoaderItf.loadInterface(attrs.getSignature(), context);
            }
            catch (ADLException e) {
                ChainedErrorLocator.chainLocator(e, attrs);
                throw e;
            }
            for (Attribute attribute : attrs.getAttributes()) {
                Method getter;
                String attrName = attribute.getName();
                String attrValue = attribute.getValue();
                if (attrName == null) {
                    throw new ADLException((ErrorTemplate)AttributeErrors.NAME_MISSING, (Node)attribute, new Object[0]);
                }
                if (attrValue == null) {
                    throw new ADLException((ErrorTemplate)AttributeErrors.VALUE_MISSING, (Node)attribute, new Object[0]);
                }
                String getterName = "get" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
                try {
                    getter = c.getMethod(getterName, new Class[0]);
                }
                catch (Exception e) {
                    throw new ADLException((ErrorTemplate)AttributeErrors.NO_SUCH_ATTRIBUTE, (Node)attribute, new Object[]{e, attrName});
                }
                Class<?> attrType = getter.getReturnType();
                if (attrType.isPrimitive()) {
                    if (attrType.equals(Integer.TYPE)) {
                        try {
                            Integer.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException((ErrorTemplate)AttributeErrors.INVALID_INTEGER_VALUE, (Node)attribute, new Object[]{attrValue, attrName});
                        }
                    }
                    if (attrType.equals(Long.TYPE)) {
                        try {
                            Long.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException((ErrorTemplate)AttributeErrors.INVALID_LONG_VALUE, (Node)attribute, new Object[]{attrValue, attrName});
                        }
                    }
                    if (attrType.equals(Float.TYPE)) {
                        try {
                            Float.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException((ErrorTemplate)AttributeErrors.INVALID_FLOAT_VALUE, (Node)attribute, new Object[]{attrValue, attrName});
                        }
                    }
                    if (attrType.equals(Double.TYPE)) {
                        try {
                            Double.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException((ErrorTemplate)AttributeErrors.INVALID_DOUBLE_VALUE, (Node)attribute, new Object[]{attrValue, attrName});
                        }
                    }
                    if (attrType.equals(Byte.TYPE)) {
                        try {
                            Byte.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException((ErrorTemplate)AttributeErrors.INVALID_BYTE_VALUE, (Node)attribute, new Object[]{attrValue, attrName});
                        }
                    }
                    if (attrType.equals(Character.TYPE)) {
                        if (attrValue.length() == 1) continue;
                        throw new ADLException((ErrorTemplate)AttributeErrors.INVALID_CHAR_VALUE, (Node)attribute, new Object[]{attrValue, attrName});
                    }
                    if (attrType.equals(Short.TYPE)) {
                        try {
                            Short.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException((ErrorTemplate)AttributeErrors.INVALID_SHORT_VALUE, (Node)attribute, new Object[]{attrValue, attrName});
                        }
                    }
                    if (attrType.equals(Boolean.TYPE)) {
                        if (attrValue.equals("true") || attrValue.equals("false")) continue;
                        throw new ADLException((ErrorTemplate)AttributeErrors.INVALID_BOOLEAN_VALUE, (Node)attribute, new Object[]{attrValue, attrName});
                    }
                    throw new CompilerError((ErrorTemplate)AttributeErrors.UNEXPECTED_ATTRIBUTE_TYPE, (ErrorLocator)new NodeErrorLocator(attribute), attrType, attrName);
                }
                if (attrType == String.class) continue;
                throw new ADLException((ErrorTemplate)AttributeErrors.UNSUPPORTED_ATTRIBUTE_TYPE, (Node)attribute, new Object[]{attrType, attrName});
            }
        }
    }

    @Override
    public void bindFc(String s, Object o) throws NoSuchInterfaceException, IllegalBindingException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceLoaderItf = (IDLLoader)o;
        } else {
            super.bindFc(s, o);
        }
    }

    @Override
    public String[] listFc() {
        String[] superList = super.listFc();
        String[] list = new String[superList.length + 1];
        list[0] = INTERFACE_LOADER_BINDING;
        System.arraycopy(superList, 0, list, 1, superList.length);
        return list;
    }

    @Override
    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            return this.interfaceLoaderItf;
        }
        return super.lookupFc(s);
    }

    @Override
    public void unbindFc(String s) throws IllegalBindingException, NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceLoaderItf = null;
        } else {
            super.unbindFc(s);
        }
    }
}

