/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.arguments;

import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.error.ErrorTemplateValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentErrors
extends Enum<ArgumentErrors>
implements ErrorTemplate {
    public static final /* enum */ ArgumentErrors INVALID_ARGUMENT_VALUE_LIST = new ArgumentErrors("Syntax error in definition name.", new Object[0]);
    public static final /* enum */ ArgumentErrors INVALID_ARGUMENT_VALUE_SPECIFICATION = new ArgumentErrors("Invalid argument value list: cannot mix argument specified by name and argument specified by position.", new Object[0]);
    public static final /* enum */ ArgumentErrors EMPTY_ARGUMENT_NAME = new ArgumentErrors("Invalid empty argument name in argument list \"%s\"", "arglist");
    public static final /* enum */ ArgumentErrors INVALID_ARGNAME = new ArgumentErrors("Invalid argument name \"%s\"; can't contain a '%s'", "argname", "char");
    public static final /* enum */ ArgumentErrors NO_VALUE = new ArgumentErrors("No value defined for argument \"%s\"", "argname");
    public static final /* enum */ ArgumentErrors INVALID_PATTERN_SYNTAX_ERROR = new ArgumentErrors("Syntax error in expression \"%s\"", "expr");
    public static final /* enum */ ArgumentErrors INVALID_PATTERN_DEFAULT_VALUE = new ArgumentErrors("Syntax error in expression \"%s\": default values are not allowed for argument substitution", "expr");
    public static final /* enum */ ArgumentErrors UNKNOWN_PREFIX = new ArgumentErrors("Unknown prefix \"%s\" in \"%s\"", "prefix", "argname");
    public static final /* enum */ ArgumentErrors UNDEFINED_ARGUMENT = new ArgumentErrors("Undefined argument \"%s\"", "argname");
    public static final /* enum */ ArgumentErrors INVALID_VALUE_NOT_A_STRING = new ArgumentErrors("Invalid variable value for argument \"%s\": not a String", "argname");
    public static final String GROUP_ID = "ARG";
    private int id = this.ordinal();
    private String format;
    private static final /* synthetic */ ArgumentErrors[] $VALUES;

    public static ArgumentErrors[] values() {
        return (ArgumentErrors[])$VALUES.clone();
    }

    public static ArgumentErrors valueOf(String name) {
        return Enum.valueOf(ArgumentErrors.class, name);
    }

    private ArgumentErrors(String format, Object ... args) {
        this.format = format;
        assert (ErrorTemplateValidator.validErrorTemplate(this, args));
    }

    @Override
    public int getErrorId() {
        return this.id;
    }

    @Override
    public String getGroupId() {
        return GROUP_ID;
    }

    @Override
    public String getFormatedMessage(Object ... args) {
        return String.format(this.format, args);
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    static {
        $VALUES = new ArgumentErrors[]{INVALID_ARGUMENT_VALUE_LIST, INVALID_ARGUMENT_VALUE_SPECIFICATION, EMPTY_ARGUMENT_NAME, INVALID_ARGNAME, NO_VALUE, INVALID_PATTERN_SYNTAX_ERROR, INVALID_PATTERN_DEFAULT_VALUE, UNKNOWN_PREFIX, UNDEFINED_ARGUMENT, INVALID_VALUE_NOT_A_STRING};
    }
}

