/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.error.Error;
import org.objectweb.fractal.adl.error.ErrorLocator;
import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.error.GenericErrors;
import org.objectweb.fractal.adl.error.NodeErrorLocator;

public class ADLException
extends Exception {
    private final Error error;

    public ADLException(ErrorTemplate template, Object ... args) {
        this(template, null, null, args);
    }

    public ADLException(ErrorTemplate template, Node node, Object ... args) {
        this(template, (ErrorLocator)new NodeErrorLocator(node), null, args);
    }

    public ADLException(ErrorTemplate template, ErrorLocator locator, Object ... args) {
        this(template, locator, null, args);
    }

    public ADLException(ErrorTemplate template, Throwable cause, Object ... args) {
        this(template, null, cause, args);
    }

    public ADLException(ErrorTemplate template, ErrorLocator locator, Throwable cause, Object ... args) {
        this(new Error(template, locator, cause, args));
    }

    public ADLException(Error error) {
        super(error.getCause());
        this.error = error;
    }

    @Deprecated
    public ADLException(String msg) {
        this(msg, null, null);
    }

    @Deprecated
    public ADLException(String msg, Node src) {
        this(msg, src, null);
    }

    @Deprecated
    public ADLException(String msg, Exception e) {
        this(msg, null, e);
    }

    @Deprecated
    public ADLException(String msg, Node src, Exception e) {
        super(e);
        this.error = new Error((ErrorTemplate)GenericErrors.GENERIC_ERROR, (ErrorLocator)(src == null ? null : new NodeErrorLocator(src)), e, msg);
    }

    @Deprecated
    public Node getSrc() {
        if (this.error.getLocator() instanceof NodeErrorLocator) {
            return ((NodeErrorLocator)this.error.getLocator()).getNode();
        }
        return null;
    }

    public Error getError() {
        return this.error;
    }

    public String getMessage() {
        return this.error.toString();
    }
}

