/*
 * Decompiled with CFR 0.152.
 */
package eu.lod2.nlp2rdf.schema.topic;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.IndividualImpl;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import eu.lod2.nlp2rdf.schema.str.Document;
import eu.lod2.nlp2rdf.schema.str.IDocument;
import eu.lod2.nlp2rdf.schema.tools.Factory;
import eu.lod2.nlp2rdf.schema.tools.Vocabulary;
import eu.lod2.nlp2rdf.schema.topic.ITopic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.tbm.eeni.owl2java.model.jenautils.NullFilter;
import nl.tudelft.tbm.eeni.owl2java.model.xsd.XsdUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Topic
extends IndividualImpl
implements ITopic {
    private static Log log = LogFactory.getLog(Topic.class);
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new Topic(n, eg);
            }
            log.warn((Object)("Cannot convert node " + n.toString() + " to  Topic"));
            return null;
        }

        public boolean canWrap(Node n, EnhGraph eg) {
            if (!(eg instanceof OntModel)) {
                return false;
            }
            Profile profile = ((OntModel)eg).getProfile();
            if (!profile.isSupported(n, eg, Individual.class)) {
                return false;
            }
            Graph graph = eg.asGraph();
            return graph.contains(n, RDF.type.asNode(), Vocabulary.Topic.asNode());
        }
    };
    public static final Filter<Topic> nullFilter = new NullFilter<Topic>();
    public static final Map1<Statement, Topic> statementMapper = Topic.mapperFrom(Statement.class);
    public static final Map1<Individual, Topic> individualMapper = Topic.mapperFrom(Individual.class);
    public static final Map1<RDFNode, Topic> nodeMapper = Topic.mapperFrom(RDFNode.class);

    public static <From> Map1<From, Topic> mapperFrom(Class<From> from) {
        return new Map1<From, Topic>(){

            public Topic map1(Object x) {
                if (x instanceof Statement) {
                    Resource r = ((Statement)x).getResource();
                    if (r.canAs(Topic.class)) {
                        return (Topic)r.as(Topic.class);
                    }
                } else if (x instanceof RDFNode && ((RDFNode)x).canAs(Topic.class)) {
                    return (Topic)((RDFNode)x).as(Topic.class);
                }
                return null;
            }
        };
    }

    public Topic(Node n, EnhGraph g) {
        super(n, g);
    }

    public static void register() {
        log.debug((Object)"Registering custom class Topic with jena");
        BuiltinPersonalities.model.add(Topic.class, factory);
        BuiltinPersonalities.model.add(Topic.class, factory);
    }

    public static Topic get(String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return (Topic)individual.as(Topic.class);
    }

    public static Topic get(String uri) {
        return Topic.get(uri, Factory.getDefaultModel());
    }

    public static Iterator<Topic> iterate(OntModel ontModel) {
        ExtendedIterator it = ontModel.listIndividuals((Resource)Vocabulary.Topic);
        return it.mapWith(individualMapper).filterDrop(nullFilter);
    }

    public static Iterator<Topic> iterate() {
        return Topic.iterate(Factory.getDefaultModel());
    }

    public static List<Topic> list(OntModel ontModel) {
        ArrayList<Topic> list = new ArrayList<Topic>();
        Iterator<Topic> it = Topic.iterate(ontModel);
        while (it.hasNext()) {
            Topic cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Topic> list() {
        return Topic.list(Factory.getDefaultModel());
    }

    public static Iterator<Topic> iterate(boolean direct, OntModel ontModel) {
        OntClass cls = ontModel.getOntClass("http://nlp2rdf.lod2.eu/schema/topic/Topic");
        ExtendedIterator it = cls.listInstances(direct);
        WrappedIterator<RDFNode> nodeIt = new WrappedIterator<RDFNode>((Iterator)it){};
        return nodeIt.mapWith(nodeMapper).filterDrop(nullFilter);
    }

    public static Iterator<Topic> iterate(boolean direct) {
        return Topic.iterate(direct, Factory.getDefaultModel());
    }

    public static List<Topic> list(boolean direct, OntModel ontModel) {
        ArrayList<Topic> list = new ArrayList<Topic>();
        Iterator<Topic> it = Topic.iterate(direct, ontModel);
        while (it.hasNext()) {
            Topic cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Topic> list(boolean direct) {
        return Topic.list(direct, Factory.getDefaultModel());
    }

    public static int count(OntModel ontModel) {
        int count = 0;
        Iterator<Topic> it = Topic.iterate(ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count() {
        return Topic.count(Factory.getDefaultModel());
    }

    public static int count(boolean direct, OntModel ontModel) {
        int count = 0;
        Iterator<Topic> it = Topic.iterate(direct, ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count(boolean direct) {
        return Topic.count(direct, Factory.getDefaultModel());
    }

    public static boolean exists(String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return individual != null;
    }

    public static boolean exists(String uri) {
        return Topic.exists(uri, Factory.getDefaultModel());
    }

    public static Topic create(String uri, OntModel ontModel) {
        return (Topic)ontModel.createOntResource(Topic.class, (Resource)Vocabulary.Topic, uri);
    }

    public static Topic create(OntModel ontModel) {
        return Topic.create(null, ontModel);
    }

    public static Topic create(String uri) {
        return Topic.create(uri, Factory.getDefaultModel());
    }

    public static Topic create() {
        return Topic.create(null, Factory.getDefaultModel());
    }

    public static void delete(String uri, OntModel ontModel) {
        Factory.deleteInstance(uri, ontModel);
    }

    public static void delete(String uri) {
        Factory.deleteInstance(uri);
    }

    @Override
    public boolean existsOccursIn() {
        return this.hasProperty((Property)Vocabulary.occursIn);
    }

    @Override
    public boolean hasOccursIn(IDocument documentValue) {
        return this.hasProperty((Property)Vocabulary.occursIn, (RDFNode)documentValue);
    }

    @Override
    public int countOccursIn() {
        int count = 0;
        Iterator<Document> it = this.iterateOccursIn();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Document> iterateOccursIn() {
        StmtIterator it = this.listProperties((Property)Vocabulary.occursIn);
        return it.mapWith(Document.statementMapper).filterDrop(Document.nullFilter);
    }

    @Override
    public List<Document> listOccursIn() {
        ArrayList<Document> list = new ArrayList<Document>();
        Iterator<Document> it = this.iterateOccursIn();
        while (it.hasNext()) {
            Document inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addOccursIn(IDocument documentValue) {
        this.addProperty((Property)Vocabulary.occursIn, (RDFNode)documentValue);
    }

    @Override
    public void addAllOccursIn(List<? extends IDocument> documentList) {
        for (IDocument iDocument : documentList) {
            this.addOccursIn(iDocument);
        }
    }

    @Override
    public void removeOccursIn(IDocument documentValue) {
        this.removeProperty((Property)Vocabulary.occursIn, (RDFNode)documentValue);
    }

    @Override
    public void removeAllOccursIn() {
        this.removeAll((Property)Vocabulary.occursIn);
    }

    @Override
    public boolean existsCharacterticLemma() {
        return this.hasProperty((Property)Vocabulary.characterticLemma);
    }

    @Override
    public boolean hasCharacterticLemma(String stringValue) {
        return this.hasProperty((Property)Vocabulary.characterticLemma);
    }

    @Override
    public int countCharacterticLemma() {
        int count = 0;
        Iterator<String> it = this.iterateCharacterticLemma();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateCharacterticLemma() {
        StmtIterator it = this.listProperties((Property)Vocabulary.characterticLemma);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<String> listCharacterticLemma() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateCharacterticLemma();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addCharacterticLemma(String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.characterticLemma, (RDFNode)literal);
    }

    @Override
    public void addAllCharacterticLemma(List<String> stringList) {
        for (String o : stringList) {
            this.addCharacterticLemma(o);
        }
    }

    @Override
    public void removeCharacterticLemma(String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.characterticLemma, (RDFNode)literal);
    }

    @Override
    public void removeAllCharacterticLemma() {
        this.removeAll((Property)Vocabulary.characterticLemma);
    }
}

