/*
 * Decompiled with CFR 0.152.
 */
package eu.lod2.nlp2rdf.schema.tools;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import eu.lod2.nlp2rdf.schema.Thing;
import eu.lod2.nlp2rdf.schema.error.Error;
import eu.lod2.nlp2rdf.schema.sso.Phrase;
import eu.lod2.nlp2rdf.schema.sso.Sentence;
import eu.lod2.nlp2rdf.schema.sso.StopWord;
import eu.lod2.nlp2rdf.schema.sso.Word;
import eu.lod2.nlp2rdf.schema.str.ContextHashBasedString;
import eu.lod2.nlp2rdf.schema.str.Document;
import eu.lod2.nlp2rdf.schema.str.OffsetBasedString;
import eu.lod2.nlp2rdf.schema.str.String;
import eu.lod2.nlp2rdf.schema.tools.Factory;
import eu.lod2.nlp2rdf.schema.topic.Topic;
import java.util.Iterator;
import nl.tudelft.tbm.eeni.owl2java.model.xsd.XsdMapTestData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Test {
    private static Log log = LogFactory.getLog(Test.class);
    private static java.lang.String namePrefix = "ClassInstance";
    private static int nameCount = 0;

    public static void main(java.lang.String[] args) {
        Test.run();
    }

    private static java.lang.String getNewInstanceName() {
        return namePrefix + ++nameCount;
    }

    private static java.lang.String getNewInstanceURI() {
        java.lang.String localName = Test.getNewInstanceName();
        java.lang.String prefix = "jmodel.getBaseNamespace()";
        return prefix + "#" + localName;
    }

    public static void run() {
        java.lang.String prefix = "jmodel.getBaseNamespace()";
        log.info((Object)"Creating an empty ontology");
        OntModel ontModel = ModelFactory.createOntologyModel();
        Ontology ontology = ontModel.createOntology(prefix);
        log.info((Object)"Registering custom classes with jena");
        Factory.registerImports(ontology, ontModel);
        Factory.registerCustomClasses();
        log.info((Object)"Starting test case run");
        Test.runThing(ontModel);
        Test.runStopWord(ontModel);
        Test.runError(ontModel);
        Test.runWord(ontModel);
        Test.runPhrase(ontModel);
        Test.runOffsetBasedString(ontModel);
        Test.runDocument(ontModel);
        Test.runSentence(ontModel);
        Test.runString(ontModel);
        Test.runTopic(ontModel);
        Test.runContextHashBasedString(ontModel);
        log.info((Object)"DONE DONE DONE DONE DONE DONE DONE DONE");
    }

    protected static void runThing(OntModel ontModel) {
        log.info((Object)"Testing class Thing");
        log.debug((Object)"  Creating anonymous class instance");
        Thing.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        Thing.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Thing.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = Thing.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        Thing clsInstance = Thing.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<Thing> it = Thing.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (Thing cls : Thing.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<Thing> it2 = Thing.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (Thing cls : Thing.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + Thing.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        Thing.delete(uri, ontModel);
    }

    protected static void runStopWord(OntModel ontModel) {
        log.info((Object)"Testing class StopWord");
        log.debug((Object)"  Creating anonymous class instance");
        StopWord.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        StopWord.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        StopWord.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = StopWord.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        StopWord clsInstance = StopWord.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<StopWord> it = StopWord.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (StopWord cls : StopWord.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<StopWord> it2 = StopWord.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (StopWord cls : StopWord.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + StopWord.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        StopWord.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        StopWord.create(uri, ontModel);
        StopWord instance = StopWord.get(uri, ontModel);
        log.info((Object)"  Testing property sentence of class StopWord");
        log.debug((Object)"    Any property sentence exist?");
        log.debug((Object)("    -> exists: " + instance.existsSentence()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setSentence(Sentence.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getSentence();
        log.debug((Object)"    Removing the property instance");
        instance.removeSentence();
        log.info((Object)"  Testing property oliaLink of class StopWord");
        log.debug((Object)"    Any property oliaLink exist?");
        log.debug((Object)("    -> exists: " + instance.existsOliaLink()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addOliaLink(Thing.create(uri, ontModel));
        instance.addOliaLink(Thing.create(Test.getNewInstanceURI(), ontModel));
        instance.addOliaLink(Thing.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Thing> itOliaLink = instance.iterateOliaLink();
        Thing instOliaLink = null;
        while (itOliaLink.hasNext()) {
            instOliaLink = itOliaLink.next();
            log.debug((Object)("    -> instance: " + instOliaLink.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Thing iinstOliaLink : instance.listOliaLink()) {
            log.debug((Object)("    -> instance: " + iinstOliaLink.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countOliaLink()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeOliaLink(instOliaLink);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllOliaLink();
        log.info((Object)"  Testing property previousWord of class StopWord");
        log.debug((Object)"    Any property previousWord exist?");
        log.debug((Object)("    -> exists: " + instance.existsPreviousWord()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setPreviousWord(Word.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getPreviousWord();
        log.debug((Object)"    Removing the property instance");
        instance.removePreviousWord();
        log.info((Object)"  Testing property nextWord of class StopWord");
        log.debug((Object)"    Any property nextWord exist?");
        log.debug((Object)("    -> exists: " + instance.existsNextWord()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setNextWord(Word.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getNextWord();
        log.debug((Object)"    Removing the property instance");
        instance.removeNextWord();
        log.info((Object)"  Testing property nextSentenceTrans of class StopWord");
        log.debug((Object)"    Any property nextSentenceTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsNextSentenceTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addNextSentenceTrans(Word.create(uri, ontModel));
        instance.addNextSentenceTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        instance.addNextSentenceTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Word> itNextSentenceTrans = instance.iterateNextSentenceTrans();
        Word instNextSentenceTrans = null;
        while (itNextSentenceTrans.hasNext()) {
            instNextSentenceTrans = itNextSentenceTrans.next();
            log.debug((Object)("    -> instance: " + instNextSentenceTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Word iinstNextSentenceTrans : instance.listNextSentenceTrans()) {
            log.debug((Object)("    -> instance: " + iinstNextSentenceTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countNextSentenceTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeNextSentenceTrans(instNextSentenceTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllNextSentenceTrans();
        log.info((Object)"  Testing property previousWordTrans of class StopWord");
        log.debug((Object)"    Any property previousWordTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsPreviousWordTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addPreviousWordTrans(Word.create(uri, ontModel));
        instance.addPreviousWordTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        instance.addPreviousWordTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Word> itPreviousWordTrans = instance.iteratePreviousWordTrans();
        Word instPreviousWordTrans = null;
        while (itPreviousWordTrans.hasNext()) {
            instPreviousWordTrans = itPreviousWordTrans.next();
            log.debug((Object)("    -> instance: " + instPreviousWordTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Word iinstPreviousWordTrans : instance.listPreviousWordTrans()) {
            log.debug((Object)("    -> instance: " + iinstPreviousWordTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countPreviousWordTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removePreviousWordTrans(instPreviousWordTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllPreviousWordTrans();
        log.info((Object)"  Testing property nextWordTrans of class StopWord");
        log.debug((Object)"    Any property nextWordTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsNextWordTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addNextWordTrans(Word.create(uri, ontModel));
        instance.addNextWordTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        instance.addNextWordTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Word> itNextWordTrans = instance.iterateNextWordTrans();
        Word instNextWordTrans = null;
        while (itNextWordTrans.hasNext()) {
            instNextWordTrans = itNextWordTrans.next();
            log.debug((Object)("    -> instance: " + instNextWordTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Word iinstNextWordTrans : instance.listNextWordTrans()) {
            log.debug((Object)("    -> instance: " + iinstNextWordTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countNextWordTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeNextWordTrans(instNextWordTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllNextWordTrans();
        log.info((Object)"  Testing property posTag of class StopWord");
        log.debug((Object)"    Any property posTag exist?");
        log.debug((Object)("    -> exists: " + instance.existsPosTag()));
        log.debug((Object)"    Adding property instance");
        instance.addPosTag(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itPosTag = instance.iteratePosTag();
        java.lang.String instPosTag = null;
        while (itPosTag.hasNext()) {
            instPosTag = itPosTag.next();
            log.debug((Object)("    -> instance: " + instPosTag));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstPosTag : instance.listPosTag()) {
            log.debug((Object)("    -> instance: " + iinstPosTag));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countPosTag()));
        log.debug((Object)"    Removing a known property instance");
        instance.removePosTag(instPosTag);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllPosTag();
        log.info((Object)"  Testing property lemma of class StopWord");
        log.debug((Object)"    Any property lemma exist?");
        log.debug((Object)("    -> exists: " + instance.existsLemma()));
        log.debug((Object)"    Adding property instance");
        instance.addLemma(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLemma = instance.iterateLemma();
        java.lang.String instLemma = null;
        while (itLemma.hasNext()) {
            instLemma = itLemma.next();
            log.debug((Object)("    -> instance: " + instLemma));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLemma : instance.listLemma()) {
            log.debug((Object)("    -> instance: " + iinstLemma));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLemma()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLemma(instLemma);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLemma();
        log.info((Object)"  Testing property stem of class StopWord");
        log.debug((Object)"    Any property stem exist?");
        log.debug((Object)("    -> exists: " + instance.existsStem()));
        log.debug((Object)"    Adding property instance");
        instance.addStem(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itStem = instance.iterateStem();
        java.lang.String instStem = null;
        while (itStem.hasNext()) {
            instStem = itStem.next();
            log.debug((Object)("    -> instance: " + instStem));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstStem : instance.listStem()) {
            log.debug((Object)("    -> instance: " + iinstStem));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countStem()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeStem(instStem);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllStem();
        log.info((Object)"  Testing property superString of class StopWord");
        log.debug((Object)"    Any property superString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperString(String.create(uri, ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperString = instance.iterateSuperString();
        String instSuperString = null;
        while (itSuperString.hasNext()) {
            instSuperString = itSuperString.next();
            log.debug((Object)("    -> instance: " + instSuperString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperString : instance.listSuperString()) {
            log.debug((Object)("    -> instance: " + iinstSuperString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperString(instSuperString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperString();
        log.info((Object)"  Testing property subString of class StopWord");
        log.debug((Object)"    Any property subString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubString(String.create(uri, ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubString = instance.iterateSubString();
        String instSubString = null;
        while (itSubString.hasNext()) {
            instSubString = itSubString.next();
            log.debug((Object)("    -> instance: " + instSubString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubString : instance.listSubString()) {
            log.debug((Object)("    -> instance: " + iinstSubString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubString(instSubString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubString();
        log.info((Object)"  Testing property superStringTrans of class StopWord");
        log.debug((Object)"    Any property superStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperStringTrans(String.create(uri, ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperStringTrans = instance.iterateSuperStringTrans();
        String instSuperStringTrans = null;
        while (itSuperStringTrans.hasNext()) {
            instSuperStringTrans = itSuperStringTrans.next();
            log.debug((Object)("    -> instance: " + instSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperStringTrans : instance.listSuperStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperStringTrans(instSuperStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperStringTrans();
        log.info((Object)"  Testing property subStringTrans of class StopWord");
        log.debug((Object)"    Any property subStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubStringTrans(String.create(uri, ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubStringTrans = instance.iterateSubStringTrans();
        String instSubStringTrans = null;
        while (itSubStringTrans.hasNext()) {
            instSubStringTrans = itSubStringTrans.next();
            log.debug((Object)("    -> instance: " + instSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubStringTrans : instance.listSubStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubStringTrans(instSubStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubStringTrans();
        log.info((Object)"  Testing property anchorOf of class StopWord");
        log.debug((Object)"    Any property anchorOf exist?");
        log.debug((Object)("    -> exists: " + instance.existsAnchorOf()));
        log.debug((Object)"    Adding property instance");
        instance.setAnchorOf(XsdMapTestData.getString("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getAnchorOf();
        log.debug((Object)"    Removing the property instance");
        instance.removeAnchorOf();
        log.info((Object)"  Testing property endIndex of class StopWord");
        log.debug((Object)"    Any property endIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsEndIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addEndIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itEndIndex = instance.iterateEndIndex();
        java.lang.String instEndIndex = null;
        while (itEndIndex.hasNext()) {
            instEndIndex = itEndIndex.next();
            log.debug((Object)("    -> instance: " + instEndIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstEndIndex : instance.listEndIndex()) {
            log.debug((Object)("    -> instance: " + iinstEndIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countEndIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeEndIndex(instEndIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllEndIndex();
        log.info((Object)"  Testing property beginIndex of class StopWord");
        log.debug((Object)"    Any property beginIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsBeginIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addBeginIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itBeginIndex = instance.iterateBeginIndex();
        java.lang.String instBeginIndex = null;
        while (itBeginIndex.hasNext()) {
            instBeginIndex = itBeginIndex.next();
            log.debug((Object)("    -> instance: " + instBeginIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstBeginIndex : instance.listBeginIndex()) {
            log.debug((Object)("    -> instance: " + iinstBeginIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countBeginIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeBeginIndex(instBeginIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllBeginIndex();
        log.info((Object)"  Testing property rightContext of class StopWord");
        log.debug((Object)"    Any property rightContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsRightContext()));
        log.debug((Object)"    Adding property instance");
        instance.addRightContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itRightContext = instance.iterateRightContext();
        java.lang.String instRightContext = null;
        while (itRightContext.hasNext()) {
            instRightContext = itRightContext.next();
            log.debug((Object)("    -> instance: " + instRightContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstRightContext : instance.listRightContext()) {
            log.debug((Object)("    -> instance: " + iinstRightContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countRightContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeRightContext(instRightContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllRightContext();
        log.info((Object)"  Testing property leftContext of class StopWord");
        log.debug((Object)"    Any property leftContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsLeftContext()));
        log.debug((Object)"    Adding property instance");
        instance.addLeftContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLeftContext = instance.iterateLeftContext();
        java.lang.String instLeftContext = null;
        while (itLeftContext.hasNext()) {
            instLeftContext = itLeftContext.next();
            log.debug((Object)("    -> instance: " + instLeftContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLeftContext : instance.listLeftContext()) {
            log.debug((Object)("    -> instance: " + iinstLeftContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLeftContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLeftContext(instLeftContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLeftContext();
    }

    protected static void runError(OntModel ontModel) {
        log.info((Object)"Testing class Error");
        log.debug((Object)"  Creating anonymous class instance");
        Error.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        Error.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Error.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = Error.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        Error clsInstance = Error.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<Error> it = Error.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (Error cls : Error.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<Error> it2 = Error.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (Error cls : Error.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + Error.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        Error.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Error.create(uri, ontModel);
        Error instance = Error.get(uri, ontModel);
        log.info((Object)"  Testing property fatal of class Error");
        log.debug((Object)"    Any property fatal exist?");
        log.debug((Object)("    -> exists: " + instance.existsFatal()));
        log.debug((Object)"    Adding property instance");
        instance.setFatal(XsdMapTestData.getBoolean("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getFatal();
        log.debug((Object)"    Removing the property instance");
        instance.removeFatal();
        log.info((Object)"  Testing property source of class Error");
        log.debug((Object)"    Any property source exist?");
        log.debug((Object)("    -> exists: " + instance.existsSource()));
        log.debug((Object)"    Adding property instance");
        instance.addSource(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itSource = instance.iterateSource();
        java.lang.String instSource = null;
        while (itSource.hasNext()) {
            instSource = itSource.next();
            log.debug((Object)("    -> instance: " + instSource));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstSource : instance.listSource()) {
            log.debug((Object)("    -> instance: " + iinstSource));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSource()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSource(instSource);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSource();
        log.info((Object)"  Testing property message of class Error");
        log.debug((Object)"    Any property message exist?");
        log.debug((Object)("    -> exists: " + instance.existsMessage()));
        log.debug((Object)"    Adding property instance");
        instance.addMessage(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itMessage = instance.iterateMessage();
        java.lang.String instMessage = null;
        while (itMessage.hasNext()) {
            instMessage = itMessage.next();
            log.debug((Object)("    -> instance: " + instMessage));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstMessage : instance.listMessage()) {
            log.debug((Object)("    -> instance: " + iinstMessage));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countMessage()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeMessage(instMessage);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllMessage();
    }

    protected static void runWord(OntModel ontModel) {
        log.info((Object)"Testing class Word");
        log.debug((Object)"  Creating anonymous class instance");
        Word.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        Word.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Word.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = Word.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        Word clsInstance = Word.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<Word> it = Word.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (Word cls : Word.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<Word> it2 = Word.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (Word cls : Word.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + Word.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        Word.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Word.create(uri, ontModel);
        Word instance = Word.get(uri, ontModel);
        log.info((Object)"  Testing property sentence of class Word");
        log.debug((Object)"    Any property sentence exist?");
        log.debug((Object)("    -> exists: " + instance.existsSentence()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setSentence(Sentence.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getSentence();
        log.debug((Object)"    Removing the property instance");
        instance.removeSentence();
        log.info((Object)"  Testing property oliaLink of class Word");
        log.debug((Object)"    Any property oliaLink exist?");
        log.debug((Object)("    -> exists: " + instance.existsOliaLink()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addOliaLink(Thing.create(uri, ontModel));
        instance.addOliaLink(Thing.create(Test.getNewInstanceURI(), ontModel));
        instance.addOliaLink(Thing.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Thing> itOliaLink = instance.iterateOliaLink();
        Thing instOliaLink = null;
        while (itOliaLink.hasNext()) {
            instOliaLink = itOliaLink.next();
            log.debug((Object)("    -> instance: " + instOliaLink.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Thing iinstOliaLink : instance.listOliaLink()) {
            log.debug((Object)("    -> instance: " + iinstOliaLink.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countOliaLink()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeOliaLink(instOliaLink);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllOliaLink();
        log.info((Object)"  Testing property previousWord of class Word");
        log.debug((Object)"    Any property previousWord exist?");
        log.debug((Object)("    -> exists: " + instance.existsPreviousWord()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setPreviousWord(Word.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getPreviousWord();
        log.debug((Object)"    Removing the property instance");
        instance.removePreviousWord();
        log.info((Object)"  Testing property nextWord of class Word");
        log.debug((Object)"    Any property nextWord exist?");
        log.debug((Object)("    -> exists: " + instance.existsNextWord()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setNextWord(Word.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getNextWord();
        log.debug((Object)"    Removing the property instance");
        instance.removeNextWord();
        log.info((Object)"  Testing property nextSentenceTrans of class Word");
        log.debug((Object)"    Any property nextSentenceTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsNextSentenceTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addNextSentenceTrans(Word.create(uri, ontModel));
        instance.addNextSentenceTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        instance.addNextSentenceTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Word> itNextSentenceTrans = instance.iterateNextSentenceTrans();
        Word instNextSentenceTrans = null;
        while (itNextSentenceTrans.hasNext()) {
            instNextSentenceTrans = itNextSentenceTrans.next();
            log.debug((Object)("    -> instance: " + instNextSentenceTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Word iinstNextSentenceTrans : instance.listNextSentenceTrans()) {
            log.debug((Object)("    -> instance: " + iinstNextSentenceTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countNextSentenceTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeNextSentenceTrans(instNextSentenceTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllNextSentenceTrans();
        log.info((Object)"  Testing property previousWordTrans of class Word");
        log.debug((Object)"    Any property previousWordTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsPreviousWordTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addPreviousWordTrans(Word.create(uri, ontModel));
        instance.addPreviousWordTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        instance.addPreviousWordTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Word> itPreviousWordTrans = instance.iteratePreviousWordTrans();
        Word instPreviousWordTrans = null;
        while (itPreviousWordTrans.hasNext()) {
            instPreviousWordTrans = itPreviousWordTrans.next();
            log.debug((Object)("    -> instance: " + instPreviousWordTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Word iinstPreviousWordTrans : instance.listPreviousWordTrans()) {
            log.debug((Object)("    -> instance: " + iinstPreviousWordTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countPreviousWordTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removePreviousWordTrans(instPreviousWordTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllPreviousWordTrans();
        log.info((Object)"  Testing property nextWordTrans of class Word");
        log.debug((Object)"    Any property nextWordTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsNextWordTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addNextWordTrans(Word.create(uri, ontModel));
        instance.addNextWordTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        instance.addNextWordTrans(Word.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Word> itNextWordTrans = instance.iterateNextWordTrans();
        Word instNextWordTrans = null;
        while (itNextWordTrans.hasNext()) {
            instNextWordTrans = itNextWordTrans.next();
            log.debug((Object)("    -> instance: " + instNextWordTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Word iinstNextWordTrans : instance.listNextWordTrans()) {
            log.debug((Object)("    -> instance: " + iinstNextWordTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countNextWordTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeNextWordTrans(instNextWordTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllNextWordTrans();
        log.info((Object)"  Testing property posTag of class Word");
        log.debug((Object)"    Any property posTag exist?");
        log.debug((Object)("    -> exists: " + instance.existsPosTag()));
        log.debug((Object)"    Adding property instance");
        instance.addPosTag(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itPosTag = instance.iteratePosTag();
        java.lang.String instPosTag = null;
        while (itPosTag.hasNext()) {
            instPosTag = itPosTag.next();
            log.debug((Object)("    -> instance: " + instPosTag));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstPosTag : instance.listPosTag()) {
            log.debug((Object)("    -> instance: " + iinstPosTag));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countPosTag()));
        log.debug((Object)"    Removing a known property instance");
        instance.removePosTag(instPosTag);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllPosTag();
        log.info((Object)"  Testing property lemma of class Word");
        log.debug((Object)"    Any property lemma exist?");
        log.debug((Object)("    -> exists: " + instance.existsLemma()));
        log.debug((Object)"    Adding property instance");
        instance.addLemma(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLemma = instance.iterateLemma();
        java.lang.String instLemma = null;
        while (itLemma.hasNext()) {
            instLemma = itLemma.next();
            log.debug((Object)("    -> instance: " + instLemma));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLemma : instance.listLemma()) {
            log.debug((Object)("    -> instance: " + iinstLemma));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLemma()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLemma(instLemma);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLemma();
        log.info((Object)"  Testing property stem of class Word");
        log.debug((Object)"    Any property stem exist?");
        log.debug((Object)("    -> exists: " + instance.existsStem()));
        log.debug((Object)"    Adding property instance");
        instance.addStem(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itStem = instance.iterateStem();
        java.lang.String instStem = null;
        while (itStem.hasNext()) {
            instStem = itStem.next();
            log.debug((Object)("    -> instance: " + instStem));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstStem : instance.listStem()) {
            log.debug((Object)("    -> instance: " + iinstStem));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countStem()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeStem(instStem);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllStem();
        log.info((Object)"  Testing property superString of class Word");
        log.debug((Object)"    Any property superString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperString(String.create(uri, ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperString = instance.iterateSuperString();
        String instSuperString = null;
        while (itSuperString.hasNext()) {
            instSuperString = itSuperString.next();
            log.debug((Object)("    -> instance: " + instSuperString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperString : instance.listSuperString()) {
            log.debug((Object)("    -> instance: " + iinstSuperString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperString(instSuperString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperString();
        log.info((Object)"  Testing property subString of class Word");
        log.debug((Object)"    Any property subString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubString(String.create(uri, ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubString = instance.iterateSubString();
        String instSubString = null;
        while (itSubString.hasNext()) {
            instSubString = itSubString.next();
            log.debug((Object)("    -> instance: " + instSubString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubString : instance.listSubString()) {
            log.debug((Object)("    -> instance: " + iinstSubString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubString(instSubString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubString();
        log.info((Object)"  Testing property superStringTrans of class Word");
        log.debug((Object)"    Any property superStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperStringTrans(String.create(uri, ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperStringTrans = instance.iterateSuperStringTrans();
        String instSuperStringTrans = null;
        while (itSuperStringTrans.hasNext()) {
            instSuperStringTrans = itSuperStringTrans.next();
            log.debug((Object)("    -> instance: " + instSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperStringTrans : instance.listSuperStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperStringTrans(instSuperStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperStringTrans();
        log.info((Object)"  Testing property subStringTrans of class Word");
        log.debug((Object)"    Any property subStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubStringTrans(String.create(uri, ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubStringTrans = instance.iterateSubStringTrans();
        String instSubStringTrans = null;
        while (itSubStringTrans.hasNext()) {
            instSubStringTrans = itSubStringTrans.next();
            log.debug((Object)("    -> instance: " + instSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubStringTrans : instance.listSubStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubStringTrans(instSubStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubStringTrans();
        log.info((Object)"  Testing property anchorOf of class Word");
        log.debug((Object)"    Any property anchorOf exist?");
        log.debug((Object)("    -> exists: " + instance.existsAnchorOf()));
        log.debug((Object)"    Adding property instance");
        instance.setAnchorOf(XsdMapTestData.getString("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getAnchorOf();
        log.debug((Object)"    Removing the property instance");
        instance.removeAnchorOf();
        log.info((Object)"  Testing property endIndex of class Word");
        log.debug((Object)"    Any property endIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsEndIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addEndIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itEndIndex = instance.iterateEndIndex();
        java.lang.String instEndIndex = null;
        while (itEndIndex.hasNext()) {
            instEndIndex = itEndIndex.next();
            log.debug((Object)("    -> instance: " + instEndIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstEndIndex : instance.listEndIndex()) {
            log.debug((Object)("    -> instance: " + iinstEndIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countEndIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeEndIndex(instEndIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllEndIndex();
        log.info((Object)"  Testing property beginIndex of class Word");
        log.debug((Object)"    Any property beginIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsBeginIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addBeginIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itBeginIndex = instance.iterateBeginIndex();
        java.lang.String instBeginIndex = null;
        while (itBeginIndex.hasNext()) {
            instBeginIndex = itBeginIndex.next();
            log.debug((Object)("    -> instance: " + instBeginIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstBeginIndex : instance.listBeginIndex()) {
            log.debug((Object)("    -> instance: " + iinstBeginIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countBeginIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeBeginIndex(instBeginIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllBeginIndex();
        log.info((Object)"  Testing property rightContext of class Word");
        log.debug((Object)"    Any property rightContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsRightContext()));
        log.debug((Object)"    Adding property instance");
        instance.addRightContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itRightContext = instance.iterateRightContext();
        java.lang.String instRightContext = null;
        while (itRightContext.hasNext()) {
            instRightContext = itRightContext.next();
            log.debug((Object)("    -> instance: " + instRightContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstRightContext : instance.listRightContext()) {
            log.debug((Object)("    -> instance: " + iinstRightContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countRightContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeRightContext(instRightContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllRightContext();
        log.info((Object)"  Testing property leftContext of class Word");
        log.debug((Object)"    Any property leftContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsLeftContext()));
        log.debug((Object)"    Adding property instance");
        instance.addLeftContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLeftContext = instance.iterateLeftContext();
        java.lang.String instLeftContext = null;
        while (itLeftContext.hasNext()) {
            instLeftContext = itLeftContext.next();
            log.debug((Object)("    -> instance: " + instLeftContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLeftContext : instance.listLeftContext()) {
            log.debug((Object)("    -> instance: " + iinstLeftContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLeftContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLeftContext(instLeftContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLeftContext();
    }

    protected static void runPhrase(OntModel ontModel) {
        log.info((Object)"Testing class Phrase");
        log.debug((Object)"  Creating anonymous class instance");
        Phrase.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        Phrase.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Phrase.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = Phrase.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        Phrase clsInstance = Phrase.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<Phrase> it = Phrase.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (Phrase cls : Phrase.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<Phrase> it2 = Phrase.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (Phrase cls : Phrase.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + Phrase.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        Phrase.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Phrase.create(uri, ontModel);
        Phrase instance = Phrase.get(uri, ontModel);
        log.info((Object)"  Testing property child of class Phrase");
        log.debug((Object)"    Any property child exist?");
        log.debug((Object)("    -> exists: " + instance.existsChild()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addChild(Thing.create(uri, ontModel));
        instance.addChild(Thing.create(Test.getNewInstanceURI(), ontModel));
        instance.addChild(Thing.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Thing> itChild = instance.iterateChild();
        Thing instChild = null;
        while (itChild.hasNext()) {
            instChild = itChild.next();
            log.debug((Object)("    -> instance: " + instChild.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Thing iinstChild : instance.listChild()) {
            log.debug((Object)("    -> instance: " + iinstChild.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countChild()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeChild(instChild);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllChild();
        log.info((Object)"  Testing property superString of class Phrase");
        log.debug((Object)"    Any property superString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperString(String.create(uri, ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperString = instance.iterateSuperString();
        String instSuperString = null;
        while (itSuperString.hasNext()) {
            instSuperString = itSuperString.next();
            log.debug((Object)("    -> instance: " + instSuperString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperString : instance.listSuperString()) {
            log.debug((Object)("    -> instance: " + iinstSuperString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperString(instSuperString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperString();
        log.info((Object)"  Testing property subString of class Phrase");
        log.debug((Object)"    Any property subString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubString(String.create(uri, ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubString = instance.iterateSubString();
        String instSubString = null;
        while (itSubString.hasNext()) {
            instSubString = itSubString.next();
            log.debug((Object)("    -> instance: " + instSubString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubString : instance.listSubString()) {
            log.debug((Object)("    -> instance: " + iinstSubString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubString(instSubString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubString();
        log.info((Object)"  Testing property superStringTrans of class Phrase");
        log.debug((Object)"    Any property superStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperStringTrans(String.create(uri, ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperStringTrans = instance.iterateSuperStringTrans();
        String instSuperStringTrans = null;
        while (itSuperStringTrans.hasNext()) {
            instSuperStringTrans = itSuperStringTrans.next();
            log.debug((Object)("    -> instance: " + instSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperStringTrans : instance.listSuperStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperStringTrans(instSuperStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperStringTrans();
        log.info((Object)"  Testing property subStringTrans of class Phrase");
        log.debug((Object)"    Any property subStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubStringTrans(String.create(uri, ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubStringTrans = instance.iterateSubStringTrans();
        String instSubStringTrans = null;
        while (itSubStringTrans.hasNext()) {
            instSubStringTrans = itSubStringTrans.next();
            log.debug((Object)("    -> instance: " + instSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubStringTrans : instance.listSubStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubStringTrans(instSubStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubStringTrans();
        log.info((Object)"  Testing property anchorOf of class Phrase");
        log.debug((Object)"    Any property anchorOf exist?");
        log.debug((Object)("    -> exists: " + instance.existsAnchorOf()));
        log.debug((Object)"    Adding property instance");
        instance.setAnchorOf(XsdMapTestData.getString("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getAnchorOf();
        log.debug((Object)"    Removing the property instance");
        instance.removeAnchorOf();
        log.info((Object)"  Testing property endIndex of class Phrase");
        log.debug((Object)"    Any property endIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsEndIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addEndIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itEndIndex = instance.iterateEndIndex();
        java.lang.String instEndIndex = null;
        while (itEndIndex.hasNext()) {
            instEndIndex = itEndIndex.next();
            log.debug((Object)("    -> instance: " + instEndIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstEndIndex : instance.listEndIndex()) {
            log.debug((Object)("    -> instance: " + iinstEndIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countEndIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeEndIndex(instEndIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllEndIndex();
        log.info((Object)"  Testing property beginIndex of class Phrase");
        log.debug((Object)"    Any property beginIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsBeginIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addBeginIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itBeginIndex = instance.iterateBeginIndex();
        java.lang.String instBeginIndex = null;
        while (itBeginIndex.hasNext()) {
            instBeginIndex = itBeginIndex.next();
            log.debug((Object)("    -> instance: " + instBeginIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstBeginIndex : instance.listBeginIndex()) {
            log.debug((Object)("    -> instance: " + iinstBeginIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countBeginIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeBeginIndex(instBeginIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllBeginIndex();
        log.info((Object)"  Testing property rightContext of class Phrase");
        log.debug((Object)"    Any property rightContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsRightContext()));
        log.debug((Object)"    Adding property instance");
        instance.addRightContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itRightContext = instance.iterateRightContext();
        java.lang.String instRightContext = null;
        while (itRightContext.hasNext()) {
            instRightContext = itRightContext.next();
            log.debug((Object)("    -> instance: " + instRightContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstRightContext : instance.listRightContext()) {
            log.debug((Object)("    -> instance: " + iinstRightContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countRightContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeRightContext(instRightContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllRightContext();
        log.info((Object)"  Testing property leftContext of class Phrase");
        log.debug((Object)"    Any property leftContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsLeftContext()));
        log.debug((Object)"    Adding property instance");
        instance.addLeftContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLeftContext = instance.iterateLeftContext();
        java.lang.String instLeftContext = null;
        while (itLeftContext.hasNext()) {
            instLeftContext = itLeftContext.next();
            log.debug((Object)("    -> instance: " + instLeftContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLeftContext : instance.listLeftContext()) {
            log.debug((Object)("    -> instance: " + iinstLeftContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLeftContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLeftContext(instLeftContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLeftContext();
    }

    protected static void runOffsetBasedString(OntModel ontModel) {
        log.info((Object)"Testing class OffsetBasedString");
        log.debug((Object)"  Creating anonymous class instance");
        OffsetBasedString.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        OffsetBasedString.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        OffsetBasedString.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = OffsetBasedString.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        OffsetBasedString clsInstance = OffsetBasedString.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<OffsetBasedString> it = OffsetBasedString.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (OffsetBasedString cls : OffsetBasedString.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<OffsetBasedString> it2 = OffsetBasedString.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (OffsetBasedString cls : OffsetBasedString.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + OffsetBasedString.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        OffsetBasedString.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        OffsetBasedString.create(uri, ontModel);
        OffsetBasedString instance = OffsetBasedString.get(uri, ontModel);
        log.info((Object)"  Testing property superString of class OffsetBasedString");
        log.debug((Object)"    Any property superString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperString(String.create(uri, ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperString = instance.iterateSuperString();
        String instSuperString = null;
        while (itSuperString.hasNext()) {
            instSuperString = itSuperString.next();
            log.debug((Object)("    -> instance: " + instSuperString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperString : instance.listSuperString()) {
            log.debug((Object)("    -> instance: " + iinstSuperString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperString(instSuperString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperString();
        log.info((Object)"  Testing property subString of class OffsetBasedString");
        log.debug((Object)"    Any property subString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubString(String.create(uri, ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubString = instance.iterateSubString();
        String instSubString = null;
        while (itSubString.hasNext()) {
            instSubString = itSubString.next();
            log.debug((Object)("    -> instance: " + instSubString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubString : instance.listSubString()) {
            log.debug((Object)("    -> instance: " + iinstSubString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubString(instSubString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubString();
        log.info((Object)"  Testing property superStringTrans of class OffsetBasedString");
        log.debug((Object)"    Any property superStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperStringTrans(String.create(uri, ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperStringTrans = instance.iterateSuperStringTrans();
        String instSuperStringTrans = null;
        while (itSuperStringTrans.hasNext()) {
            instSuperStringTrans = itSuperStringTrans.next();
            log.debug((Object)("    -> instance: " + instSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperStringTrans : instance.listSuperStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperStringTrans(instSuperStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperStringTrans();
        log.info((Object)"  Testing property subStringTrans of class OffsetBasedString");
        log.debug((Object)"    Any property subStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubStringTrans(String.create(uri, ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubStringTrans = instance.iterateSubStringTrans();
        String instSubStringTrans = null;
        while (itSubStringTrans.hasNext()) {
            instSubStringTrans = itSubStringTrans.next();
            log.debug((Object)("    -> instance: " + instSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubStringTrans : instance.listSubStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubStringTrans(instSubStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubStringTrans();
        log.info((Object)"  Testing property anchorOf of class OffsetBasedString");
        log.debug((Object)"    Any property anchorOf exist?");
        log.debug((Object)("    -> exists: " + instance.existsAnchorOf()));
        log.debug((Object)"    Adding property instance");
        instance.setAnchorOf(XsdMapTestData.getString("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getAnchorOf();
        log.debug((Object)"    Removing the property instance");
        instance.removeAnchorOf();
        log.info((Object)"  Testing property endIndex of class OffsetBasedString");
        log.debug((Object)"    Any property endIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsEndIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addEndIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itEndIndex = instance.iterateEndIndex();
        java.lang.String instEndIndex = null;
        while (itEndIndex.hasNext()) {
            instEndIndex = itEndIndex.next();
            log.debug((Object)("    -> instance: " + instEndIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstEndIndex : instance.listEndIndex()) {
            log.debug((Object)("    -> instance: " + iinstEndIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countEndIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeEndIndex(instEndIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllEndIndex();
        log.info((Object)"  Testing property beginIndex of class OffsetBasedString");
        log.debug((Object)"    Any property beginIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsBeginIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addBeginIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itBeginIndex = instance.iterateBeginIndex();
        java.lang.String instBeginIndex = null;
        while (itBeginIndex.hasNext()) {
            instBeginIndex = itBeginIndex.next();
            log.debug((Object)("    -> instance: " + instBeginIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstBeginIndex : instance.listBeginIndex()) {
            log.debug((Object)("    -> instance: " + iinstBeginIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countBeginIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeBeginIndex(instBeginIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllBeginIndex();
        log.info((Object)"  Testing property rightContext of class OffsetBasedString");
        log.debug((Object)"    Any property rightContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsRightContext()));
        log.debug((Object)"    Adding property instance");
        instance.addRightContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itRightContext = instance.iterateRightContext();
        java.lang.String instRightContext = null;
        while (itRightContext.hasNext()) {
            instRightContext = itRightContext.next();
            log.debug((Object)("    -> instance: " + instRightContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstRightContext : instance.listRightContext()) {
            log.debug((Object)("    -> instance: " + iinstRightContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countRightContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeRightContext(instRightContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllRightContext();
        log.info((Object)"  Testing property leftContext of class OffsetBasedString");
        log.debug((Object)"    Any property leftContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsLeftContext()));
        log.debug((Object)"    Adding property instance");
        instance.addLeftContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLeftContext = instance.iterateLeftContext();
        java.lang.String instLeftContext = null;
        while (itLeftContext.hasNext()) {
            instLeftContext = itLeftContext.next();
            log.debug((Object)("    -> instance: " + instLeftContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLeftContext : instance.listLeftContext()) {
            log.debug((Object)("    -> instance: " + iinstLeftContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLeftContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLeftContext(instLeftContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLeftContext();
    }

    protected static void runDocument(OntModel ontModel) {
        log.info((Object)"Testing class Document");
        log.debug((Object)"  Creating anonymous class instance");
        Document.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        Document.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Document.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = Document.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        Document clsInstance = Document.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<Document> it = Document.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (Document cls : Document.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<Document> it2 = Document.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (Document cls : Document.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + Document.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        Document.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Document.create(uri, ontModel);
        Document instance = Document.get(uri, ontModel);
        log.info((Object)"  Testing property sourceUrl of class Document");
        log.debug((Object)"    Any property sourceUrl exist?");
        log.debug((Object)("    -> exists: " + instance.existsSourceUrl()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setSourceUrl(Thing.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getSourceUrl();
        log.debug((Object)"    Removing the property instance");
        instance.removeSourceUrl();
        log.info((Object)"  Testing property topic of class Document");
        log.debug((Object)"    Any property topic exist?");
        log.debug((Object)("    -> exists: " + instance.existsTopic()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addTopic(Topic.create(uri, ontModel));
        instance.addTopic(Topic.create(Test.getNewInstanceURI(), ontModel));
        instance.addTopic(Topic.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Topic> itTopic = instance.iterateTopic();
        Topic instTopic = null;
        while (itTopic.hasNext()) {
            instTopic = itTopic.next();
            log.debug((Object)("    -> instance: " + instTopic.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Topic iinstTopic : instance.listTopic()) {
            log.debug((Object)("    -> instance: " + iinstTopic.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countTopic()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeTopic(instTopic);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllTopic();
        log.info((Object)"  Testing property dominatingTopic of class Document");
        log.debug((Object)"    Any property dominatingTopic exist?");
        log.debug((Object)("    -> exists: " + instance.existsDominatingTopic()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setDominatingTopic(Topic.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getDominatingTopic();
        log.debug((Object)"    Removing the property instance");
        instance.removeDominatingTopic();
        log.info((Object)"  Testing property sourceString of class Document");
        log.debug((Object)"    Any property sourceString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSourceString()));
        log.debug((Object)"    Adding property instance");
        instance.setSourceString(XsdMapTestData.getString("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getSourceString();
        log.debug((Object)"    Removing the property instance");
        instance.removeSourceString();
        log.info((Object)"  Testing property superString of class Document");
        log.debug((Object)"    Any property superString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperString(String.create(uri, ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperString = instance.iterateSuperString();
        String instSuperString = null;
        while (itSuperString.hasNext()) {
            instSuperString = itSuperString.next();
            log.debug((Object)("    -> instance: " + instSuperString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperString : instance.listSuperString()) {
            log.debug((Object)("    -> instance: " + iinstSuperString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperString(instSuperString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperString();
        log.info((Object)"  Testing property subString of class Document");
        log.debug((Object)"    Any property subString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubString(String.create(uri, ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubString = instance.iterateSubString();
        String instSubString = null;
        while (itSubString.hasNext()) {
            instSubString = itSubString.next();
            log.debug((Object)("    -> instance: " + instSubString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubString : instance.listSubString()) {
            log.debug((Object)("    -> instance: " + iinstSubString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubString(instSubString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubString();
        log.info((Object)"  Testing property superStringTrans of class Document");
        log.debug((Object)"    Any property superStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperStringTrans(String.create(uri, ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperStringTrans = instance.iterateSuperStringTrans();
        String instSuperStringTrans = null;
        while (itSuperStringTrans.hasNext()) {
            instSuperStringTrans = itSuperStringTrans.next();
            log.debug((Object)("    -> instance: " + instSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperStringTrans : instance.listSuperStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperStringTrans(instSuperStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperStringTrans();
        log.info((Object)"  Testing property subStringTrans of class Document");
        log.debug((Object)"    Any property subStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubStringTrans(String.create(uri, ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubStringTrans = instance.iterateSubStringTrans();
        String instSubStringTrans = null;
        while (itSubStringTrans.hasNext()) {
            instSubStringTrans = itSubStringTrans.next();
            log.debug((Object)("    -> instance: " + instSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubStringTrans : instance.listSubStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubStringTrans(instSubStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubStringTrans();
        log.info((Object)"  Testing property anchorOf of class Document");
        log.debug((Object)"    Any property anchorOf exist?");
        log.debug((Object)("    -> exists: " + instance.existsAnchorOf()));
        log.debug((Object)"    Adding property instance");
        instance.setAnchorOf(XsdMapTestData.getString("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getAnchorOf();
        log.debug((Object)"    Removing the property instance");
        instance.removeAnchorOf();
        log.info((Object)"  Testing property endIndex of class Document");
        log.debug((Object)"    Any property endIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsEndIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addEndIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itEndIndex = instance.iterateEndIndex();
        java.lang.String instEndIndex = null;
        while (itEndIndex.hasNext()) {
            instEndIndex = itEndIndex.next();
            log.debug((Object)("    -> instance: " + instEndIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstEndIndex : instance.listEndIndex()) {
            log.debug((Object)("    -> instance: " + iinstEndIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countEndIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeEndIndex(instEndIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllEndIndex();
        log.info((Object)"  Testing property beginIndex of class Document");
        log.debug((Object)"    Any property beginIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsBeginIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addBeginIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itBeginIndex = instance.iterateBeginIndex();
        java.lang.String instBeginIndex = null;
        while (itBeginIndex.hasNext()) {
            instBeginIndex = itBeginIndex.next();
            log.debug((Object)("    -> instance: " + instBeginIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstBeginIndex : instance.listBeginIndex()) {
            log.debug((Object)("    -> instance: " + iinstBeginIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countBeginIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeBeginIndex(instBeginIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllBeginIndex();
        log.info((Object)"  Testing property rightContext of class Document");
        log.debug((Object)"    Any property rightContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsRightContext()));
        log.debug((Object)"    Adding property instance");
        instance.addRightContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itRightContext = instance.iterateRightContext();
        java.lang.String instRightContext = null;
        while (itRightContext.hasNext()) {
            instRightContext = itRightContext.next();
            log.debug((Object)("    -> instance: " + instRightContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstRightContext : instance.listRightContext()) {
            log.debug((Object)("    -> instance: " + iinstRightContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countRightContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeRightContext(instRightContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllRightContext();
        log.info((Object)"  Testing property leftContext of class Document");
        log.debug((Object)"    Any property leftContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsLeftContext()));
        log.debug((Object)"    Adding property instance");
        instance.addLeftContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLeftContext = instance.iterateLeftContext();
        java.lang.String instLeftContext = null;
        while (itLeftContext.hasNext()) {
            instLeftContext = itLeftContext.next();
            log.debug((Object)("    -> instance: " + instLeftContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLeftContext : instance.listLeftContext()) {
            log.debug((Object)("    -> instance: " + iinstLeftContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLeftContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLeftContext(instLeftContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLeftContext();
    }

    protected static void runSentence(OntModel ontModel) {
        log.info((Object)"Testing class Sentence");
        log.debug((Object)"  Creating anonymous class instance");
        Sentence.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        Sentence.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Sentence.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = Sentence.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        Sentence clsInstance = Sentence.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<Sentence> it = Sentence.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (Sentence cls : Sentence.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<Sentence> it2 = Sentence.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (Sentence cls : Sentence.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + Sentence.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        Sentence.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Sentence.create(uri, ontModel);
        Sentence instance = Sentence.get(uri, ontModel);
        log.info((Object)"  Testing property previousSentence of class Sentence");
        log.debug((Object)"    Any property previousSentence exist?");
        log.debug((Object)("    -> exists: " + instance.existsPreviousSentence()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setPreviousSentence(Sentence.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getPreviousSentence();
        log.debug((Object)"    Removing the property instance");
        instance.removePreviousSentence();
        log.info((Object)"  Testing property nextSentence of class Sentence");
        log.debug((Object)"    Any property nextSentence exist?");
        log.debug((Object)("    -> exists: " + instance.existsNextSentence()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setNextSentence(Sentence.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getNextSentence();
        log.debug((Object)"    Removing the property instance");
        instance.removeNextSentence();
        log.info((Object)"  Testing property word of class Sentence");
        log.debug((Object)"    Any property word exist?");
        log.debug((Object)("    -> exists: " + instance.existsWord()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addWord(Word.create(uri, ontModel));
        instance.addWord(Word.create(Test.getNewInstanceURI(), ontModel));
        instance.addWord(Word.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Word> itWord = instance.iterateWord();
        Word instWord = null;
        while (itWord.hasNext()) {
            instWord = itWord.next();
            log.debug((Object)("    -> instance: " + instWord.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Word iinstWord : instance.listWord()) {
            log.debug((Object)("    -> instance: " + iinstWord.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countWord()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeWord(instWord);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllWord();
        log.info((Object)"  Testing property firstWord of class Sentence");
        log.debug((Object)"    Any property firstWord exist?");
        log.debug((Object)("    -> exists: " + instance.existsFirstWord()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setFirstWord(Word.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getFirstWord();
        log.debug((Object)"    Removing the property instance");
        instance.removeFirstWord();
        log.info((Object)"  Testing property lastWord of class Sentence");
        log.debug((Object)"    Any property lastWord exist?");
        log.debug((Object)("    -> exists: " + instance.existsLastWord()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.setLastWord(Word.create(uri, ontModel));
        log.debug((Object)"    Getting property instances");
        instance.getLastWord();
        log.debug((Object)"    Removing the property instance");
        instance.removeLastWord();
        log.info((Object)"  Testing property previousSentenceTrans of class Sentence");
        log.debug((Object)"    Any property previousSentenceTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsPreviousSentenceTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addPreviousSentenceTrans(Sentence.create(uri, ontModel));
        instance.addPreviousSentenceTrans(Sentence.create(Test.getNewInstanceURI(), ontModel));
        instance.addPreviousSentenceTrans(Sentence.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Sentence> itPreviousSentenceTrans = instance.iteratePreviousSentenceTrans();
        Sentence instPreviousSentenceTrans = null;
        while (itPreviousSentenceTrans.hasNext()) {
            instPreviousSentenceTrans = itPreviousSentenceTrans.next();
            log.debug((Object)("    -> instance: " + instPreviousSentenceTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Sentence iinstPreviousSentenceTrans : instance.listPreviousSentenceTrans()) {
            log.debug((Object)("    -> instance: " + iinstPreviousSentenceTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countPreviousSentenceTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removePreviousSentenceTrans(instPreviousSentenceTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllPreviousSentenceTrans();
        log.info((Object)"  Testing property superString of class Sentence");
        log.debug((Object)"    Any property superString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperString(String.create(uri, ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperString = instance.iterateSuperString();
        String instSuperString = null;
        while (itSuperString.hasNext()) {
            instSuperString = itSuperString.next();
            log.debug((Object)("    -> instance: " + instSuperString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperString : instance.listSuperString()) {
            log.debug((Object)("    -> instance: " + iinstSuperString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperString(instSuperString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperString();
        log.info((Object)"  Testing property subString of class Sentence");
        log.debug((Object)"    Any property subString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubString(String.create(uri, ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubString = instance.iterateSubString();
        String instSubString = null;
        while (itSubString.hasNext()) {
            instSubString = itSubString.next();
            log.debug((Object)("    -> instance: " + instSubString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubString : instance.listSubString()) {
            log.debug((Object)("    -> instance: " + iinstSubString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubString(instSubString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubString();
        log.info((Object)"  Testing property superStringTrans of class Sentence");
        log.debug((Object)"    Any property superStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperStringTrans(String.create(uri, ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperStringTrans = instance.iterateSuperStringTrans();
        String instSuperStringTrans = null;
        while (itSuperStringTrans.hasNext()) {
            instSuperStringTrans = itSuperStringTrans.next();
            log.debug((Object)("    -> instance: " + instSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperStringTrans : instance.listSuperStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperStringTrans(instSuperStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperStringTrans();
        log.info((Object)"  Testing property subStringTrans of class Sentence");
        log.debug((Object)"    Any property subStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubStringTrans(String.create(uri, ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubStringTrans = instance.iterateSubStringTrans();
        String instSubStringTrans = null;
        while (itSubStringTrans.hasNext()) {
            instSubStringTrans = itSubStringTrans.next();
            log.debug((Object)("    -> instance: " + instSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubStringTrans : instance.listSubStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubStringTrans(instSubStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubStringTrans();
        log.info((Object)"  Testing property anchorOf of class Sentence");
        log.debug((Object)"    Any property anchorOf exist?");
        log.debug((Object)("    -> exists: " + instance.existsAnchorOf()));
        log.debug((Object)"    Adding property instance");
        instance.setAnchorOf(XsdMapTestData.getString("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getAnchorOf();
        log.debug((Object)"    Removing the property instance");
        instance.removeAnchorOf();
        log.info((Object)"  Testing property endIndex of class Sentence");
        log.debug((Object)"    Any property endIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsEndIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addEndIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itEndIndex = instance.iterateEndIndex();
        java.lang.String instEndIndex = null;
        while (itEndIndex.hasNext()) {
            instEndIndex = itEndIndex.next();
            log.debug((Object)("    -> instance: " + instEndIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstEndIndex : instance.listEndIndex()) {
            log.debug((Object)("    -> instance: " + iinstEndIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countEndIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeEndIndex(instEndIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllEndIndex();
        log.info((Object)"  Testing property beginIndex of class Sentence");
        log.debug((Object)"    Any property beginIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsBeginIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addBeginIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itBeginIndex = instance.iterateBeginIndex();
        java.lang.String instBeginIndex = null;
        while (itBeginIndex.hasNext()) {
            instBeginIndex = itBeginIndex.next();
            log.debug((Object)("    -> instance: " + instBeginIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstBeginIndex : instance.listBeginIndex()) {
            log.debug((Object)("    -> instance: " + iinstBeginIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countBeginIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeBeginIndex(instBeginIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllBeginIndex();
        log.info((Object)"  Testing property rightContext of class Sentence");
        log.debug((Object)"    Any property rightContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsRightContext()));
        log.debug((Object)"    Adding property instance");
        instance.addRightContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itRightContext = instance.iterateRightContext();
        java.lang.String instRightContext = null;
        while (itRightContext.hasNext()) {
            instRightContext = itRightContext.next();
            log.debug((Object)("    -> instance: " + instRightContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstRightContext : instance.listRightContext()) {
            log.debug((Object)("    -> instance: " + iinstRightContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countRightContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeRightContext(instRightContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllRightContext();
        log.info((Object)"  Testing property leftContext of class Sentence");
        log.debug((Object)"    Any property leftContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsLeftContext()));
        log.debug((Object)"    Adding property instance");
        instance.addLeftContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLeftContext = instance.iterateLeftContext();
        java.lang.String instLeftContext = null;
        while (itLeftContext.hasNext()) {
            instLeftContext = itLeftContext.next();
            log.debug((Object)("    -> instance: " + instLeftContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLeftContext : instance.listLeftContext()) {
            log.debug((Object)("    -> instance: " + iinstLeftContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLeftContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLeftContext(instLeftContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLeftContext();
    }

    protected static void runString(OntModel ontModel) {
        log.info((Object)"Testing class String");
        log.debug((Object)"  Creating anonymous class instance");
        String.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        String.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        String.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = String.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        String clsInstance = String.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<String> it = String.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (String cls : String.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<String> it2 = String.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (String cls : String.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + String.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        String.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        String.create(uri, ontModel);
        String instance = String.get(uri, ontModel);
        log.info((Object)"  Testing property superString of class String");
        log.debug((Object)"    Any property superString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperString(String.create(uri, ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperString = instance.iterateSuperString();
        String instSuperString = null;
        while (itSuperString.hasNext()) {
            instSuperString = itSuperString.next();
            log.debug((Object)("    -> instance: " + instSuperString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperString : instance.listSuperString()) {
            log.debug((Object)("    -> instance: " + iinstSuperString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperString(instSuperString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperString();
        log.info((Object)"  Testing property subString of class String");
        log.debug((Object)"    Any property subString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubString(String.create(uri, ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubString = instance.iterateSubString();
        String instSubString = null;
        while (itSubString.hasNext()) {
            instSubString = itSubString.next();
            log.debug((Object)("    -> instance: " + instSubString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubString : instance.listSubString()) {
            log.debug((Object)("    -> instance: " + iinstSubString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubString(instSubString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubString();
        log.info((Object)"  Testing property superStringTrans of class String");
        log.debug((Object)"    Any property superStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperStringTrans(String.create(uri, ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperStringTrans = instance.iterateSuperStringTrans();
        String instSuperStringTrans = null;
        while (itSuperStringTrans.hasNext()) {
            instSuperStringTrans = itSuperStringTrans.next();
            log.debug((Object)("    -> instance: " + instSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperStringTrans : instance.listSuperStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperStringTrans(instSuperStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperStringTrans();
        log.info((Object)"  Testing property subStringTrans of class String");
        log.debug((Object)"    Any property subStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubStringTrans(String.create(uri, ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubStringTrans = instance.iterateSubStringTrans();
        String instSubStringTrans = null;
        while (itSubStringTrans.hasNext()) {
            instSubStringTrans = itSubStringTrans.next();
            log.debug((Object)("    -> instance: " + instSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubStringTrans : instance.listSubStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubStringTrans(instSubStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubStringTrans();
        log.info((Object)"  Testing property anchorOf of class String");
        log.debug((Object)"    Any property anchorOf exist?");
        log.debug((Object)("    -> exists: " + instance.existsAnchorOf()));
        log.debug((Object)"    Adding property instance");
        instance.setAnchorOf(XsdMapTestData.getString("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getAnchorOf();
        log.debug((Object)"    Removing the property instance");
        instance.removeAnchorOf();
        log.info((Object)"  Testing property endIndex of class String");
        log.debug((Object)"    Any property endIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsEndIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addEndIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itEndIndex = instance.iterateEndIndex();
        java.lang.String instEndIndex = null;
        while (itEndIndex.hasNext()) {
            instEndIndex = itEndIndex.next();
            log.debug((Object)("    -> instance: " + instEndIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstEndIndex : instance.listEndIndex()) {
            log.debug((Object)("    -> instance: " + iinstEndIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countEndIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeEndIndex(instEndIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllEndIndex();
        log.info((Object)"  Testing property beginIndex of class String");
        log.debug((Object)"    Any property beginIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsBeginIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addBeginIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itBeginIndex = instance.iterateBeginIndex();
        java.lang.String instBeginIndex = null;
        while (itBeginIndex.hasNext()) {
            instBeginIndex = itBeginIndex.next();
            log.debug((Object)("    -> instance: " + instBeginIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstBeginIndex : instance.listBeginIndex()) {
            log.debug((Object)("    -> instance: " + iinstBeginIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countBeginIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeBeginIndex(instBeginIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllBeginIndex();
        log.info((Object)"  Testing property rightContext of class String");
        log.debug((Object)"    Any property rightContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsRightContext()));
        log.debug((Object)"    Adding property instance");
        instance.addRightContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itRightContext = instance.iterateRightContext();
        java.lang.String instRightContext = null;
        while (itRightContext.hasNext()) {
            instRightContext = itRightContext.next();
            log.debug((Object)("    -> instance: " + instRightContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstRightContext : instance.listRightContext()) {
            log.debug((Object)("    -> instance: " + iinstRightContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countRightContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeRightContext(instRightContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllRightContext();
        log.info((Object)"  Testing property leftContext of class String");
        log.debug((Object)"    Any property leftContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsLeftContext()));
        log.debug((Object)"    Adding property instance");
        instance.addLeftContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLeftContext = instance.iterateLeftContext();
        java.lang.String instLeftContext = null;
        while (itLeftContext.hasNext()) {
            instLeftContext = itLeftContext.next();
            log.debug((Object)("    -> instance: " + instLeftContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLeftContext : instance.listLeftContext()) {
            log.debug((Object)("    -> instance: " + iinstLeftContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLeftContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLeftContext(instLeftContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLeftContext();
    }

    protected static void runTopic(OntModel ontModel) {
        log.info((Object)"Testing class Topic");
        log.debug((Object)"  Creating anonymous class instance");
        Topic.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        Topic.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Topic.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = Topic.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        Topic clsInstance = Topic.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<Topic> it = Topic.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (Topic cls : Topic.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<Topic> it2 = Topic.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (Topic cls : Topic.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + Topic.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        Topic.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        Topic.create(uri, ontModel);
        Topic instance = Topic.get(uri, ontModel);
        log.info((Object)"  Testing property occursIn of class Topic");
        log.debug((Object)"    Any property occursIn exist?");
        log.debug((Object)("    -> exists: " + instance.existsOccursIn()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addOccursIn(Document.create(uri, ontModel));
        instance.addOccursIn(Document.create(Test.getNewInstanceURI(), ontModel));
        instance.addOccursIn(Document.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<Document> itOccursIn = instance.iterateOccursIn();
        Document instOccursIn = null;
        while (itOccursIn.hasNext()) {
            instOccursIn = itOccursIn.next();
            log.debug((Object)("    -> instance: " + instOccursIn.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (Document iinstOccursIn : instance.listOccursIn()) {
            log.debug((Object)("    -> instance: " + iinstOccursIn.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countOccursIn()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeOccursIn(instOccursIn);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllOccursIn();
        log.info((Object)"  Testing property characterticLemma of class Topic");
        log.debug((Object)"    Any property characterticLemma exist?");
        log.debug((Object)("    -> exists: " + instance.existsCharacterticLemma()));
        log.debug((Object)"    Adding property instance");
        instance.addCharacterticLemma(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itCharacterticLemma = instance.iterateCharacterticLemma();
        java.lang.String instCharacterticLemma = null;
        while (itCharacterticLemma.hasNext()) {
            instCharacterticLemma = itCharacterticLemma.next();
            log.debug((Object)("    -> instance: " + instCharacterticLemma));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstCharacterticLemma : instance.listCharacterticLemma()) {
            log.debug((Object)("    -> instance: " + iinstCharacterticLemma));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countCharacterticLemma()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeCharacterticLemma(instCharacterticLemma);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllCharacterticLemma();
    }

    protected static void runContextHashBasedString(OntModel ontModel) {
        log.info((Object)"Testing class ContextHashBasedString");
        log.debug((Object)"  Creating anonymous class instance");
        ContextHashBasedString.create(ontModel);
        log.debug((Object)"  Creating two named class instance");
        java.lang.String uri = Test.getNewInstanceURI();
        ContextHashBasedString.create(uri, ontModel);
        uri = Test.getNewInstanceURI();
        ContextHashBasedString.create(uri, ontModel);
        log.debug((Object)"  Checking for existance of class instance");
        boolean exists = ContextHashBasedString.exists(uri, ontModel);
        log.debug((Object)("  -> exists: " + exists));
        log.debug((Object)"  Fetching known instance");
        ContextHashBasedString clsInstance = ContextHashBasedString.get(uri, ontModel);
        log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        log.debug((Object)"  Iterate over all class instances");
        Iterator<ContextHashBasedString> it = ContextHashBasedString.iterate(ontModel);
        while (it.hasNext()) {
            clsInstance = it.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances and ");
        for (ContextHashBasedString cls : ContextHashBasedString.list(ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Iterate over all class instances and subclass instances");
        Iterator<ContextHashBasedString> it2 = ContextHashBasedString.iterate(false, ontModel);
        while (it2.hasNext()) {
            clsInstance = it2.next();
            log.debug((Object)("  -> instance: " + clsInstance.getLocalName()));
        }
        log.debug((Object)"  List all class instances");
        for (ContextHashBasedString cls : ContextHashBasedString.list(false, ontModel)) {
            log.debug((Object)("  -> instance: " + cls.getLocalName()));
        }
        log.debug((Object)"  Counting class instances");
        log.debug((Object)("  -> count: " + ContextHashBasedString.count(ontModel)));
        log.debug((Object)"  Deleting a named class instance");
        ContextHashBasedString.delete(uri, ontModel);
        uri = Test.getNewInstanceURI();
        ContextHashBasedString.create(uri, ontModel);
        ContextHashBasedString instance = ContextHashBasedString.get(uri, ontModel);
        log.info((Object)"  Testing property superString of class ContextHashBasedString");
        log.debug((Object)"    Any property superString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperString(String.create(uri, ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperString = instance.iterateSuperString();
        String instSuperString = null;
        while (itSuperString.hasNext()) {
            instSuperString = itSuperString.next();
            log.debug((Object)("    -> instance: " + instSuperString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperString : instance.listSuperString()) {
            log.debug((Object)("    -> instance: " + iinstSuperString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperString(instSuperString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperString();
        log.info((Object)"  Testing property subString of class ContextHashBasedString");
        log.debug((Object)"    Any property subString exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubString()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubString(String.create(uri, ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubString(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubString = instance.iterateSubString();
        String instSubString = null;
        while (itSubString.hasNext()) {
            instSubString = itSubString.next();
            log.debug((Object)("    -> instance: " + instSubString.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubString : instance.listSubString()) {
            log.debug((Object)("    -> instance: " + iinstSubString.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubString()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubString(instSubString);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubString();
        log.info((Object)"  Testing property superStringTrans of class ContextHashBasedString");
        log.debug((Object)"    Any property superStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSuperStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSuperStringTrans(String.create(uri, ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSuperStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSuperStringTrans = instance.iterateSuperStringTrans();
        String instSuperStringTrans = null;
        while (itSuperStringTrans.hasNext()) {
            instSuperStringTrans = itSuperStringTrans.next();
            log.debug((Object)("    -> instance: " + instSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSuperStringTrans : instance.listSuperStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSuperStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSuperStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSuperStringTrans(instSuperStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSuperStringTrans();
        log.info((Object)"  Testing property subStringTrans of class ContextHashBasedString");
        log.debug((Object)"    Any property subStringTrans exist?");
        log.debug((Object)("    -> exists: " + instance.existsSubStringTrans()));
        log.debug((Object)"    Adding property instance");
        uri = Test.getNewInstanceURI();
        instance.addSubStringTrans(String.create(uri, ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        instance.addSubStringTrans(String.create(Test.getNewInstanceURI(), ontModel));
        log.debug((Object)"    Iterate over all property instances");
        Iterator<String> itSubStringTrans = instance.iterateSubStringTrans();
        String instSubStringTrans = null;
        while (itSubStringTrans.hasNext()) {
            instSubStringTrans = itSubStringTrans.next();
            log.debug((Object)("    -> instance: " + instSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    List all property values");
        for (String iinstSubStringTrans : instance.listSubStringTrans()) {
            log.debug((Object)("    -> instance: " + iinstSubStringTrans.getLocalName()));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countSubStringTrans()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeSubStringTrans(instSubStringTrans);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllSubStringTrans();
        log.info((Object)"  Testing property anchorOf of class ContextHashBasedString");
        log.debug((Object)"    Any property anchorOf exist?");
        log.debug((Object)("    -> exists: " + instance.existsAnchorOf()));
        log.debug((Object)"    Adding property instance");
        instance.setAnchorOf(XsdMapTestData.getString("$rangeeUri"));
        log.debug((Object)"    Getting property instances");
        instance.getAnchorOf();
        log.debug((Object)"    Removing the property instance");
        instance.removeAnchorOf();
        log.info((Object)"  Testing property endIndex of class ContextHashBasedString");
        log.debug((Object)"    Any property endIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsEndIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addEndIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itEndIndex = instance.iterateEndIndex();
        java.lang.String instEndIndex = null;
        while (itEndIndex.hasNext()) {
            instEndIndex = itEndIndex.next();
            log.debug((Object)("    -> instance: " + instEndIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstEndIndex : instance.listEndIndex()) {
            log.debug((Object)("    -> instance: " + iinstEndIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countEndIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeEndIndex(instEndIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllEndIndex();
        log.info((Object)"  Testing property beginIndex of class ContextHashBasedString");
        log.debug((Object)"    Any property beginIndex exist?");
        log.debug((Object)("    -> exists: " + instance.existsBeginIndex()));
        log.debug((Object)"    Adding property instance");
        instance.addBeginIndex(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itBeginIndex = instance.iterateBeginIndex();
        java.lang.String instBeginIndex = null;
        while (itBeginIndex.hasNext()) {
            instBeginIndex = itBeginIndex.next();
            log.debug((Object)("    -> instance: " + instBeginIndex));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstBeginIndex : instance.listBeginIndex()) {
            log.debug((Object)("    -> instance: " + iinstBeginIndex));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countBeginIndex()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeBeginIndex(instBeginIndex);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllBeginIndex();
        log.info((Object)"  Testing property rightContext of class ContextHashBasedString");
        log.debug((Object)"    Any property rightContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsRightContext()));
        log.debug((Object)"    Adding property instance");
        instance.addRightContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itRightContext = instance.iterateRightContext();
        java.lang.String instRightContext = null;
        while (itRightContext.hasNext()) {
            instRightContext = itRightContext.next();
            log.debug((Object)("    -> instance: " + instRightContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstRightContext : instance.listRightContext()) {
            log.debug((Object)("    -> instance: " + iinstRightContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countRightContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeRightContext(instRightContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllRightContext();
        log.info((Object)"  Testing property leftContext of class ContextHashBasedString");
        log.debug((Object)"    Any property leftContext exist?");
        log.debug((Object)("    -> exists: " + instance.existsLeftContext()));
        log.debug((Object)"    Adding property instance");
        instance.addLeftContext(XsdMapTestData.getString("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
        log.debug((Object)"    Iterate over all property values");
        Iterator<java.lang.String> itLeftContext = instance.iterateLeftContext();
        java.lang.String instLeftContext = null;
        while (itLeftContext.hasNext()) {
            instLeftContext = itLeftContext.next();
            log.debug((Object)("    -> instance: " + instLeftContext));
        }
        log.debug((Object)"    List all property values");
        for (java.lang.String iinstLeftContext : instance.listLeftContext()) {
            log.debug((Object)("    -> instance: " + iinstLeftContext));
        }
        log.debug((Object)"    Count property values");
        log.debug((Object)("    -> count: " + instance.countLeftContext()));
        log.debug((Object)"    Removing a known property instance");
        instance.removeLeftContext(instLeftContext);
        log.debug((Object)"    Removing all property instances");
        instance.removeAllLeftContext();
    }
}

