/*
 * Decompiled with CFR 0.152.
 */
package eu.lod2.nlp2rdf.schema.tools;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import eu.lod2.nlp2rdf.schema.Thing;
import eu.lod2.nlp2rdf.schema.error.Error;
import eu.lod2.nlp2rdf.schema.sso.Phrase;
import eu.lod2.nlp2rdf.schema.sso.Sentence;
import eu.lod2.nlp2rdf.schema.sso.StopWord;
import eu.lod2.nlp2rdf.schema.sso.Word;
import eu.lod2.nlp2rdf.schema.str.ContextHashBasedString;
import eu.lod2.nlp2rdf.schema.str.Document;
import eu.lod2.nlp2rdf.schema.str.OffsetBasedString;
import eu.lod2.nlp2rdf.schema.str.String;
import eu.lod2.nlp2rdf.schema.topic.Topic;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Factory {
    private static Log log = LogFactory.getLog(Factory.class);
    private static OntModel defaultModel = null;
    private static Map<java.lang.String, java.lang.String> uri2Type = new HashMap<java.lang.String, java.lang.String>();

    public static void setDefaultModel(OntModel defaultModel) {
        Factory.defaultModel = defaultModel;
    }

    public static OntModel getDefaultModel() {
        if (defaultModel == null) {
            throw new RuntimeException("No default OntModel was provided to eu.lod2.nlp2rdf.schema.tools.Factory");
        }
        return defaultModel;
    }

    public static java.lang.String getJavaInterfaceName(java.lang.String uri) {
        return uri2Type.get(uri);
    }

    public static boolean hasJavaType(java.lang.String uri) {
        return uri2Type.containsKey(uri);
    }

    public static boolean deleteInstance(java.lang.String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        if (individual != null) {
            individual.remove();
            return true;
        }
        log.warn((Object)("Could not remove non existing instance " + uri + " from model"));
        return false;
    }

    public static boolean deleteInstance(java.lang.String uri) {
        return Factory.deleteInstance(uri, Factory.getDefaultModel());
    }

    public static void registerCustomClasses() {
        log.info((Object)"Registering custom classes with jena");
        Thing.register();
        StopWord.register();
        Error.register();
        Word.register();
        Phrase.register();
        OffsetBasedString.register();
        Document.register();
        Sentence.register();
        String.register();
        Topic.register();
        ContextHashBasedString.register();
    }

    public static void registerImports(Ontology ontology, OntModel ontModel) {
        log.info((Object)"Adding import statements to the model");
        OntDocumentManager odm = OntDocumentManager.getInstance();
        log.debug((Object)"Adding import http://nlp2rdf.lod2.eu/schema/string/ to the model");
        odm.loadImport(ontModel, "http://nlp2rdf.lod2.eu/schema/string/");
        ontology.addImport(ontModel.createResource("http://nlp2rdf.lod2.eu/schema/string/"));
        log.debug((Object)"Adding import file:/home/sebastian/svn/idea/nlp2rdf/ontologies/sso/sso-v1.0.ttl to the model");
        odm.loadImport(ontModel, "file:/home/sebastian/svn/idea/nlp2rdf/ontologies/sso/sso-v1.0.ttl");
        ontology.addImport(ontModel.createResource("file:/home/sebastian/svn/idea/nlp2rdf/ontologies/sso/sso-v1.0.ttl"));
        log.debug((Object)"Adding import http://nlp2rdf.lod2.eu/schema/error/ to the model");
        odm.loadImport(ontModel, "http://nlp2rdf.lod2.eu/schema/error/");
        ontology.addImport(ontModel.createResource("http://nlp2rdf.lod2.eu/schema/error/"));
        log.debug((Object)"Adding import http://nlp2rdf.lod2.eu/schema/sso/ to the model");
        odm.loadImport(ontModel, "http://nlp2rdf.lod2.eu/schema/sso/");
        ontology.addImport(ontModel.createResource("http://nlp2rdf.lod2.eu/schema/sso/"));
        log.debug((Object)"Adding import file:/home/sebastian/svn/idea/nlp2rdf/ontologies/topic/topic-v0.8.ttl to the model");
        odm.loadImport(ontModel, "file:/home/sebastian/svn/idea/nlp2rdf/ontologies/topic/topic-v0.8.ttl");
        ontology.addImport(ontModel.createResource("file:/home/sebastian/svn/idea/nlp2rdf/ontologies/topic/topic-v0.8.ttl"));
        log.debug((Object)"Adding import file:/home/sebastian/svn/idea/nlp2rdf/ontologies/string/string-v1.0.ttl to the model");
        odm.loadImport(ontModel, "file:/home/sebastian/svn/idea/nlp2rdf/ontologies/string/string-v1.0.ttl");
        ontology.addImport(ontModel.createResource("file:/home/sebastian/svn/idea/nlp2rdf/ontologies/string/string-v1.0.ttl"));
        log.debug((Object)"Adding import http://nlp2rdf.lod2.eu/schema/topic/ to the model");
        odm.loadImport(ontModel, "http://nlp2rdf.lod2.eu/schema/topic/");
        ontology.addImport(ontModel.createResource("http://nlp2rdf.lod2.eu/schema/topic/"));
        log.debug((Object)"Adding import http://ns.aksw.org/scms/ to the model");
        odm.loadImport(ontModel, "http://ns.aksw.org/scms/");
        ontology.addImport(ontModel.createResource("http://ns.aksw.org/scms/"));
        log.debug((Object)"Adding import http://www.w3.org/XML/1998/namespace to the model");
        odm.loadImport(ontModel, "http://www.w3.org/XML/1998/namespace");
        ontology.addImport(ontModel.createResource("http://www.w3.org/XML/1998/namespace"));
        log.debug((Object)"Adding import file:/home/sebastian/svn/idea/nlp2rdf/ontologies/error/error-v0.1.ttl to the model");
        odm.loadImport(ontModel, "file:/home/sebastian/svn/idea/nlp2rdf/ontologies/error/error-v0.1.ttl");
        ontology.addImport(ontModel.createResource("file:/home/sebastian/svn/idea/nlp2rdf/ontologies/error/error-v0.1.ttl"));
    }

    public void registerImports(Ontology ontology) {
        Factory.registerImports(ontology, Factory.getDefaultModel());
    }

    static {
        uri2Type.put("http://www.w3.org/2002/07/owl#Thing", "eu.lod2.nlp2rdf.schema.IThing");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/sso/StopWord", "eu.lod2.nlp2rdf.schema.sso.IStopWord");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/error/Error", "eu.lod2.nlp2rdf.schema.error.IError");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/sso/Word", "eu.lod2.nlp2rdf.schema.sso.IWord");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/sso/Phrase", "eu.lod2.nlp2rdf.schema.sso.IPhrase");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/string/OffsetBasedString", "eu.lod2.nlp2rdf.schema.str.IOffsetBasedString");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/string/Document", "eu.lod2.nlp2rdf.schema.str.IDocument");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/sso/Sentence", "eu.lod2.nlp2rdf.schema.sso.ISentence");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/string/String", "eu.lod2.nlp2rdf.schema.str.IString");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/topic/Topic", "eu.lod2.nlp2rdf.schema.topic.ITopic");
        uri2Type.put("http://nlp2rdf.lod2.eu/schema/string/ContextHashBasedString", "eu.lod2.nlp2rdf.schema.str.IContextHashBasedString");
    }
}

