/*
 * Decompiled with CFR 0.152.
 */
package eu.lod2.nlp2rdf.schema.str;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.IndividualImpl;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import eu.lod2.nlp2rdf.schema.IThing;
import eu.lod2.nlp2rdf.schema.Thing;
import eu.lod2.nlp2rdf.schema.str.IDocument;
import eu.lod2.nlp2rdf.schema.str.IString;
import eu.lod2.nlp2rdf.schema.str.String;
import eu.lod2.nlp2rdf.schema.tools.Factory;
import eu.lod2.nlp2rdf.schema.tools.Vocabulary;
import eu.lod2.nlp2rdf.schema.topic.ITopic;
import eu.lod2.nlp2rdf.schema.topic.Topic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.tbm.eeni.owl2java.model.jenautils.NullFilter;
import nl.tudelft.tbm.eeni.owl2java.model.xsd.XsdUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Document
extends IndividualImpl
implements IDocument {
    private static Log log = LogFactory.getLog(Document.class);
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new Document(n, eg);
            }
            log.warn((Object)("Cannot convert node " + n.toString() + " to  Document"));
            return null;
        }

        public boolean canWrap(Node n, EnhGraph eg) {
            if (!(eg instanceof OntModel)) {
                return false;
            }
            Profile profile = ((OntModel)eg).getProfile();
            if (!profile.isSupported(n, eg, Individual.class)) {
                return false;
            }
            Graph graph = eg.asGraph();
            return graph.contains(n, RDF.type.asNode(), Vocabulary.Document.asNode());
        }
    };
    public static final Filter<Document> nullFilter = new NullFilter<Document>();
    public static final Map1<Statement, Document> statementMapper = Document.mapperFrom(Statement.class);
    public static final Map1<Individual, Document> individualMapper = Document.mapperFrom(Individual.class);
    public static final Map1<RDFNode, Document> nodeMapper = Document.mapperFrom(RDFNode.class);

    public static <From> Map1<From, Document> mapperFrom(Class<From> from) {
        return new Map1<From, Document>(){

            public Document map1(Object x) {
                if (x instanceof Statement) {
                    Resource r = ((Statement)x).getResource();
                    if (r.canAs(Document.class)) {
                        return (Document)r.as(Document.class);
                    }
                } else if (x instanceof RDFNode && ((RDFNode)x).canAs(Document.class)) {
                    return (Document)((RDFNode)x).as(Document.class);
                }
                return null;
            }
        };
    }

    public Document(Node n, EnhGraph g) {
        super(n, g);
    }

    public static void register() {
        log.debug((Object)"Registering custom class Document with jena");
        BuiltinPersonalities.model.add(Document.class, factory);
        BuiltinPersonalities.model.add(Document.class, factory);
    }

    public static Document get(java.lang.String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return (Document)individual.as(Document.class);
    }

    public static Document get(java.lang.String uri) {
        return Document.get(uri, Factory.getDefaultModel());
    }

    public static Iterator<Document> iterate(OntModel ontModel) {
        ExtendedIterator it = ontModel.listIndividuals((Resource)Vocabulary.Document);
        return it.mapWith(individualMapper).filterDrop(nullFilter);
    }

    public static Iterator<Document> iterate() {
        return Document.iterate(Factory.getDefaultModel());
    }

    public static List<Document> list(OntModel ontModel) {
        ArrayList<Document> list = new ArrayList<Document>();
        Iterator<Document> it = Document.iterate(ontModel);
        while (it.hasNext()) {
            Document cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Document> list() {
        return Document.list(Factory.getDefaultModel());
    }

    public static Iterator<Document> iterate(boolean direct, OntModel ontModel) {
        OntClass cls = ontModel.getOntClass("http://nlp2rdf.lod2.eu/schema/string/Document");
        ExtendedIterator it = cls.listInstances(direct);
        WrappedIterator<RDFNode> nodeIt = new WrappedIterator<RDFNode>((Iterator)it){};
        return nodeIt.mapWith(nodeMapper).filterDrop(nullFilter);
    }

    public static Iterator<Document> iterate(boolean direct) {
        return Document.iterate(direct, Factory.getDefaultModel());
    }

    public static List<Document> list(boolean direct, OntModel ontModel) {
        ArrayList<Document> list = new ArrayList<Document>();
        Iterator<Document> it = Document.iterate(direct, ontModel);
        while (it.hasNext()) {
            Document cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Document> list(boolean direct) {
        return Document.list(direct, Factory.getDefaultModel());
    }

    public static int count(OntModel ontModel) {
        int count = 0;
        Iterator<Document> it = Document.iterate(ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count() {
        return Document.count(Factory.getDefaultModel());
    }

    public static int count(boolean direct, OntModel ontModel) {
        int count = 0;
        Iterator<Document> it = Document.iterate(direct, ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count(boolean direct) {
        return Document.count(direct, Factory.getDefaultModel());
    }

    public static boolean exists(java.lang.String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return individual != null;
    }

    public static boolean exists(java.lang.String uri) {
        return Document.exists(uri, Factory.getDefaultModel());
    }

    public static Document create(java.lang.String uri, OntModel ontModel) {
        return (Document)ontModel.createOntResource(Document.class, (Resource)Vocabulary.Document, uri);
    }

    public static Document create(OntModel ontModel) {
        return Document.create(null, ontModel);
    }

    public static Document create(java.lang.String uri) {
        return Document.create(uri, Factory.getDefaultModel());
    }

    public static Document create() {
        return Document.create(null, Factory.getDefaultModel());
    }

    public static void delete(java.lang.String uri, OntModel ontModel) {
        Factory.deleteInstance(uri, ontModel);
    }

    public static void delete(java.lang.String uri) {
        Factory.deleteInstance(uri);
    }

    @Override
    public boolean existsSourceUrl() {
        return this.hasProperty((Property)Vocabulary.sourceUrl);
    }

    @Override
    public boolean hasSourceUrl(IThing thingValue) {
        return this.hasProperty((Property)Vocabulary.sourceUrl, (RDFNode)thingValue);
    }

    @Override
    public Thing getSourceUrl() {
        RDFNode n = this.getPropertyValue((Property)Vocabulary.sourceUrl);
        if (n.canAs(Thing.class)) {
            return (Thing)n.as(Thing.class);
        }
        log.warn((Object)("Could not convert sourceUrl of " + this.getURI() + " (" + n + ") to type Thing"));
        return null;
    }

    @Override
    public void setSourceUrl(IThing thingValue) {
        this.removeAll((Property)Vocabulary.sourceUrl);
        this.setPropertyValue((Property)Vocabulary.sourceUrl, (RDFNode)thingValue);
    }

    @Override
    public void removeSourceUrl() {
        this.removeAll((Property)Vocabulary.sourceUrl);
    }

    @Override
    public boolean existsTopic() {
        return this.hasProperty((Property)Vocabulary.topic);
    }

    @Override
    public boolean hasTopic(ITopic topicValue) {
        return this.hasProperty((Property)Vocabulary.topic, (RDFNode)topicValue);
    }

    @Override
    public int countTopic() {
        int count = 0;
        Iterator<Topic> it = this.iterateTopic();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Topic> iterateTopic() {
        StmtIterator it = this.listProperties((Property)Vocabulary.topic);
        return it.mapWith(Topic.statementMapper).filterDrop(Topic.nullFilter);
    }

    @Override
    public List<Topic> listTopic() {
        ArrayList<Topic> list = new ArrayList<Topic>();
        Iterator<Topic> it = this.iterateTopic();
        while (it.hasNext()) {
            Topic inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addTopic(ITopic topicValue) {
        this.addProperty((Property)Vocabulary.topic, (RDFNode)topicValue);
    }

    @Override
    public void addAllTopic(List<? extends ITopic> topicList) {
        for (ITopic iTopic : topicList) {
            this.addTopic(iTopic);
        }
    }

    @Override
    public void removeTopic(ITopic topicValue) {
        this.removeProperty((Property)Vocabulary.topic, (RDFNode)topicValue);
    }

    @Override
    public void removeAllTopic() {
        this.removeAll((Property)Vocabulary.topic);
    }

    @Override
    public boolean existsDominatingTopic() {
        return this.hasProperty((Property)Vocabulary.dominatingTopic);
    }

    @Override
    public boolean hasDominatingTopic(ITopic topicValue) {
        return this.hasProperty((Property)Vocabulary.dominatingTopic, (RDFNode)topicValue);
    }

    @Override
    public Topic getDominatingTopic() {
        RDFNode n = this.getPropertyValue((Property)Vocabulary.dominatingTopic);
        if (n.canAs(Topic.class)) {
            return (Topic)n.as(Topic.class);
        }
        log.warn((Object)("Could not convert dominatingTopic of " + this.getURI() + " (" + n + ") to type Topic"));
        return null;
    }

    @Override
    public void setDominatingTopic(ITopic topicValue) {
        this.removeAll((Property)Vocabulary.dominatingTopic);
        this.setPropertyValue((Property)Vocabulary.dominatingTopic, (RDFNode)topicValue);
    }

    @Override
    public void removeDominatingTopic() {
        this.removeAll((Property)Vocabulary.dominatingTopic);
    }

    @Override
    public boolean existsSourceString() {
        return this.hasProperty((Property)Vocabulary.sourceString);
    }

    @Override
    public boolean hasSourceString(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.sourceString);
    }

    @Override
    public java.lang.String getSourceString() {
        RDFNode n = this.getPropertyValue((Property)Vocabulary.sourceString);
        if (n instanceof Literal) {
            Literal l = (Literal)n;
            return XsdUtils.getString(l);
        }
        log.warn((Object)("Could not convert sourceString of " + this.getURI() + " (" + n + ") to type String"));
        return null;
    }

    @Override
    public void setSourceString(java.lang.String stringValue) {
        this.removeAll((Property)Vocabulary.sourceString);
        XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.sourceString, (RDFNode)literal);
    }

    @Override
    public void removeSourceString() {
        this.removeAll((Property)Vocabulary.sourceString);
    }

    @Override
    public boolean existsSuperString() {
        return this.hasProperty((Property)Vocabulary.superString);
    }

    @Override
    public boolean hasSuperString(IString stringValue) {
        return this.hasProperty((Property)Vocabulary.superString, (RDFNode)stringValue);
    }

    @Override
    public int countSuperString() {
        int count = 0;
        Iterator<String> it = this.iterateSuperString();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateSuperString() {
        StmtIterator it = this.listProperties((Property)Vocabulary.superString);
        return it.mapWith(String.statementMapper).filterDrop(String.nullFilter);
    }

    @Override
    public List<String> listSuperString() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateSuperString();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addSuperString(IString stringValue) {
        this.addProperty((Property)Vocabulary.superString, (RDFNode)stringValue);
    }

    @Override
    public void addAllSuperString(List<? extends IString> stringList) {
        for (IString iString : stringList) {
            this.addSuperString(iString);
        }
    }

    @Override
    public void removeSuperString(IString stringValue) {
        this.removeProperty((Property)Vocabulary.superString, (RDFNode)stringValue);
    }

    @Override
    public void removeAllSuperString() {
        this.removeAll((Property)Vocabulary.superString);
    }

    @Override
    public boolean existsSubString() {
        return this.hasProperty((Property)Vocabulary.subString);
    }

    @Override
    public boolean hasSubString(IString stringValue) {
        return this.hasProperty((Property)Vocabulary.subString, (RDFNode)stringValue);
    }

    @Override
    public int countSubString() {
        int count = 0;
        Iterator<String> it = this.iterateSubString();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateSubString() {
        StmtIterator it = this.listProperties((Property)Vocabulary.subString);
        return it.mapWith(String.statementMapper).filterDrop(String.nullFilter);
    }

    @Override
    public List<String> listSubString() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateSubString();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addSubString(IString stringValue) {
        this.addProperty((Property)Vocabulary.subString, (RDFNode)stringValue);
    }

    @Override
    public void addAllSubString(List<? extends IString> stringList) {
        for (IString iString : stringList) {
            this.addSubString(iString);
        }
    }

    @Override
    public void removeSubString(IString stringValue) {
        this.removeProperty((Property)Vocabulary.subString, (RDFNode)stringValue);
    }

    @Override
    public void removeAllSubString() {
        this.removeAll((Property)Vocabulary.subString);
    }

    @Override
    public boolean existsSuperStringTrans() {
        return this.hasProperty((Property)Vocabulary.superStringTrans);
    }

    @Override
    public boolean hasSuperStringTrans(IString stringValue) {
        return this.hasProperty((Property)Vocabulary.superStringTrans, (RDFNode)stringValue);
    }

    @Override
    public int countSuperStringTrans() {
        int count = 0;
        Iterator<String> it = this.iterateSuperStringTrans();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateSuperStringTrans() {
        StmtIterator it = this.listProperties((Property)Vocabulary.superStringTrans);
        return it.mapWith(String.statementMapper).filterDrop(String.nullFilter);
    }

    @Override
    public List<String> listSuperStringTrans() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateSuperStringTrans();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addSuperStringTrans(IString stringValue) {
        this.addProperty((Property)Vocabulary.superStringTrans, (RDFNode)stringValue);
    }

    @Override
    public void addAllSuperStringTrans(List<? extends IString> stringList) {
        for (IString iString : stringList) {
            this.addSuperStringTrans(iString);
        }
    }

    @Override
    public void removeSuperStringTrans(IString stringValue) {
        this.removeProperty((Property)Vocabulary.superStringTrans, (RDFNode)stringValue);
    }

    @Override
    public void removeAllSuperStringTrans() {
        this.removeAll((Property)Vocabulary.superStringTrans);
    }

    @Override
    public boolean existsSubStringTrans() {
        return this.hasProperty((Property)Vocabulary.subStringTrans);
    }

    @Override
    public boolean hasSubStringTrans(IString stringValue) {
        return this.hasProperty((Property)Vocabulary.subStringTrans, (RDFNode)stringValue);
    }

    @Override
    public int countSubStringTrans() {
        int count = 0;
        Iterator<String> it = this.iterateSubStringTrans();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateSubStringTrans() {
        StmtIterator it = this.listProperties((Property)Vocabulary.subStringTrans);
        return it.mapWith(String.statementMapper).filterDrop(String.nullFilter);
    }

    @Override
    public List<String> listSubStringTrans() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateSubStringTrans();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addSubStringTrans(IString stringValue) {
        this.addProperty((Property)Vocabulary.subStringTrans, (RDFNode)stringValue);
    }

    @Override
    public void addAllSubStringTrans(List<? extends IString> stringList) {
        for (IString iString : stringList) {
            this.addSubStringTrans(iString);
        }
    }

    @Override
    public void removeSubStringTrans(IString stringValue) {
        this.removeProperty((Property)Vocabulary.subStringTrans, (RDFNode)stringValue);
    }

    @Override
    public void removeAllSubStringTrans() {
        this.removeAll((Property)Vocabulary.subStringTrans);
    }

    @Override
    public boolean existsAnchorOf() {
        return this.hasProperty((Property)Vocabulary.anchorOf);
    }

    @Override
    public boolean hasAnchorOf(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.anchorOf);
    }

    @Override
    public java.lang.String getAnchorOf() {
        RDFNode n = this.getPropertyValue((Property)Vocabulary.anchorOf);
        if (n instanceof Literal) {
            Literal l = (Literal)n;
            return XsdUtils.getString(l);
        }
        log.warn((Object)("Could not convert anchorOf of " + this.getURI() + " (" + n + ") to type String"));
        return null;
    }

    @Override
    public void setAnchorOf(java.lang.String stringValue) {
        this.removeAll((Property)Vocabulary.anchorOf);
        XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.anchorOf, (RDFNode)literal);
    }

    @Override
    public void removeAnchorOf() {
        this.removeAll((Property)Vocabulary.anchorOf);
    }

    @Override
    public boolean existsEndIndex() {
        return this.hasProperty((Property)Vocabulary.endIndex);
    }

    @Override
    public boolean hasEndIndex(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.endIndex);
    }

    @Override
    public int countEndIndex() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateEndIndex();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateEndIndex() {
        StmtIterator it = this.listProperties((Property)Vocabulary.endIndex);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listEndIndex() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateEndIndex();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addEndIndex(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.endIndex, (RDFNode)literal);
    }

    @Override
    public void addAllEndIndex(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addEndIndex(o);
        }
    }

    @Override
    public void removeEndIndex(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.endIndex, (RDFNode)literal);
    }

    @Override
    public void removeAllEndIndex() {
        this.removeAll((Property)Vocabulary.endIndex);
    }

    @Override
    public boolean existsBeginIndex() {
        return this.hasProperty((Property)Vocabulary.beginIndex);
    }

    @Override
    public boolean hasBeginIndex(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.beginIndex);
    }

    @Override
    public int countBeginIndex() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateBeginIndex();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateBeginIndex() {
        StmtIterator it = this.listProperties((Property)Vocabulary.beginIndex);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listBeginIndex() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateBeginIndex();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addBeginIndex(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.beginIndex, (RDFNode)literal);
    }

    @Override
    public void addAllBeginIndex(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addBeginIndex(o);
        }
    }

    @Override
    public void removeBeginIndex(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.beginIndex, (RDFNode)literal);
    }

    @Override
    public void removeAllBeginIndex() {
        this.removeAll((Property)Vocabulary.beginIndex);
    }

    @Override
    public boolean existsRightContext() {
        return this.hasProperty((Property)Vocabulary.rightContext);
    }

    @Override
    public boolean hasRightContext(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.rightContext);
    }

    @Override
    public int countRightContext() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateRightContext();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateRightContext() {
        StmtIterator it = this.listProperties((Property)Vocabulary.rightContext);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listRightContext() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateRightContext();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addRightContext(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.rightContext, (RDFNode)literal);
    }

    @Override
    public void addAllRightContext(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addRightContext(o);
        }
    }

    @Override
    public void removeRightContext(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.rightContext, (RDFNode)literal);
    }

    @Override
    public void removeAllRightContext() {
        this.removeAll((Property)Vocabulary.rightContext);
    }

    @Override
    public boolean existsLeftContext() {
        return this.hasProperty((Property)Vocabulary.leftContext);
    }

    @Override
    public boolean hasLeftContext(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.leftContext);
    }

    @Override
    public int countLeftContext() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateLeftContext();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateLeftContext() {
        StmtIterator it = this.listProperties((Property)Vocabulary.leftContext);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listLeftContext() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateLeftContext();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addLeftContext(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.leftContext, (RDFNode)literal);
    }

    @Override
    public void addAllLeftContext(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addLeftContext(o);
        }
    }

    @Override
    public void removeLeftContext(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.leftContext, (RDFNode)literal);
    }

    @Override
    public void removeAllLeftContext() {
        this.removeAll((Property)Vocabulary.leftContext);
    }
}

