/*
 * Decompiled with CFR 0.152.
 */
package eu.lod2.nlp2rdf.schema.error;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.IndividualImpl;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import eu.lod2.nlp2rdf.schema.error.IError;
import eu.lod2.nlp2rdf.schema.tools.Factory;
import eu.lod2.nlp2rdf.schema.tools.Vocabulary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.tbm.eeni.owl2java.model.jenautils.NullFilter;
import nl.tudelft.tbm.eeni.owl2java.model.xsd.XsdUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Error
extends IndividualImpl
implements IError {
    private static Log log = LogFactory.getLog(Error.class);
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new Error(n, eg);
            }
            log.warn((Object)("Cannot convert node " + n.toString() + " to  Error"));
            return null;
        }

        public boolean canWrap(Node n, EnhGraph eg) {
            if (!(eg instanceof OntModel)) {
                return false;
            }
            Profile profile = ((OntModel)eg).getProfile();
            if (!profile.isSupported(n, eg, Individual.class)) {
                return false;
            }
            Graph graph = eg.asGraph();
            return graph.contains(n, RDF.type.asNode(), Vocabulary.Error.asNode());
        }
    };
    public static final Filter<Error> nullFilter = new NullFilter<Error>();
    public static final Map1<Statement, Error> statementMapper = Error.mapperFrom(Statement.class);
    public static final Map1<Individual, Error> individualMapper = Error.mapperFrom(Individual.class);
    public static final Map1<RDFNode, Error> nodeMapper = Error.mapperFrom(RDFNode.class);

    public static <From> Map1<From, Error> mapperFrom(Class<From> from) {
        return new Map1<From, Error>(){

            public Error map1(Object x) {
                if (x instanceof Statement) {
                    Resource r = ((Statement)x).getResource();
                    if (r.canAs(Error.class)) {
                        return (Error)r.as(Error.class);
                    }
                } else if (x instanceof RDFNode && ((RDFNode)x).canAs(Error.class)) {
                    return (Error)((RDFNode)x).as(Error.class);
                }
                return null;
            }
        };
    }

    public Error(Node n, EnhGraph g) {
        super(n, g);
    }

    public static void register() {
        log.debug((Object)"Registering custom class Error with jena");
        BuiltinPersonalities.model.add(Error.class, factory);
        BuiltinPersonalities.model.add(Error.class, factory);
    }

    public static Error get(String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return (Error)individual.as(Error.class);
    }

    public static Error get(String uri) {
        return Error.get(uri, Factory.getDefaultModel());
    }

    public static Iterator<Error> iterate(OntModel ontModel) {
        ExtendedIterator it = ontModel.listIndividuals((Resource)Vocabulary.Error);
        return it.mapWith(individualMapper).filterDrop(nullFilter);
    }

    public static Iterator<Error> iterate() {
        return Error.iterate(Factory.getDefaultModel());
    }

    public static List<Error> list(OntModel ontModel) {
        ArrayList<Error> list = new ArrayList<Error>();
        Iterator<Error> it = Error.iterate(ontModel);
        while (it.hasNext()) {
            Error cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Error> list() {
        return Error.list(Factory.getDefaultModel());
    }

    public static Iterator<Error> iterate(boolean direct, OntModel ontModel) {
        OntClass cls = ontModel.getOntClass("http://nlp2rdf.lod2.eu/schema/error/Error");
        ExtendedIterator it = cls.listInstances(direct);
        WrappedIterator<RDFNode> nodeIt = new WrappedIterator<RDFNode>((Iterator)it){};
        return nodeIt.mapWith(nodeMapper).filterDrop(nullFilter);
    }

    public static Iterator<Error> iterate(boolean direct) {
        return Error.iterate(direct, Factory.getDefaultModel());
    }

    public static List<Error> list(boolean direct, OntModel ontModel) {
        ArrayList<Error> list = new ArrayList<Error>();
        Iterator<Error> it = Error.iterate(direct, ontModel);
        while (it.hasNext()) {
            Error cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Error> list(boolean direct) {
        return Error.list(direct, Factory.getDefaultModel());
    }

    public static int count(OntModel ontModel) {
        int count = 0;
        Iterator<Error> it = Error.iterate(ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count() {
        return Error.count(Factory.getDefaultModel());
    }

    public static int count(boolean direct, OntModel ontModel) {
        int count = 0;
        Iterator<Error> it = Error.iterate(direct, ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count(boolean direct) {
        return Error.count(direct, Factory.getDefaultModel());
    }

    public static boolean exists(String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return individual != null;
    }

    public static boolean exists(String uri) {
        return Error.exists(uri, Factory.getDefaultModel());
    }

    public static Error create(String uri, OntModel ontModel) {
        return (Error)ontModel.createOntResource(Error.class, (Resource)Vocabulary.Error, uri);
    }

    public static Error create(OntModel ontModel) {
        return Error.create(null, ontModel);
    }

    public static Error create(String uri) {
        return Error.create(uri, Factory.getDefaultModel());
    }

    public static Error create() {
        return Error.create(null, Factory.getDefaultModel());
    }

    public static void delete(String uri, OntModel ontModel) {
        Factory.deleteInstance(uri, ontModel);
    }

    public static void delete(String uri) {
        Factory.deleteInstance(uri);
    }

    @Override
    public boolean existsFatal() {
        return this.hasProperty((Property)Vocabulary.fatal);
    }

    @Override
    public boolean hasFatal(Boolean booleanValue) {
        return this.hasProperty((Property)Vocabulary.fatal);
    }

    @Override
    public Boolean getFatal() {
        RDFNode n = this.getPropertyValue((Property)Vocabulary.fatal);
        if (n instanceof Literal) {
            Literal l = (Literal)n;
            return XsdUtils.getBoolean(l);
        }
        log.warn((Object)("Could not convert fatal of " + this.getURI() + " (" + n + ") to type Boolean"));
        return null;
    }

    @Override
    public void setFatal(Boolean booleanValue) {
        this.removeAll((Property)Vocabulary.fatal);
        XsdUtils.createTypedLiteral((OntModel)this.getModel(), booleanValue, "http://www.w3.org/2001/XMLSchema#boolean");
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), booleanValue, "http://www.w3.org/2001/XMLSchema#boolean");
        this.setPropertyValue((Property)Vocabulary.fatal, (RDFNode)literal);
    }

    @Override
    public void removeFatal() {
        this.removeAll((Property)Vocabulary.fatal);
    }

    @Override
    public boolean existsSource() {
        return this.hasProperty((Property)Vocabulary.source);
    }

    @Override
    public boolean hasSource(String stringValue) {
        return this.hasProperty((Property)Vocabulary.source);
    }

    @Override
    public int countSource() {
        int count = 0;
        Iterator<String> it = this.iterateSource();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateSource() {
        StmtIterator it = this.listProperties((Property)Vocabulary.source);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<String> listSource() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateSource();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addSource(String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.source, (RDFNode)literal);
    }

    @Override
    public void addAllSource(List<String> stringList) {
        for (String o : stringList) {
            this.addSource(o);
        }
    }

    @Override
    public void removeSource(String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.source, (RDFNode)literal);
    }

    @Override
    public void removeAllSource() {
        this.removeAll((Property)Vocabulary.source);
    }

    @Override
    public boolean existsMessage() {
        return this.hasProperty((Property)Vocabulary.message);
    }

    @Override
    public boolean hasMessage(String stringValue) {
        return this.hasProperty((Property)Vocabulary.message);
    }

    @Override
    public int countMessage() {
        int count = 0;
        Iterator<String> it = this.iterateMessage();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateMessage() {
        StmtIterator it = this.listProperties((Property)Vocabulary.message);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<String> listMessage() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateMessage();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addMessage(String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.message, (RDFNode)literal);
    }

    @Override
    public void addAllMessage(List<String> stringList) {
        for (String o : stringList) {
            this.addMessage(o);
        }
    }

    @Override
    public void removeMessage(String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.message, (RDFNode)literal);
    }

    @Override
    public void removeAllMessage() {
        this.removeAll((Property)Vocabulary.message);
    }
}

