/*
 * Decompiled with CFR 0.152.
 */
package eu.lod2.nlp2rdf.schema.sso;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.IndividualImpl;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import eu.lod2.nlp2rdf.schema.IThing;
import eu.lod2.nlp2rdf.schema.Thing;
import eu.lod2.nlp2rdf.schema.sso.ISentence;
import eu.lod2.nlp2rdf.schema.sso.IWord;
import eu.lod2.nlp2rdf.schema.sso.Sentence;
import eu.lod2.nlp2rdf.schema.str.IString;
import eu.lod2.nlp2rdf.schema.str.String;
import eu.lod2.nlp2rdf.schema.tools.Factory;
import eu.lod2.nlp2rdf.schema.tools.Vocabulary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.tbm.eeni.owl2java.model.jenautils.NullFilter;
import nl.tudelft.tbm.eeni.owl2java.model.xsd.XsdUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Word
extends IndividualImpl
implements IWord {
    private static Log log = LogFactory.getLog(Word.class);
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new Word(n, eg);
            }
            log.warn((Object)("Cannot convert node " + n.toString() + " to  Word"));
            return null;
        }

        public boolean canWrap(Node n, EnhGraph eg) {
            if (!(eg instanceof OntModel)) {
                return false;
            }
            Profile profile = ((OntModel)eg).getProfile();
            if (!profile.isSupported(n, eg, Individual.class)) {
                return false;
            }
            Graph graph = eg.asGraph();
            return graph.contains(n, RDF.type.asNode(), Vocabulary.Word.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.StopWord.asNode());
        }
    };
    public static final Filter<Word> nullFilter = new NullFilter<Word>();
    public static final Map1<Statement, Word> statementMapper = Word.mapperFrom(Statement.class);
    public static final Map1<Individual, Word> individualMapper = Word.mapperFrom(Individual.class);
    public static final Map1<RDFNode, Word> nodeMapper = Word.mapperFrom(RDFNode.class);

    public static <From> Map1<From, Word> mapperFrom(Class<From> from) {
        return new Map1<From, Word>(){

            public Word map1(Object x) {
                if (x instanceof Statement) {
                    Resource r = ((Statement)x).getResource();
                    if (r.canAs(Word.class)) {
                        return (Word)r.as(Word.class);
                    }
                } else if (x instanceof RDFNode && ((RDFNode)x).canAs(Word.class)) {
                    return (Word)((RDFNode)x).as(Word.class);
                }
                return null;
            }
        };
    }

    public Word(Node n, EnhGraph g) {
        super(n, g);
    }

    public static void register() {
        log.debug((Object)"Registering custom class Word with jena");
        BuiltinPersonalities.model.add(Word.class, factory);
        BuiltinPersonalities.model.add(Word.class, factory);
    }

    public static Word get(java.lang.String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return (Word)individual.as(Word.class);
    }

    public static Word get(java.lang.String uri) {
        return Word.get(uri, Factory.getDefaultModel());
    }

    public static Iterator<Word> iterate(OntModel ontModel) {
        ExtendedIterator it = ontModel.listIndividuals((Resource)Vocabulary.Word);
        return it.mapWith(individualMapper).filterDrop(nullFilter);
    }

    public static Iterator<Word> iterate() {
        return Word.iterate(Factory.getDefaultModel());
    }

    public static List<Word> list(OntModel ontModel) {
        ArrayList<Word> list = new ArrayList<Word>();
        Iterator<Word> it = Word.iterate(ontModel);
        while (it.hasNext()) {
            Word cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Word> list() {
        return Word.list(Factory.getDefaultModel());
    }

    public static Iterator<Word> iterate(boolean direct, OntModel ontModel) {
        OntClass cls = ontModel.getOntClass("http://nlp2rdf.lod2.eu/schema/sso/Word");
        ExtendedIterator it = cls.listInstances(direct);
        WrappedIterator<RDFNode> nodeIt = new WrappedIterator<RDFNode>((Iterator)it){};
        return nodeIt.mapWith(nodeMapper).filterDrop(nullFilter);
    }

    public static Iterator<Word> iterate(boolean direct) {
        return Word.iterate(direct, Factory.getDefaultModel());
    }

    public static List<Word> list(boolean direct, OntModel ontModel) {
        ArrayList<Word> list = new ArrayList<Word>();
        Iterator<Word> it = Word.iterate(direct, ontModel);
        while (it.hasNext()) {
            Word cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Word> list(boolean direct) {
        return Word.list(direct, Factory.getDefaultModel());
    }

    public static int count(OntModel ontModel) {
        int count = 0;
        Iterator<Word> it = Word.iterate(ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count() {
        return Word.count(Factory.getDefaultModel());
    }

    public static int count(boolean direct, OntModel ontModel) {
        int count = 0;
        Iterator<Word> it = Word.iterate(direct, ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count(boolean direct) {
        return Word.count(direct, Factory.getDefaultModel());
    }

    public static boolean exists(java.lang.String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return individual != null;
    }

    public static boolean exists(java.lang.String uri) {
        return Word.exists(uri, Factory.getDefaultModel());
    }

    public static Word create(java.lang.String uri, OntModel ontModel) {
        return (Word)ontModel.createOntResource(Word.class, (Resource)Vocabulary.Word, uri);
    }

    public static Word create(OntModel ontModel) {
        return Word.create(null, ontModel);
    }

    public static Word create(java.lang.String uri) {
        return Word.create(uri, Factory.getDefaultModel());
    }

    public static Word create() {
        return Word.create(null, Factory.getDefaultModel());
    }

    public static void delete(java.lang.String uri, OntModel ontModel) {
        Factory.deleteInstance(uri, ontModel);
    }

    public static void delete(java.lang.String uri) {
        Factory.deleteInstance(uri);
    }

    @Override
    public boolean existsSentence() {
        return this.hasProperty((Property)Vocabulary.sentence);
    }

    @Override
    public boolean hasSentence(ISentence sentenceValue) {
        return this.hasProperty((Property)Vocabulary.sentence, (RDFNode)sentenceValue);
    }

    @Override
    public Sentence getSentence() {
        RDFNode n = this.getPropertyValue((Property)Vocabulary.sentence);
        if (n.canAs(Sentence.class)) {
            return (Sentence)n.as(Sentence.class);
        }
        log.warn((Object)("Could not convert sentence of " + this.getURI() + " (" + n + ") to type Sentence"));
        return null;
    }

    @Override
    public void setSentence(ISentence sentenceValue) {
        this.removeAll((Property)Vocabulary.sentence);
        this.setPropertyValue((Property)Vocabulary.sentence, (RDFNode)sentenceValue);
    }

    @Override
    public void removeSentence() {
        this.removeAll((Property)Vocabulary.sentence);
    }

    @Override
    public boolean existsOliaLink() {
        return this.hasProperty((Property)Vocabulary.oliaLink);
    }

    @Override
    public boolean hasOliaLink(IThing thingValue) {
        return this.hasProperty((Property)Vocabulary.oliaLink, (RDFNode)thingValue);
    }

    @Override
    public int countOliaLink() {
        int count = 0;
        Iterator<Thing> it = this.iterateOliaLink();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Thing> iterateOliaLink() {
        StmtIterator it = this.listProperties((Property)Vocabulary.oliaLink);
        return it.mapWith(Thing.statementMapper).filterDrop(Thing.nullFilter);
    }

    @Override
    public List<Thing> listOliaLink() {
        ArrayList<Thing> list = new ArrayList<Thing>();
        Iterator<Thing> it = this.iterateOliaLink();
        while (it.hasNext()) {
            Thing inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addOliaLink(IThing thingValue) {
        this.addProperty((Property)Vocabulary.oliaLink, (RDFNode)thingValue);
    }

    @Override
    public void addAllOliaLink(List<? extends IThing> thingList) {
        for (IThing iThing : thingList) {
            this.addOliaLink(iThing);
        }
    }

    @Override
    public void removeOliaLink(IThing thingValue) {
        this.removeProperty((Property)Vocabulary.oliaLink, (RDFNode)thingValue);
    }

    @Override
    public void removeAllOliaLink() {
        this.removeAll((Property)Vocabulary.oliaLink);
    }

    @Override
    public boolean existsPreviousWord() {
        return this.hasProperty((Property)Vocabulary.previousWord);
    }

    @Override
    public boolean hasPreviousWord(IWord wordValue) {
        return this.hasProperty((Property)Vocabulary.previousWord, (RDFNode)wordValue);
    }

    @Override
    public Word getPreviousWord() {
        RDFNode n = this.getPropertyValue((Property)Vocabulary.previousWord);
        if (n.canAs(Word.class)) {
            return (Word)n.as(Word.class);
        }
        log.warn((Object)("Could not convert previousWord of " + this.getURI() + " (" + n + ") to type Word"));
        return null;
    }

    @Override
    public void setPreviousWord(IWord wordValue) {
        this.removeAll((Property)Vocabulary.previousWord);
        this.setPropertyValue((Property)Vocabulary.previousWord, (RDFNode)wordValue);
    }

    @Override
    public void removePreviousWord() {
        this.removeAll((Property)Vocabulary.previousWord);
    }

    @Override
    public boolean existsNextWord() {
        return this.hasProperty((Property)Vocabulary.nextWord);
    }

    @Override
    public boolean hasNextWord(IWord wordValue) {
        return this.hasProperty((Property)Vocabulary.nextWord, (RDFNode)wordValue);
    }

    @Override
    public Word getNextWord() {
        RDFNode n = this.getPropertyValue((Property)Vocabulary.nextWord);
        if (n.canAs(Word.class)) {
            return (Word)n.as(Word.class);
        }
        log.warn((Object)("Could not convert nextWord of " + this.getURI() + " (" + n + ") to type Word"));
        return null;
    }

    @Override
    public void setNextWord(IWord wordValue) {
        this.removeAll((Property)Vocabulary.nextWord);
        this.setPropertyValue((Property)Vocabulary.nextWord, (RDFNode)wordValue);
    }

    @Override
    public void removeNextWord() {
        this.removeAll((Property)Vocabulary.nextWord);
    }

    @Override
    public boolean existsNextSentenceTrans() {
        return this.hasProperty((Property)Vocabulary.nextSentenceTrans);
    }

    @Override
    public boolean hasNextSentenceTrans(IWord wordValue) {
        return this.hasProperty((Property)Vocabulary.nextSentenceTrans, (RDFNode)wordValue);
    }

    @Override
    public int countNextSentenceTrans() {
        int count = 0;
        Iterator<Word> it = this.iterateNextSentenceTrans();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Word> iterateNextSentenceTrans() {
        StmtIterator it = this.listProperties((Property)Vocabulary.nextSentenceTrans);
        return it.mapWith(statementMapper).filterDrop(nullFilter);
    }

    @Override
    public List<Word> listNextSentenceTrans() {
        ArrayList<Word> list = new ArrayList<Word>();
        Iterator<Word> it = this.iterateNextSentenceTrans();
        while (it.hasNext()) {
            Word inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addNextSentenceTrans(IWord wordValue) {
        this.addProperty((Property)Vocabulary.nextSentenceTrans, (RDFNode)wordValue);
    }

    @Override
    public void addAllNextSentenceTrans(List<? extends IWord> wordList) {
        for (IWord iWord : wordList) {
            this.addNextSentenceTrans(iWord);
        }
    }

    @Override
    public void removeNextSentenceTrans(IWord wordValue) {
        this.removeProperty((Property)Vocabulary.nextSentenceTrans, (RDFNode)wordValue);
    }

    @Override
    public void removeAllNextSentenceTrans() {
        this.removeAll((Property)Vocabulary.nextSentenceTrans);
    }

    @Override
    public boolean existsPreviousWordTrans() {
        return this.hasProperty((Property)Vocabulary.previousWordTrans);
    }

    @Override
    public boolean hasPreviousWordTrans(IWord wordValue) {
        return this.hasProperty((Property)Vocabulary.previousWordTrans, (RDFNode)wordValue);
    }

    @Override
    public int countPreviousWordTrans() {
        int count = 0;
        Iterator<Word> it = this.iteratePreviousWordTrans();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Word> iteratePreviousWordTrans() {
        StmtIterator it = this.listProperties((Property)Vocabulary.previousWordTrans);
        return it.mapWith(statementMapper).filterDrop(nullFilter);
    }

    @Override
    public List<Word> listPreviousWordTrans() {
        ArrayList<Word> list = new ArrayList<Word>();
        Iterator<Word> it = this.iteratePreviousWordTrans();
        while (it.hasNext()) {
            Word inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addPreviousWordTrans(IWord wordValue) {
        this.addProperty((Property)Vocabulary.previousWordTrans, (RDFNode)wordValue);
    }

    @Override
    public void addAllPreviousWordTrans(List<? extends IWord> wordList) {
        for (IWord iWord : wordList) {
            this.addPreviousWordTrans(iWord);
        }
    }

    @Override
    public void removePreviousWordTrans(IWord wordValue) {
        this.removeProperty((Property)Vocabulary.previousWordTrans, (RDFNode)wordValue);
    }

    @Override
    public void removeAllPreviousWordTrans() {
        this.removeAll((Property)Vocabulary.previousWordTrans);
    }

    @Override
    public boolean existsNextWordTrans() {
        return this.hasProperty((Property)Vocabulary.nextWordTrans);
    }

    @Override
    public boolean hasNextWordTrans(IWord wordValue) {
        return this.hasProperty((Property)Vocabulary.nextWordTrans, (RDFNode)wordValue);
    }

    @Override
    public int countNextWordTrans() {
        int count = 0;
        Iterator<Word> it = this.iterateNextWordTrans();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Word> iterateNextWordTrans() {
        StmtIterator it = this.listProperties((Property)Vocabulary.nextWordTrans);
        return it.mapWith(statementMapper).filterDrop(nullFilter);
    }

    @Override
    public List<Word> listNextWordTrans() {
        ArrayList<Word> list = new ArrayList<Word>();
        Iterator<Word> it = this.iterateNextWordTrans();
        while (it.hasNext()) {
            Word inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addNextWordTrans(IWord wordValue) {
        this.addProperty((Property)Vocabulary.nextWordTrans, (RDFNode)wordValue);
    }

    @Override
    public void addAllNextWordTrans(List<? extends IWord> wordList) {
        for (IWord iWord : wordList) {
            this.addNextWordTrans(iWord);
        }
    }

    @Override
    public void removeNextWordTrans(IWord wordValue) {
        this.removeProperty((Property)Vocabulary.nextWordTrans, (RDFNode)wordValue);
    }

    @Override
    public void removeAllNextWordTrans() {
        this.removeAll((Property)Vocabulary.nextWordTrans);
    }

    @Override
    public boolean existsPosTag() {
        return this.hasProperty((Property)Vocabulary.posTag);
    }

    @Override
    public boolean hasPosTag(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.posTag);
    }

    @Override
    public int countPosTag() {
        int count = 0;
        Iterator<java.lang.String> it = this.iteratePosTag();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iteratePosTag() {
        StmtIterator it = this.listProperties((Property)Vocabulary.posTag);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listPosTag() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iteratePosTag();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addPosTag(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.posTag, (RDFNode)literal);
    }

    @Override
    public void addAllPosTag(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addPosTag(o);
        }
    }

    @Override
    public void removePosTag(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.posTag, (RDFNode)literal);
    }

    @Override
    public void removeAllPosTag() {
        this.removeAll((Property)Vocabulary.posTag);
    }

    @Override
    public boolean existsLemma() {
        return this.hasProperty((Property)Vocabulary.lemma);
    }

    @Override
    public boolean hasLemma(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.lemma);
    }

    @Override
    public int countLemma() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateLemma();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateLemma() {
        StmtIterator it = this.listProperties((Property)Vocabulary.lemma);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listLemma() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateLemma();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addLemma(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.lemma, (RDFNode)literal);
    }

    @Override
    public void addAllLemma(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addLemma(o);
        }
    }

    @Override
    public void removeLemma(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.lemma, (RDFNode)literal);
    }

    @Override
    public void removeAllLemma() {
        this.removeAll((Property)Vocabulary.lemma);
    }

    @Override
    public boolean existsStem() {
        return this.hasProperty((Property)Vocabulary.stem);
    }

    @Override
    public boolean hasStem(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.stem);
    }

    @Override
    public int countStem() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateStem();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateStem() {
        StmtIterator it = this.listProperties((Property)Vocabulary.stem);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listStem() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateStem();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addStem(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.stem, (RDFNode)literal);
    }

    @Override
    public void addAllStem(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addStem(o);
        }
    }

    @Override
    public void removeStem(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.stem, (RDFNode)literal);
    }

    @Override
    public void removeAllStem() {
        this.removeAll((Property)Vocabulary.stem);
    }

    @Override
    public boolean existsSuperString() {
        return this.hasProperty((Property)Vocabulary.superString);
    }

    @Override
    public boolean hasSuperString(IString stringValue) {
        return this.hasProperty((Property)Vocabulary.superString, (RDFNode)stringValue);
    }

    @Override
    public int countSuperString() {
        int count = 0;
        Iterator<String> it = this.iterateSuperString();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateSuperString() {
        StmtIterator it = this.listProperties((Property)Vocabulary.superString);
        return it.mapWith(String.statementMapper).filterDrop(String.nullFilter);
    }

    @Override
    public List<String> listSuperString() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateSuperString();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addSuperString(IString stringValue) {
        this.addProperty((Property)Vocabulary.superString, (RDFNode)stringValue);
    }

    @Override
    public void addAllSuperString(List<? extends IString> stringList) {
        for (IString iString : stringList) {
            this.addSuperString(iString);
        }
    }

    @Override
    public void removeSuperString(IString stringValue) {
        this.removeProperty((Property)Vocabulary.superString, (RDFNode)stringValue);
    }

    @Override
    public void removeAllSuperString() {
        this.removeAll((Property)Vocabulary.superString);
    }

    @Override
    public boolean existsSubString() {
        return this.hasProperty((Property)Vocabulary.subString);
    }

    @Override
    public boolean hasSubString(IString stringValue) {
        return this.hasProperty((Property)Vocabulary.subString, (RDFNode)stringValue);
    }

    @Override
    public int countSubString() {
        int count = 0;
        Iterator<String> it = this.iterateSubString();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateSubString() {
        StmtIterator it = this.listProperties((Property)Vocabulary.subString);
        return it.mapWith(String.statementMapper).filterDrop(String.nullFilter);
    }

    @Override
    public List<String> listSubString() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateSubString();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addSubString(IString stringValue) {
        this.addProperty((Property)Vocabulary.subString, (RDFNode)stringValue);
    }

    @Override
    public void addAllSubString(List<? extends IString> stringList) {
        for (IString iString : stringList) {
            this.addSubString(iString);
        }
    }

    @Override
    public void removeSubString(IString stringValue) {
        this.removeProperty((Property)Vocabulary.subString, (RDFNode)stringValue);
    }

    @Override
    public void removeAllSubString() {
        this.removeAll((Property)Vocabulary.subString);
    }

    @Override
    public boolean existsSuperStringTrans() {
        return this.hasProperty((Property)Vocabulary.superStringTrans);
    }

    @Override
    public boolean hasSuperStringTrans(IString stringValue) {
        return this.hasProperty((Property)Vocabulary.superStringTrans, (RDFNode)stringValue);
    }

    @Override
    public int countSuperStringTrans() {
        int count = 0;
        Iterator<String> it = this.iterateSuperStringTrans();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateSuperStringTrans() {
        StmtIterator it = this.listProperties((Property)Vocabulary.superStringTrans);
        return it.mapWith(String.statementMapper).filterDrop(String.nullFilter);
    }

    @Override
    public List<String> listSuperStringTrans() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateSuperStringTrans();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addSuperStringTrans(IString stringValue) {
        this.addProperty((Property)Vocabulary.superStringTrans, (RDFNode)stringValue);
    }

    @Override
    public void addAllSuperStringTrans(List<? extends IString> stringList) {
        for (IString iString : stringList) {
            this.addSuperStringTrans(iString);
        }
    }

    @Override
    public void removeSuperStringTrans(IString stringValue) {
        this.removeProperty((Property)Vocabulary.superStringTrans, (RDFNode)stringValue);
    }

    @Override
    public void removeAllSuperStringTrans() {
        this.removeAll((Property)Vocabulary.superStringTrans);
    }

    @Override
    public boolean existsSubStringTrans() {
        return this.hasProperty((Property)Vocabulary.subStringTrans);
    }

    @Override
    public boolean hasSubStringTrans(IString stringValue) {
        return this.hasProperty((Property)Vocabulary.subStringTrans, (RDFNode)stringValue);
    }

    @Override
    public int countSubStringTrans() {
        int count = 0;
        Iterator<String> it = this.iterateSubStringTrans();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterateSubStringTrans() {
        StmtIterator it = this.listProperties((Property)Vocabulary.subStringTrans);
        return it.mapWith(String.statementMapper).filterDrop(String.nullFilter);
    }

    @Override
    public List<String> listSubStringTrans() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.iterateSubStringTrans();
        while (it.hasNext()) {
            String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addSubStringTrans(IString stringValue) {
        this.addProperty((Property)Vocabulary.subStringTrans, (RDFNode)stringValue);
    }

    @Override
    public void addAllSubStringTrans(List<? extends IString> stringList) {
        for (IString iString : stringList) {
            this.addSubStringTrans(iString);
        }
    }

    @Override
    public void removeSubStringTrans(IString stringValue) {
        this.removeProperty((Property)Vocabulary.subStringTrans, (RDFNode)stringValue);
    }

    @Override
    public void removeAllSubStringTrans() {
        this.removeAll((Property)Vocabulary.subStringTrans);
    }

    @Override
    public boolean existsAnchorOf() {
        return this.hasProperty((Property)Vocabulary.anchorOf);
    }

    @Override
    public boolean hasAnchorOf(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.anchorOf);
    }

    @Override
    public java.lang.String getAnchorOf() {
        RDFNode n = this.getPropertyValue((Property)Vocabulary.anchorOf);
        if (n instanceof Literal) {
            Literal l = (Literal)n;
            return XsdUtils.getString(l);
        }
        log.warn((Object)("Could not convert anchorOf of " + this.getURI() + " (" + n + ") to type String"));
        return null;
    }

    @Override
    public void setAnchorOf(java.lang.String stringValue) {
        this.removeAll((Property)Vocabulary.anchorOf);
        XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.anchorOf, (RDFNode)literal);
    }

    @Override
    public void removeAnchorOf() {
        this.removeAll((Property)Vocabulary.anchorOf);
    }

    @Override
    public boolean existsEndIndex() {
        return this.hasProperty((Property)Vocabulary.endIndex);
    }

    @Override
    public boolean hasEndIndex(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.endIndex);
    }

    @Override
    public int countEndIndex() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateEndIndex();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateEndIndex() {
        StmtIterator it = this.listProperties((Property)Vocabulary.endIndex);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listEndIndex() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateEndIndex();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addEndIndex(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.endIndex, (RDFNode)literal);
    }

    @Override
    public void addAllEndIndex(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addEndIndex(o);
        }
    }

    @Override
    public void removeEndIndex(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.endIndex, (RDFNode)literal);
    }

    @Override
    public void removeAllEndIndex() {
        this.removeAll((Property)Vocabulary.endIndex);
    }

    @Override
    public boolean existsBeginIndex() {
        return this.hasProperty((Property)Vocabulary.beginIndex);
    }

    @Override
    public boolean hasBeginIndex(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.beginIndex);
    }

    @Override
    public int countBeginIndex() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateBeginIndex();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateBeginIndex() {
        StmtIterator it = this.listProperties((Property)Vocabulary.beginIndex);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listBeginIndex() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateBeginIndex();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addBeginIndex(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.beginIndex, (RDFNode)literal);
    }

    @Override
    public void addAllBeginIndex(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addBeginIndex(o);
        }
    }

    @Override
    public void removeBeginIndex(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.beginIndex, (RDFNode)literal);
    }

    @Override
    public void removeAllBeginIndex() {
        this.removeAll((Property)Vocabulary.beginIndex);
    }

    @Override
    public boolean existsRightContext() {
        return this.hasProperty((Property)Vocabulary.rightContext);
    }

    @Override
    public boolean hasRightContext(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.rightContext);
    }

    @Override
    public int countRightContext() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateRightContext();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateRightContext() {
        StmtIterator it = this.listProperties((Property)Vocabulary.rightContext);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listRightContext() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateRightContext();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addRightContext(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.rightContext, (RDFNode)literal);
    }

    @Override
    public void addAllRightContext(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addRightContext(o);
        }
    }

    @Override
    public void removeRightContext(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.rightContext, (RDFNode)literal);
    }

    @Override
    public void removeAllRightContext() {
        this.removeAll((Property)Vocabulary.rightContext);
    }

    @Override
    public boolean existsLeftContext() {
        return this.hasProperty((Property)Vocabulary.leftContext);
    }

    @Override
    public boolean hasLeftContext(java.lang.String stringValue) {
        return this.hasProperty((Property)Vocabulary.leftContext);
    }

    @Override
    public int countLeftContext() {
        int count = 0;
        Iterator<java.lang.String> it = this.iterateLeftContext();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<java.lang.String> iterateLeftContext() {
        StmtIterator it = this.listProperties((Property)Vocabulary.leftContext);
        return it.mapWith(XsdUtils.objectAsStringMapper).filterDrop(new NullFilter());
    }

    @Override
    public List<java.lang.String> listLeftContext() {
        ArrayList<java.lang.String> list = new ArrayList<java.lang.String>();
        Iterator<java.lang.String> it = this.iterateLeftContext();
        while (it.hasNext()) {
            java.lang.String inst = it.next();
            list.add(inst);
        }
        return list;
    }

    @Override
    public void addLeftContext(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.setPropertyValue((Property)Vocabulary.leftContext, (RDFNode)literal);
    }

    @Override
    public void addAllLeftContext(List<java.lang.String> stringList) {
        for (java.lang.String o : stringList) {
            this.addLeftContext(o);
        }
    }

    @Override
    public void removeLeftContext(java.lang.String stringValue) {
        Literal literal = XsdUtils.createTypedLiteral((OntModel)this.getModel(), stringValue, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
        this.removeProperty((Property)Vocabulary.leftContext, (RDFNode)literal);
    }

    @Override
    public void removeAllLeftContext() {
        this.removeAll((Property)Vocabulary.leftContext);
    }
}

