/*
 * Decompiled with CFR 0.152.
 */
package eu.lod2.nlp2rdf.schema;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.IndividualImpl;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import eu.lod2.nlp2rdf.schema.IThing;
import eu.lod2.nlp2rdf.schema.tools.Factory;
import eu.lod2.nlp2rdf.schema.tools.Vocabulary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.tbm.eeni.owl2java.model.jenautils.NullFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Thing
extends IndividualImpl
implements IThing {
    private static Log log = LogFactory.getLog(Thing.class);
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new Thing(n, eg);
            }
            log.warn((Object)("Cannot convert node " + n.toString() + " to  Thing"));
            return null;
        }

        public boolean canWrap(Node n, EnhGraph eg) {
            if (!(eg instanceof OntModel)) {
                return false;
            }
            Profile profile = ((OntModel)eg).getProfile();
            if (!profile.isSupported(n, eg, Individual.class)) {
                return false;
            }
            Graph graph = eg.asGraph();
            return graph.contains(n, RDF.type.asNode(), Vocabulary.Thing.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.String.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.OffsetBasedString.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.ContextHashBasedString.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.Document.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.Phrase.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.Word.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.StopWord.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.Sentence.asNode()) || graph.contains(n, RDF.type.asNode(), Vocabulary.Topic.asNode());
        }
    };
    public static final Filter<Thing> nullFilter = new NullFilter<Thing>();
    public static final Map1<Statement, Thing> statementMapper = Thing.mapperFrom(Statement.class);
    public static final Map1<Individual, Thing> individualMapper = Thing.mapperFrom(Individual.class);
    public static final Map1<RDFNode, Thing> nodeMapper = Thing.mapperFrom(RDFNode.class);

    public static <From> Map1<From, Thing> mapperFrom(Class<From> from) {
        return new Map1<From, Thing>(){

            public Thing map1(Object x) {
                if (x instanceof Statement) {
                    Resource r = ((Statement)x).getResource();
                    if (r.canAs(Thing.class)) {
                        return (Thing)r.as(Thing.class);
                    }
                } else if (x instanceof RDFNode && ((RDFNode)x).canAs(Thing.class)) {
                    return (Thing)((RDFNode)x).as(Thing.class);
                }
                return null;
            }
        };
    }

    public Thing(Node n, EnhGraph g) {
        super(n, g);
    }

    public static void register() {
        log.debug((Object)"Registering custom class Thing with jena");
        BuiltinPersonalities.model.add(Thing.class, factory);
        BuiltinPersonalities.model.add(Thing.class, factory);
    }

    public static Thing get(String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return (Thing)individual.as(Thing.class);
    }

    public static Thing get(String uri) {
        return Thing.get(uri, Factory.getDefaultModel());
    }

    public static Iterator<Thing> iterate(OntModel ontModel) {
        ExtendedIterator it = ontModel.listIndividuals((Resource)Vocabulary.Thing);
        return it.mapWith(individualMapper).filterDrop(nullFilter);
    }

    public static Iterator<Thing> iterate() {
        return Thing.iterate(Factory.getDefaultModel());
    }

    public static List<Thing> list(OntModel ontModel) {
        ArrayList<Thing> list = new ArrayList<Thing>();
        Iterator<Thing> it = Thing.iterate(ontModel);
        while (it.hasNext()) {
            Thing cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Thing> list() {
        return Thing.list(Factory.getDefaultModel());
    }

    public static Iterator<Thing> iterate(boolean direct, OntModel ontModel) {
        OntClass cls = ontModel.getOntClass("http://www.w3.org/2002/07/owl#Thing");
        ExtendedIterator it = cls.listInstances(direct);
        WrappedIterator<RDFNode> nodeIt = new WrappedIterator<RDFNode>((Iterator)it){};
        return nodeIt.mapWith(nodeMapper).filterDrop(nullFilter);
    }

    public static Iterator<Thing> iterate(boolean direct) {
        return Thing.iterate(direct, Factory.getDefaultModel());
    }

    public static List<Thing> list(boolean direct, OntModel ontModel) {
        ArrayList<Thing> list = new ArrayList<Thing>();
        Iterator<Thing> it = Thing.iterate(direct, ontModel);
        while (it.hasNext()) {
            Thing cls = it.next();
            list.add(cls);
        }
        return list;
    }

    public static List<Thing> list(boolean direct) {
        return Thing.list(direct, Factory.getDefaultModel());
    }

    public static int count(OntModel ontModel) {
        int count = 0;
        Iterator<Thing> it = Thing.iterate(ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count() {
        return Thing.count(Factory.getDefaultModel());
    }

    public static int count(boolean direct, OntModel ontModel) {
        int count = 0;
        Iterator<Thing> it = Thing.iterate(direct, ontModel);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int count(boolean direct) {
        return Thing.count(direct, Factory.getDefaultModel());
    }

    public static boolean exists(String uri, OntModel ontModel) {
        Individual individual = ontModel.getIndividual(uri);
        return individual != null;
    }

    public static boolean exists(String uri) {
        return Thing.exists(uri, Factory.getDefaultModel());
    }

    public static Thing create(String uri, OntModel ontModel) {
        return (Thing)ontModel.createOntResource(Thing.class, (Resource)Vocabulary.Thing, uri);
    }

    public static Thing create(OntModel ontModel) {
        return Thing.create(null, ontModel);
    }

    public static Thing create(String uri) {
        return Thing.create(uri, Factory.getDefaultModel());
    }

    public static Thing create() {
        return Thing.create(null, Factory.getDefaultModel());
    }

    public static void delete(String uri, OntModel ontModel) {
        Factory.deleteInstance(uri, ontModel);
    }

    public static void delete(String uri) {
        Factory.deleteInstance(uri);
    }
}

