/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.jexmec.manager;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kantega.jexmec.PluginClassLoaderProvider;
import org.kantega.jexmec.PluginLoader;
import org.kantega.jexmec.PluginManager;
import org.kantega.jexmec.PluginManagerListener;
import org.kantega.jexmec.ServiceKey;
import org.kantega.jexmec.ServiceLocator;
import org.kantega.jexmec.events.PluginClassLoaderEvent;
import org.kantega.jexmec.events.PluginLoadingExceptionEvent;
import org.kantega.jexmec.events.PluginManagerEvent;
import org.kantega.jexmec.events.PluginRegistrationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPluginManager<P>
implements PluginManager<P> {
    private final Class<P> pluginClass;
    private final List<PluginLoader<P>> pluginLoaders = new ArrayList<PluginLoader<P>>();
    private final List<PluginClassLoaderProvider> pluginClassLoaderProviders = new ArrayList<PluginClassLoaderProvider>();
    private final List<ServiceLocator> serviceLocators = new ArrayList<ServiceLocator>();
    private final List<PluginManagerListener<P>> pluginManagerListeners = Collections.synchronizedList(new ArrayList());
    private final ServiceLocator serviceLocator = new CompoundServiceLocator(this.serviceLocators);
    private final PluginRegistry registry = new PluginRegistry(this.serviceLocator);
    private volatile State state = State.UNSTARTED;
    private final List<PluginClassLoaderProvider> defaultPluginClassLoaderProviders = new ArrayList<PluginClassLoaderProvider>();
    private boolean rethrowPluginLoaderExceptions = true;

    public DefaultPluginManager(Class<P> pluginClass) {
        if (!pluginClass.isInterface()) {
            throw new IllegalArgumentException("Plugin class needs to be an interface: " + pluginClass);
        }
        this.pluginClass = pluginClass;
        this.defaultPluginClassLoaderProviders.add(new StaticPluginClassLoaderProvider(this.getClass().getClassLoader()));
    }

    public DefaultPluginManager<P> addPluginClassLoaderProvider(PluginClassLoaderProvider pluginClassLoaderProvider) {
        this.state.assertEquals(State.UNSTARTED, "adding plugin class loader provider " + pluginClassLoaderProvider);
        this.defaultPluginClassLoaderProviders.clear();
        this.pluginClassLoaderProviders.add(pluginClassLoaderProvider);
        return this;
    }

    public DefaultPluginManager<P> addPluginClassLoader(ClassLoader pluginClassloader) {
        return this.addPluginClassLoaderProvider(new StaticPluginClassLoaderProvider(pluginClassloader));
    }

    public DefaultPluginManager<P> addPluginLoader(PluginLoader<P> pluginLoader) {
        this.state.assertEquals(State.UNSTARTED, "adding plugin loader " + pluginLoader);
        this.pluginLoaders.add(pluginLoader);
        return this;
    }

    public DefaultPluginManager<P> addServiceLocator(ServiceLocator serviceLocator) {
        this.state.assertEquals(State.UNSTARTED, "adding service locator " + serviceLocator);
        this.serviceLocators.add(serviceLocator);
        return this;
    }

    public <T> DefaultPluginManager<P> addService(ServiceKey<T> serviceKey, T service) {
        return this.addServiceLocator(new StaticServiceLocator(serviceKey, service));
    }

    public <S> S createServicesInstance(Class<S> servicesClass) {
        return servicesClass.cast(Proxy.newProxyInstance(DefaultPluginManager.class.getClassLoader(), new Class[]{servicesClass}, new InvocationHandler(){

            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                ServiceKey key = objects == null ? ServiceKey.by(method.getReturnType()) : ServiceKey.by(method.getReturnType(), (String)((Enum)objects[0]).name());
                return DefaultPluginManager.this.serviceLocator.lookupService(key);
            }
        }));
    }

    ClassLoader createPluginResourceHidingClassLoader(ClassLoader parent) {
        return new ResourceHidingClassLoader(parent, this.pluginClass);
    }

    public <P, T extends Iterable<P>> T createPluginIterable(Class<T> pluginCollectionClass) {
        return (T)((Iterable)Proxy.newProxyInstance(DefaultPluginManager.class.getClassLoader(), new Class[]{pluginCollectionClass}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke(method.getName().equals("iterator") ? DefaultPluginManager.this.getPlugins() : this, args);
            }
        }));
    }

    private void addDefaults() {
        this.pluginClassLoaderProviders.addAll(this.defaultPluginClassLoaderProviders);
    }

    public synchronized DefaultPluginManager<P> start() {
        this.state.assertEquals(State.UNSTARTED, "starting plugin manager");
        for (PluginManagerListener<P> listener : this.pluginManagerListeners) {
            listener.beforePluginManagerStarted(new DefaultPluginManagerEvent(this));
        }
        this.state = State.STARTING;
        this.addDefaults();
        this.startPluginLoaders();
        this.startPluginClassLoaderProviders();
        this.state = State.STARTED;
        for (PluginManagerListener<P> listener : this.pluginManagerListeners) {
            listener.afterPluginManagerStarted(new DefaultPluginManagerEvent(this));
        }
        return this;
    }

    public synchronized DefaultPluginManager<P> stop() {
        this.state.assertEquals(State.STARTED, "stopping plugin manager");
        for (PluginManagerListener<P> listener : this.pluginManagerListeners) {
            listener.beforePluginManagerStopped(new DefaultPluginManagerEvent(this));
        }
        this.state = State.STOPPING;
        this.stopPluginClassLoaderProviders();
        this.stopPluginLoaders();
        this.state = State.STOPPED;
        for (PluginManagerListener<P> listener : this.pluginManagerListeners) {
            listener.afterPluginManagerStopped(new DefaultPluginManagerEvent(this));
        }
        return this;
    }

    private void startPluginClassLoaderProviders() {
        ResourceHidingClassLoader parentClassLoader = new ResourceHidingClassLoader(this.getClass().getClassLoader(), this.pluginClass);
        for (PluginClassLoaderProvider provider : this.pluginClassLoaderProviders) {
            provider.start((PluginClassLoaderProvider.Registry)new ProviderAwarePluginClassLoaderRegistry(provider, this.registry), (ClassLoader)parentClassLoader);
        }
    }

    private void startPluginLoaders() {
        for (PluginLoader<P> pluginLoader : this.pluginLoaders) {
            pluginLoader.start();
        }
    }

    private void stopPluginLoaders() {
        for (PluginLoader<P> pluginLoader : this.pluginLoaders) {
            pluginLoader.stop();
        }
    }

    private void stopPluginClassLoaderProviders() {
        for (PluginClassLoaderProvider provider : this.pluginClassLoaderProviders) {
            provider.stop();
        }
    }

    public List<P> getPlugins() {
        this.state.assertEquals(State.STARTED, "getting plugins. You need to call start() *before* calling getPlugins()");
        return Collections.unmodifiableList(this.registry.getPlugins());
    }

    public void addPluginManagerListener(PluginManagerListener<P> listener) {
        this.pluginManagerListeners.add(listener);
    }

    public void removePluginManagerListener(PluginManagerListener<P> listener) {
        this.pluginManagerListeners.remove(listener);
    }

    public ClassLoader getClassLoader(P plugin) {
        return this.registry.getClassLoader(plugin);
    }

    public void setRethrowPluginLoaderExceptions(boolean rethrowPluginLoaderExceptions) {
        this.rethrowPluginLoaderExceptions = rethrowPluginLoaderExceptions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultPluginLoadingExceptionEvent<P>
    extends DefaultPluginClassLoaderEvent<P>
    implements PluginLoadingExceptionEvent<P> {
        private final PluginLoader<P> pluginLoader;
        private final Throwable throwable;

        DefaultPluginLoadingExceptionEvent(DefaultPluginManager<P> pluginManger, PluginClassLoaderProvider provider, ClassLoader classLoader, PluginLoader<P> pluginLoader, Throwable throwable) {
            super(pluginManger, provider, classLoader);
            this.pluginLoader = pluginLoader;
            this.throwable = throwable;
        }

        public PluginLoader<P> getPluginLoader() {
            return this.pluginLoader;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultPluginRegistrationEvent<P>
    extends DefaultPluginClassLoaderEvent<P>
    implements PluginRegistrationEvent<P> {
        private final List<P> plugins;
        private final PluginLoader<P> pluginLoader;

        DefaultPluginRegistrationEvent(DefaultPluginManager<P> pluginManger, PluginClassLoaderProvider provider, ClassLoader classLoader, PluginLoader<P> pluginLoader, List<P> plugins) {
            super(pluginManger, provider, classLoader);
            this.plugins = plugins;
            this.pluginLoader = pluginLoader;
        }

        public List<P> getPlugins() {
            return this.plugins;
        }

        public PluginLoader<P> getPluginLoader() {
            return this.pluginLoader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultPluginClassLoaderEvent<P>
    extends DefaultPluginManagerEvent<P>
    implements PluginClassLoaderEvent<P> {
        private final PluginClassLoaderProvider provider;
        private final ClassLoader classLoader;

        public DefaultPluginClassLoaderEvent(DefaultPluginManager<P> pluginManger, PluginClassLoaderProvider provider, ClassLoader classLoader) {
            super(pluginManger);
            this.provider = provider;
            this.classLoader = classLoader;
        }

        public PluginClassLoaderProvider getProvider() {
            return this.provider;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultPluginManagerEvent<P>
    implements PluginManagerEvent<P> {
        private final DefaultPluginManager<P> pluginManger;

        public DefaultPluginManagerEvent(DefaultPluginManager<P> pluginManger) {
            this.pluginManger = pluginManger;
        }

        public DefaultPluginManager<P> getPluginManager() {
            return this.pluginManger;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNSTARTED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;


        public void assertEquals(State expected, String when) {
            if (this != expected) {
                throw new IllegalStateException("Illegal state " + (Object)((Object)this) + ". Expected " + (Object)((Object)expected) + " when " + when);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProviderAwarePluginClassLoaderRegistry
    implements PluginClassLoaderProvider.Registry {
        private static final ThreadLocal<PluginClassLoaderProvider> providerThreadLocal = new ThreadLocal();
        private final PluginClassLoaderProvider wrappedProvider;
        private final PluginClassLoaderProvider.Registry wrappedRegistry;

        public ProviderAwarePluginClassLoaderRegistry(PluginClassLoaderProvider wrappedProvider, PluginClassLoaderProvider.Registry wrappedRegistry) {
            this.wrappedProvider = wrappedProvider;
            this.wrappedRegistry = wrappedRegistry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ClassLoader> void add(Iterable<T> classLoaders) {
            providerThreadLocal.set(this.wrappedProvider);
            try {
                this.wrappedRegistry.add(classLoaders);
            }
            finally {
                providerThreadLocal.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ClassLoader> void remove(Iterable<T> classLoaders) {
            providerThreadLocal.set(this.wrappedProvider);
            try {
                this.wrappedRegistry.remove(classLoaders);
            }
            finally {
                providerThreadLocal.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ClassLoader> void replace(Iterable<T> removeClassLoaders, Iterable<T> addClassLoaders) {
            try {
                providerThreadLocal.set(this.wrappedProvider);
                this.wrappedRegistry.replace(removeClassLoaders, addClassLoaders);
            }
            finally {
                providerThreadLocal.remove();
            }
        }

        public static PluginClassLoaderProvider getCurrentProvider() {
            return providerThreadLocal.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResourceHidingClassLoader
    extends ClassLoader {
        private final String[] localResourcePrefixes;

        public ResourceHidingClassLoader(ClassLoader parent, Class pluginClass) {
            super(parent);
            this.localResourcePrefixes = new String[]{"META-INF/services/" + pluginClass.getSimpleName() + "/", "META-INF/services/" + pluginClass.getName() + "/"};
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            URL resource = this.getResource(name);
            try {
                return resource == null ? null : resource.openStream();
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public URL getResource(String name) {
            if (this.isLocalResource(name)) {
                return super.findResource(name);
            }
            return super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (this.isLocalResource(name)) {
                return super.findResources(name);
            }
            return super.getResources(name);
        }

        protected boolean isLocalResource(String name) {
            for (String localResourcePrefix : this.localResourcePrefixes) {
                if (!name.startsWith(localResourcePrefix)) continue;
                return true;
            }
            return false;
        }
    }

    private static class StaticPluginClassLoaderProvider
    implements PluginClassLoaderProvider {
        private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        private PluginClassLoaderProvider.Registry registry;

        public StaticPluginClassLoaderProvider(ClassLoader ... classLoaders) {
            this.classLoaders.addAll(Arrays.asList(classLoaders));
        }

        public void start(PluginClassLoaderProvider.Registry registry, ClassLoader parentClassLoader) {
            this.registry = registry;
            registry.add(this.classLoaders);
        }

        public void stop() {
            this.registry.remove(this.classLoaders);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StaticServiceLocator
    implements ServiceLocator {
        private final Map<ServiceKey, Object> services;

        public StaticServiceLocator(ServiceKey serviceKey, Object service) {
            this.services = Collections.singletonMap(serviceKey, service);
        }

        public Set<ServiceKey> getServiceKeys() {
            return this.services.keySet();
        }

        public <T> T lookupService(ServiceKey<T> serviceKey) {
            return serviceKey.getServiceType().cast(this.services.get(serviceKey));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompoundServiceLocator
    implements ServiceLocator {
        private final Collection<ServiceLocator> serviceLocators;

        public CompoundServiceLocator(Collection<ServiceLocator> serviceLocators) {
            this.serviceLocators = serviceLocators;
        }

        public Set<ServiceKey> getServiceKeys() {
            HashSet<ServiceKey> serviceKeys = new HashSet<ServiceKey>();
            for (ServiceLocator serviceLocator : this.serviceLocators) {
                serviceKeys.addAll(serviceLocator.getServiceKeys());
            }
            return serviceKeys;
        }

        public <T> T lookupService(ServiceKey<T> serviceKey) {
            ServiceLocator first = null;
            Iterator<ServiceLocator> i = this.serviceLocators.iterator();
            while (first == null && i.hasNext()) {
                ServiceLocator candidate = i.next();
                first = candidate.getServiceKeys().contains(serviceKey) ? candidate : null;
            }
            return (T)(first != null ? first.lookupService(serviceKey) : null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PluginRegistry
    implements PluginClassLoaderProvider.Registry {
        private final ServiceLocator serviceLocator;
        private final Map<ClassLoader, Map<PluginLoader<P>, List<P>>> plugins = new LinkedHashMap();
        private final Map<P, ClassLoader> classLoaderMap = new HashMap();

        public PluginRegistry(ServiceLocator serviceLocator) {
            this.serviceLocator = serviceLocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ClassLoader> void replace(Iterable<T> removeClassLoaders, Iterable<T> addClassLoaders) {
            Iterator<Object> i$;
            PluginClassLoaderProvider provider = ProviderAwarePluginClassLoaderRegistry.getCurrentProvider();
            PluginRegistry pluginRegistry = this;
            synchronized (pluginRegistry) {
                for (ClassLoader loader : removeClassLoaders) {
                    if (this.plugins.containsKey(loader)) continue;
                    throw new IllegalArgumentException("Illegal request to remove a class loader that isn't currently registered: " + loader);
                }
            }
            for (ClassLoader loader : removeClassLoaders) {
                Map pluginsRemoved;
                PluginRegistry listener22;
                for (PluginRegistry listener22 : DefaultPluginManager.this.pluginManagerListeners) {
                    listener22.beforeClassLoaderRemoved(new DefaultPluginClassLoaderEvent(DefaultPluginManager.this, provider, loader));
                }
                listener22 = this;
                synchronized (listener22) {
                    pluginsRemoved = this.plugins.get(loader);
                }
                for (PluginLoader pluginLoader : pluginsRemoved.keySet()) {
                    for (PluginManagerListener listener3 : DefaultPluginManager.this.pluginManagerListeners) {
                        listener3.beforePassivation(new DefaultPluginRegistrationEvent(DefaultPluginManager.this, provider, loader, pluginLoader, pluginsRemoved.get(pluginLoader)));
                    }
                }
                i$ = this;
                synchronized (i$) {
                    for (PluginLoader pluginLoader : pluginsRemoved.keySet()) {
                        for (Object plugin : pluginsRemoved.get(pluginLoader)) {
                            this.classLoaderMap.remove(plugin);
                        }
                    }
                    this.plugins.remove(loader);
                }
                for (PluginLoader pluginLoader : pluginsRemoved.keySet()) {
                    for (PluginManagerListener listener : DefaultPluginManager.this.pluginManagerListeners) {
                        listener.afterPassivation(new DefaultPluginRegistrationEvent(DefaultPluginManager.this, provider, loader, pluginLoader, pluginsRemoved.get(pluginLoader)));
                    }
                }
                this.unloadPluginsFromClassLoader(loader);
                for (PluginManagerListener pluginManagerListener : DefaultPluginManager.this.pluginManagerListeners) {
                    pluginManagerListener.afterClassLoaderRemoved(new DefaultPluginClassLoaderEvent(DefaultPluginManager.this, provider, loader));
                }
            }
            for (ClassLoader classLoader : addClassLoaders) {
                for (PluginManagerListener listener : DefaultPluginManager.this.pluginManagerListeners) {
                    listener.beforeClassLoaderAdded(new DefaultPluginClassLoaderEvent(DefaultPluginManager.this, provider, classLoader));
                }
                LinkedHashMap<PluginLoader, List> loadedPlugins = new LinkedHashMap<PluginLoader, List>();
                for (PluginLoader pluginLoader : DefaultPluginManager.this.pluginLoaders) {
                    try {
                        loadedPlugins.put(pluginLoader, pluginLoader.loadPlugins(DefaultPluginManager.this.pluginClass, classLoader, this.serviceLocator));
                    }
                    catch (Throwable e) {
                        this.fireExceptionLoadingPlugins(provider, classLoader, pluginLoader, e);
                        if (!DefaultPluginManager.this.rethrowPluginLoaderExceptions) continue;
                        throw new RuntimeException("Plugin loader " + pluginLoader + " threw " + e.getClass().getSimpleName() + " loading plugins from class loader " + classLoader, e);
                    }
                }
                for (PluginLoader pluginLoader : loadedPlugins.keySet()) {
                    if (((List)loadedPlugins.get(pluginLoader)).size() <= 0) continue;
                    for (PluginManagerListener listener : DefaultPluginManager.this.pluginManagerListeners) {
                        listener.beforeActivation(new DefaultPluginRegistrationEvent(DefaultPluginManager.this, provider, classLoader, pluginLoader, (List)loadedPlugins.get(pluginLoader)));
                    }
                }
                i$ = this;
                synchronized (i$) {
                    ArrayList arrayList = new ArrayList();
                    for (PluginLoader pluginLoader : loadedPlugins.keySet()) {
                        arrayList.addAll((Collection)loadedPlugins.get(pluginLoader));
                    }
                    for (Object plugin : arrayList) {
                        this.classLoaderMap.put(plugin, classLoader);
                    }
                    this.plugins.put(classLoader, loadedPlugins);
                }
                for (PluginLoader pluginLoader : loadedPlugins.keySet()) {
                    if (((List)loadedPlugins.get(pluginLoader)).size() <= 0) continue;
                    for (PluginManagerListener listener : DefaultPluginManager.this.pluginManagerListeners) {
                        listener.afterActivation(new DefaultPluginRegistrationEvent(DefaultPluginManager.this, provider, classLoader, pluginLoader, (List)loadedPlugins.get(pluginLoader)));
                    }
                }
                for (PluginManagerListener pluginManagerListener : DefaultPluginManager.this.pluginManagerListeners) {
                    pluginManagerListener.afterClassLoaderAdded(new DefaultPluginClassLoaderEvent(DefaultPluginManager.this, provider, classLoader));
                }
            }
            this.firePluginsUpdated();
        }

        public <T extends ClassLoader> void add(Iterable<T> classLoaders) {
            this.replace(Collections.emptySet(), classLoaders);
        }

        public <T extends ClassLoader> void remove(Iterable<T> loaders) {
            this.replace(loaders, Collections.emptySet());
        }

        private void fireExceptionLoadingPlugins(PluginClassLoaderProvider provider, ClassLoader classLoader, PluginLoader<P> pluginLoader, Throwable e) {
            for (PluginManagerListener listener : DefaultPluginManager.this.pluginManagerListeners) {
                listener.pluginLoadingFailedWithException(new DefaultPluginLoadingExceptionEvent(DefaultPluginManager.this, provider, classLoader, pluginLoader, e));
            }
        }

        private void unloadPluginsFromClassLoader(ClassLoader loader) {
            for (PluginLoader pluginLoader : DefaultPluginManager.this.pluginLoaders) {
                pluginLoader.unloadPlugins(loader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<P> getPlugins() {
            ArrayList plugins = new ArrayList();
            PluginRegistry pluginRegistry = this;
            synchronized (pluginRegistry) {
                for (Map map : this.plugins.values()) {
                    for (PluginLoader pluginLoader : map.keySet()) {
                        plugins.addAll(map.get(pluginLoader));
                    }
                }
            }
            return plugins;
        }

        public ClassLoader getClassLoader(P plugin) {
            return this.classLoaderMap.get(plugin);
        }

        private void firePluginsUpdated() {
            for (PluginManagerListener listener : DefaultPluginManager.this.pluginManagerListeners) {
                listener.pluginsUpdated(DefaultPluginManager.this.registry.getPlugins());
            }
        }
    }
}

