/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.jexmec.ctor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.kantega.jexmec.ctor.InvalidPluginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLocator<T extends Class> {
    private final String[] servicesFiles;

    public ClassLocator(String ... servicesFiles) {
        this.servicesFiles = new String[servicesFiles.length];
        System.arraycopy(servicesFiles, 0, this.servicesFiles, 0, servicesFiles.length);
    }

    public ClassLocator(Class pluginClass, String filename) {
        this("META-INF/services/" + pluginClass.getName() + "/" + filename, "META-INF/services/" + pluginClass.getSimpleName() + "/" + filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> locateClasses(ClassLoader classLoader) {
        ArrayList classes = new ArrayList();
        try {
            for (String serviceFile : this.servicesFiles) {
                Enumeration<URL> resources = classLoader.getResources(serviceFile);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    InputStream inputStream = null;
                    InputStreamReader inputStreamReader = null;
                    BufferedReader bufferedReader = null;
                    try {
                        String className;
                        inputStream = url.openStream();
                        inputStreamReader = new InputStreamReader(inputStream, "utf-8");
                        bufferedReader = new BufferedReader(inputStreamReader);
                        while ((className = bufferedReader.readLine()) != null) {
                            if ((className = className.trim()).length() <= 0) continue;
                            try {
                                Class<?> clazz = classLoader.loadClass(className);
                                classes.add(clazz);
                            }
                            catch (ClassNotFoundException e) {
                                throw new InvalidPluginException("Plugin descriptor " + url + " specifies a class that can't be found: " + className, e, null);
                            }
                        }
                    }
                    finally {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
            return classes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

