/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlugin
extends Plugin {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private List<String> customizationURIs;
    private Set<QName> customizationElementNames;

    public void onActivated(Options options) throws BadCommandLineException {
        super.onActivated(options);
        try {
            this.init(options);
        }
        catch (Exception ex) {
            throw new BadCommandLineException("Could not initialize the plugin [" + this.getOptionName() + "].", (Throwable)ex);
        }
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) throws SAXException {
        try {
            this.beforeRun(outline, options);
            boolean bl = this.run(outline, options);
            return bl;
        }
        catch (Exception ex) {
            SAXParseException saxex = new SAXParseException("Error during plugin execution.", null, ex);
            errorHandler.error(saxex);
            throw saxex;
        }
        finally {
            try {
                this.afterRun(outline, options);
            }
            catch (Exception ex) {
                SAXParseException saxex = new SAXParseException("Error during plugin execution.", null, ex);
                errorHandler.error(saxex);
                throw saxex;
            }
        }
    }

    protected void beforeRun(Outline outline, Options options) throws Exception {
    }

    protected boolean run(Outline outline, Options options) throws Exception {
        return true;
    }

    protected void afterRun(Outline outline, Options options) throws Exception {
    }

    protected void init(Options options) throws Exception {
    }

    public Collection<QName> getCustomizationElementNames() {
        return Collections.emptyList();
    }

    public List<String> getCustomizationURIs() {
        if (this.customizationURIs == null) {
            Collection<QName> customizationElementNames = this.getCustomizationElementNames();
            this.customizationURIs = new ArrayList<String>(customizationElementNames.size());
            for (QName customizationElementName : customizationElementNames) {
                String namespaceURI = customizationElementName.getNamespaceURI();
                if (StringUtils.isEmpty((String)namespaceURI)) continue;
                this.customizationURIs.add(namespaceURI);
            }
        }
        return this.customizationURIs;
    }

    public boolean isCustomizationTagName(String namespaceURI, String localName) {
        if (this.customizationElementNames == null) {
            this.customizationElementNames = new HashSet<QName>(this.getCustomizationElementNames());
        }
        return this.customizationElementNames.contains(new QName(namespaceURI, localName));
    }
}

